/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.asset.Asset;
import haveno.asset.AssetRegistry;
import haveno.common.config.Config;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.api.CoreAccountService;
import haveno.core.api.model.PaymentAccountForm;
import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.AssetAccount;
import haveno.core.payment.CryptoCurrencyAccount;
import haveno.core.payment.InstantCryptoCurrencyAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountFactory;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.validation.InteracETransferValidator;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.User;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CorePaymentAccountsService {
    private static final Logger log = LoggerFactory.getLogger(CorePaymentAccountsService.class);
    private final CoreAccountService accountService;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final User user;
    public final InteracETransferValidator interacETransferValidator;

    @Inject
    public CorePaymentAccountsService(CoreAccountService accountService, AccountAgeWitnessService accountAgeWitnessService, User user, InteracETransferValidator interacETransferValidator) {
        this.accountService = accountService;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.user = user;
        this.interacETransferValidator = interacETransferValidator;
        HavenoUtils.corePaymentAccountService = this;
    }

    PaymentAccount createPaymentAccount(PaymentAccountForm form) {
        this.validateFormFields(form);
        PaymentAccount paymentAccount = form.toPaymentAccount();
        CorePaymentAccountsService.setSelectedTradeCurrency(paymentAccount);
        this.verifyPaymentAccountHasRequiredFields(paymentAccount);
        if (paymentAccount instanceof CryptoCurrencyAccount) {
            CryptoCurrencyAccount cryptoAccount = (CryptoCurrencyAccount)paymentAccount;
            this.verifyCryptoCurrencyAddress(cryptoAccount.getSingleTradeCurrency().getCode(), cryptoAccount.getAddress());
        }
        this.user.addPaymentAccountIfNotExists(paymentAccount);
        this.accountAgeWitnessService.publishMyAccountAgeWitness(paymentAccount.getPaymentAccountPayload());
        log.info("Saved payment account with id {} and payment method {}.", (Object)paymentAccount.getId(), (Object)paymentAccount.getPaymentAccountPayload().getPaymentMethodId());
        return paymentAccount;
    }

    private static void setSelectedTradeCurrency(PaymentAccount paymentAccount) {
        TradeCurrency singleTradeCurrency = paymentAccount.getSingleTradeCurrency();
        List<TradeCurrency> tradeCurrencies = paymentAccount.getTradeCurrencies();
        if (singleTradeCurrency != null) {
            paymentAccount.setSelectedTradeCurrency(singleTradeCurrency);
        } else if (tradeCurrencies != null && !tradeCurrencies.isEmpty()) {
            if (tradeCurrencies.contains(CurrencyUtil.getDefaultTradeCurrency())) {
                paymentAccount.setSelectedTradeCurrency(CurrencyUtil.getDefaultTradeCurrency());
            } else {
                paymentAccount.setSelectedTradeCurrency(tradeCurrencies.get(0));
            }
        }
    }

    PaymentAccount getPaymentAccount(String paymentAccountId) {
        return this.user.getPaymentAccount(paymentAccountId);
    }

    Set<PaymentAccount> getPaymentAccounts() {
        return this.user.getPaymentAccounts();
    }

    List<PaymentMethod> getPaymentMethods() {
        return PaymentMethod.getPaymentMethods().stream().sorted(Comparator.comparing(PaymentMethod::getId)).collect(Collectors.toList());
    }

    PaymentAccountForm getPaymentAccountForm(String paymentMethodId) {
        return PaymentAccountForm.getForm(paymentMethodId.toUpperCase());
    }

    PaymentAccountForm getPaymentAccountForm(PaymentAccount paymentAccount) {
        return paymentAccount.toForm();
    }

    String getPaymentAccountFormAsString(String paymentMethodId) {
        File jsonForm = this.getPaymentAccountFormFile(paymentMethodId);
        jsonForm.deleteOnExit();
        return PaymentAccountForm.toJsonString(jsonForm);
    }

    File getPaymentAccountFormFile(String paymentMethodId) {
        return PaymentAccountForm.getPaymentAccountForm(paymentMethodId);
    }

    synchronized PaymentAccount createCryptoCurrencyPaymentAccount(String accountName, String currencyCode, String address, boolean tradeInstant) {
        this.accountService.checkAccountOpen();
        this.verifyAccountNameUnique(accountName);
        this.verifyCryptoCurrencyAddress(currencyCode.toUpperCase(), address);
        AssetAccount cryptoCurrencyAccount = tradeInstant ? (InstantCryptoCurrencyAccount)PaymentAccountFactory.getPaymentAccount(PaymentMethod.BLOCK_CHAINS_INSTANT) : (CryptoCurrencyAccount)PaymentAccountFactory.getPaymentAccount(PaymentMethod.BLOCK_CHAINS);
        cryptoCurrencyAccount.init();
        cryptoCurrencyAccount.setAccountName(accountName);
        cryptoCurrencyAccount.setAddress(address);
        Optional<CryptoCurrency> cryptoCurrency = CurrencyUtil.getCryptoCurrency(currencyCode.toUpperCase());
        cryptoCurrency.ifPresent(cryptoCurrencyAccount::setSingleTradeCurrency);
        this.user.addPaymentAccount(cryptoCurrencyAccount);
        log.info("Saved crypto payment account with id {} and payment method {}.", (Object)cryptoCurrencyAccount.getId(), (Object)cryptoCurrencyAccount.getPaymentAccountPayload().getPaymentMethodId());
        return cryptoCurrencyAccount;
    }

    synchronized void deletePaymentAccount(String paymentAccountId) {
        this.accountService.checkAccountOpen();
        PaymentAccount paymentAccount = this.getPaymentAccount(paymentAccountId);
        if (paymentAccount == null) {
            throw new IllegalArgumentException(String.format("Payment account with id %s not found", paymentAccountId));
        }
        this.user.removePaymentAccount(paymentAccount);
        log.info("Deleted payment account with id {} and payment method {}.", (Object)paymentAccount.getId(), (Object)paymentAccount.getPaymentAccountPayload().getPaymentMethodId());
    }

    List<PaymentMethod> getCryptoCurrencyPaymentMethods() {
        return PaymentMethod.getPaymentMethods().stream().filter(PaymentMethod::isCrypto).sorted(Comparator.comparing(PaymentMethod::getId)).collect(Collectors.toList());
    }

    private void validateFormFields(PaymentAccountForm form) {
        for (PaymentAccountFormField field : form.getFields()) {
            this.validateFormField(form, field.getId(), field.getValue());
        }
    }

    void validateFormField(PaymentAccountForm form, PaymentAccountFormField.FieldId fieldId, String value) {
        PaymentAccountForm.FormId formId = form.getId();
        PaymentAccount paymentAccount = PaymentAccountFactory.getPaymentAccount(PaymentMethod.getPaymentMethod(formId.toString()));
        paymentAccount.validateFormField(form, fieldId, value);
    }

    private void verifyAccountNameUnique(String accountName) {
        if (this.getPaymentAccounts().stream().anyMatch(e -> e.getAccountName() != null && e.getAccountName().equals(accountName))) {
            throw new IllegalArgumentException(String.format("Account '%s' is already taken", accountName));
        }
    }

    private void verifyCryptoCurrencyAddress(String cryptoCurrencyCode, String address) {
        Asset asset = this.getAsset(cryptoCurrencyCode);
        if (!asset.validateAddress(address).isValid()) {
            throw new IllegalArgumentException(String.format("%s is not a valid %s address", address, cryptoCurrencyCode.toLowerCase()));
        }
    }

    private Asset getAsset(String cryptoCurrencyCode) {
        return CurrencyUtil.findAsset(new AssetRegistry(), cryptoCurrencyCode, Config.baseCurrencyNetwork()).orElseThrow(() -> new IllegalStateException(String.format("crypto currency with code '%s' not found", cryptoCurrencyCode.toLowerCase())));
    }

    private void verifyPaymentAccountHasRequiredFields(PaymentAccount paymentAccount) {
        if (!paymentAccount.hasMultipleCurrencies() && paymentAccount.getSingleTradeCurrency() == null) {
            throw new IllegalArgumentException(String.format("no trade currency defined for %s payment account", paymentAccount.getPaymentMethod().getDisplayString().toLowerCase()));
        }
    }
}

