/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class CoreHelpService {
    private static final Logger log = LoggerFactory.getLogger(CoreHelpService.class);

    @Inject
    public CoreHelpService() {
    }

    public String getMethodHelp(String methodName) {
        String resourceFile = "/help" + File.separator + methodName + "-help.txt";
        try {
            return this.readHelpFile(resourceFile);
        }
        catch (NullPointerException ex) {
            log.error("", (Throwable)ex);
            throw new IllegalStateException(String.format("no help found for api method %s", methodName));
        }
        catch (IOException ex) {
            log.error("", (Throwable)ex);
            throw new IllegalStateException(String.format("could not read %s help doc", methodName));
        }
    }

    private String readHelpFile(String resourceFile) throws NullPointerException, IOException {
        String line;
        InputStream is = this.getClass().getResourceAsStream(resourceFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder builder = new StringBuilder();
        while ((line = br.readLine()) != null) {
            builder.append(line).append("\n");
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        CoreHelpService coreHelpService = new CoreHelpService();
        System.out.println(coreHelpService.getMethodHelp("getversion"));
    }
}

