/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.handlers.FaultHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Attachment;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.DisputeSummaryVerification;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.util.FormattingUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CoreDisputesService {
    private static final Logger log = LoggerFactory.getLogger(CoreDisputesService.class);
    private final ArbitrationManager arbitrationManager;
    private final CoinFormatter formatter;
    private final KeyRing keyRing;
    private final TradeManager tradeManager;

    @Inject
    public CoreDisputesService(ArbitrationManager arbitrationManager, @Named(value="BTC") CoinFormatter formatter, KeyRing keyRing, TradeManager tradeManager, XmrWalletService xmrWalletService) {
        this.arbitrationManager = arbitrationManager;
        this.formatter = formatter;
        this.keyRing = keyRing;
        this.tradeManager = tradeManager;
    }

    public List<Dispute> getDisputes() {
        return new ArrayList<Dispute>((Collection<Dispute>)this.arbitrationManager.getDisputesAsObservableList());
    }

    public Dispute getDispute(String tradeId) {
        Optional<Dispute> dispute = this.arbitrationManager.findDispute(tradeId);
        if (dispute.isPresent()) {
            return dispute.get();
        }
        throw new IllegalStateException(String.format("dispute for trade id '%s' not found", tradeId));
    }

    public void openDispute(String tradeId, ResultHandler resultHandler, FaultHandler faultHandler) {
        Trade trade = this.tradeManager.getOpenTrade(tradeId).orElseThrow(() -> new IllegalArgumentException(String.format("trade with id '%s' not found", tradeId)));
        Offer offer = trade.getOffer();
        if (offer == null) {
            throw new IllegalStateException(String.format("offer with tradeId '%s' is null", tradeId));
        }
        ArbitrationManager disputeManager = this.arbitrationManager;
        boolean isSupportTicket = false;
        boolean isMaker = this.tradeManager.isMyOffer(offer);
        Dispute dispute = this.createDisputeForTrade(trade, offer, this.keyRing.getPubKeyRing(), isMaker, isSupportTicket);
        disputeManager.sendDisputeOpenedMessage(dispute, resultHandler, faultHandler);
        this.tradeManager.requestPersistence();
    }

    public Dispute createDisputeForTrade(Trade trade, Offer offer, PubKeyRing pubKey, boolean isMaker, boolean isSupportTicket) {
        byte[] payoutTxSerialized = null;
        String payoutTxHashAsString = null;
        PubKeyRing arbitratorPubKeyRing = trade.getArbitrator().getPubKeyRing();
        Preconditions.checkNotNull((Object)arbitratorPubKeyRing, (Object)"arbitratorPubKeyRing must not be null");
        Dispute dispute = new Dispute(new Date().getTime(), trade.getId(), pubKey.hashCode(), true, offer.getDirection() == OfferDirection.BUY == isMaker, isMaker, pubKey, trade.getDate().getTime(), trade.getMaxTradePeriodDate().getTime(), trade.getContract(), trade.getContractHash(), payoutTxSerialized, payoutTxHashAsString, trade.getContractAsJson(), trade.getMaker().getContractSignature(), trade.getTaker().getContractSignature(), trade.getMaker().getPaymentAccountPayload(), trade.getTaker().getPaymentAccountPayload(), arbitratorPubKeyRing, isSupportTicket, SupportType.ARBITRATION);
        return dispute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveDispute(String tradeId, DisputeResult.Winner winner, DisputeResult.Reason reason, String summaryNotes, long customWinnerAmount) {
        Trade trade = this.tradeManager.getTrade(tradeId);
        Optional<Dispute> winningDisputeOptional = this.arbitrationManager.getDisputesAsObservableList().stream().filter(d -> tradeId.equals(d.getTradeId())).filter(d -> trade.getTradePeer(d.getTraderPubKeyRing()) == (winner == DisputeResult.Winner.BUYER ? trade.getBuyer() : trade.getSeller())).findFirst();
        if (!winningDisputeOptional.isPresent()) {
            throw new IllegalStateException(String.format("dispute for tradeId '%s' not found", tradeId));
        }
        Dispute winningDispute = winningDisputeOptional.get();
        Object object = trade.getLock();
        synchronized (object) {
            try {
                PayoutSuggestion payoutSuggestion;
                Date closeDate = new Date();
                DisputeResult winnerDisputeResult = this.createDisputeResult(winningDispute, winner, reason, summaryNotes, closeDate);
                if (customWinnerAmount > 0L) {
                    payoutSuggestion = PayoutSuggestion.CUSTOM;
                } else if (winner == DisputeResult.Winner.BUYER) {
                    payoutSuggestion = PayoutSuggestion.BUYER_GETS_TRADE_AMOUNT;
                } else if (winner == DisputeResult.Winner.SELLER) {
                    payoutSuggestion = PayoutSuggestion.SELLER_GETS_TRADE_AMOUNT;
                } else {
                    throw new IllegalStateException("Unexpected DisputeResult.Winner: " + String.valueOf((Object)winner));
                }
                this.applyPayoutAmountsToDisputeResult(payoutSuggestion, winningDispute, winnerDisputeResult, customWinnerAmount);
                this.closeDisputeTicket(this.arbitrationManager, winningDispute, winnerDisputeResult, () -> this.arbitrationManager.requestPersistence(), (errMessage, err) -> {
                    throw new IllegalStateException(errMessage, err);
                });
                Optional<Dispute> loserDisputeOptional = this.arbitrationManager.getDisputesAsObservableList().stream().filter(d -> tradeId.equals(d.getTradeId()) && winningDispute.getTraderId() != d.getTraderId()).findFirst();
                if (!loserDisputeOptional.isPresent()) {
                    throw new IllegalStateException("could not find peer dispute");
                }
                Dispute loserDispute = loserDisputeOptional.get();
                DisputeResult loserDisputeResult = this.createDisputeResult(loserDispute, winner, reason, summaryNotes, closeDate);
                loserDisputeResult.setBuyerPayoutAmountBeforeCost(winnerDisputeResult.getBuyerPayoutAmountBeforeCost());
                loserDisputeResult.setSellerPayoutAmountBeforeCost(winnerDisputeResult.getSellerPayoutAmountBeforeCost());
                loserDisputeResult.setSubtractFeeFrom(winnerDisputeResult.getSubtractFeeFrom());
                this.closeDisputeTicket(this.arbitrationManager, loserDispute, loserDisputeResult, () -> this.arbitrationManager.requestPersistence(), (errMessage, err) -> {
                    throw new IllegalStateException(errMessage, err);
                });
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new IllegalStateException((String)(e.getMessage() == null ? "Error resolving dispute for trade " + trade.getId() : e.getMessage()));
            }
        }
    }

    private DisputeResult createDisputeResult(Dispute dispute, DisputeResult.Winner winner, DisputeResult.Reason reason, String summaryNotes, Date closeDate) {
        DisputeResult disputeResult = new DisputeResult(dispute.getTradeId(), dispute.getTraderId());
        disputeResult.setWinner(winner);
        disputeResult.setReason(reason);
        disputeResult.setSummaryNotes(summaryNotes);
        disputeResult.setCloseDate(closeDate);
        return disputeResult;
    }

    public void applyPayoutAmountsToDisputeResult(PayoutSuggestion payoutSuggestion, Dispute dispute, DisputeResult disputeResult, long customWinnerAmount) {
        Contract contract = dispute.getContract();
        Trade trade = this.tradeManager.getTrade(dispute.getTradeId());
        BigInteger buyerSecurityDeposit = trade.getBuyer().getSecurityDeposit();
        BigInteger sellerSecurityDeposit = trade.getSeller().getSecurityDeposit();
        BigInteger tradeAmount = contract.getTradeAmount();
        disputeResult.setSubtractFeeFrom(DisputeResult.SubtractFeeFrom.BUYER_AND_SELLER);
        if (payoutSuggestion == PayoutSuggestion.BUYER_GETS_TRADE_AMOUNT) {
            disputeResult.setBuyerPayoutAmountBeforeCost(tradeAmount.add(buyerSecurityDeposit));
            disputeResult.setSellerPayoutAmountBeforeCost(sellerSecurityDeposit);
        } else if (payoutSuggestion == PayoutSuggestion.BUYER_GETS_ALL) {
            disputeResult.setBuyerPayoutAmountBeforeCost(tradeAmount.add(buyerSecurityDeposit).add(sellerSecurityDeposit));
            disputeResult.setSellerPayoutAmountBeforeCost(BigInteger.ZERO);
            if (!trade.isPayoutPublished() && disputeResult.getBuyerPayoutAmountBeforeCost().compareTo(trade.getWallet().getBalance()) > 0) {
                log.warn("Payout amount for buyer is more than wallet's balance. This can happen if a deposit tx is dropped. Decreasing payout amount from {} to {}", (Object)HavenoUtils.formatXmr(disputeResult.getBuyerPayoutAmountBeforeCost()), (Object)HavenoUtils.formatXmr(trade.getWallet().getBalance()));
                disputeResult.setBuyerPayoutAmountBeforeCost(trade.getWallet().getBalance());
            }
        } else if (payoutSuggestion == PayoutSuggestion.SELLER_GETS_TRADE_AMOUNT) {
            disputeResult.setBuyerPayoutAmountBeforeCost(buyerSecurityDeposit);
            disputeResult.setSellerPayoutAmountBeforeCost(tradeAmount.add(sellerSecurityDeposit));
        } else if (payoutSuggestion == PayoutSuggestion.SELLER_GETS_ALL) {
            disputeResult.setBuyerPayoutAmountBeforeCost(BigInteger.ZERO);
            disputeResult.setSellerPayoutAmountBeforeCost(tradeAmount.add(sellerSecurityDeposit).add(buyerSecurityDeposit));
            if (!trade.isPayoutPublished() && disputeResult.getSellerPayoutAmountBeforeCost().compareTo(trade.getWallet().getBalance()) > 0) {
                log.warn("Payout amount for seller is more than wallet's balance. This can happen if a deposit tx is dropped. Decreasing payout amount from {} to {}", (Object)HavenoUtils.formatXmr(disputeResult.getSellerPayoutAmountBeforeCost()), (Object)HavenoUtils.formatXmr(trade.getWallet().getBalance()));
                disputeResult.setSellerPayoutAmountBeforeCost(trade.getWallet().getBalance());
            }
        } else if (payoutSuggestion == PayoutSuggestion.CUSTOM) {
            if (!trade.isPayoutPublished() && customWinnerAmount > trade.getWallet().getBalance().longValueExact()) {
                throw new RuntimeException("Winner payout is more than the trade wallet's balance");
            }
            long loserAmount = tradeAmount.add(buyerSecurityDeposit).add(sellerSecurityDeposit).subtract(BigInteger.valueOf(customWinnerAmount)).longValueExact();
            if (loserAmount < 0L) {
                throw new RuntimeException("Loser payout cannot be negative");
            }
            disputeResult.setBuyerPayoutAmountBeforeCost(BigInteger.valueOf(disputeResult.getWinner() == DisputeResult.Winner.BUYER ? customWinnerAmount : loserAmount));
            disputeResult.setSellerPayoutAmountBeforeCost(BigInteger.valueOf(disputeResult.getWinner() == DisputeResult.Winner.BUYER ? loserAmount : customWinnerAmount));
            disputeResult.setSubtractFeeFrom(disputeResult.getWinner() == DisputeResult.Winner.BUYER ? DisputeResult.SubtractFeeFrom.SELLER_ONLY : DisputeResult.SubtractFeeFrom.BUYER_ONLY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDisputeTicket(DisputeManager disputeManager, Dispute dispute, DisputeResult disputeResult, ResultHandler resultHandler, FaultHandler faultHandler) {
        DisputeResult.Reason reason = disputeResult.getReason();
        String role = Res.get("shared.arbitrator");
        String agentNodeAddress = ((NodeAddress)Preconditions.checkNotNull((Object)disputeManager.getAgentNodeAddress(dispute))).getFullAddress();
        Contract contract = dispute.getContract();
        String currencyCode = contract.getOfferPayload().getCurrencyCode();
        String amount = HavenoUtils.formatXmr(contract.getTradeAmount(), true);
        Object textToSign = Res.get("disputeSummaryWindow.close.msg", FormattingUtils.formatDateTime(disputeResult.getCloseDate(), true), role, agentNodeAddress, dispute.getShortTradeId(), currencyCode, Res.get("disputeSummaryWindow.reason." + reason.name()), amount, HavenoUtils.formatXmr(disputeResult.getBuyerPayoutAmountBeforeCost(), true), HavenoUtils.formatXmr(disputeResult.getSellerPayoutAmountBeforeCost(), true), disputeResult.summaryNotesProperty().get());
        ObservableList<ChatMessage> observableList = dispute.getChatMessages();
        synchronized (observableList) {
            if (reason == DisputeResult.Reason.OPTION_TRADE && dispute.getChatMessages().size() > 1 && ((ChatMessage)((Object)dispute.getChatMessages().get(1))).isSystemMessage()) {
                textToSign = (String)textToSign + "\n" + ((ChatMessage)((Object)dispute.getChatMessages().get(1))).getMessage() + "\n";
            }
        }
        String summaryText = DisputeSummaryVerification.signAndApply(disputeManager, disputeResult, (String)textToSign);
        disputeManager.closeDisputeTicket(disputeResult, dispute, summaryText, () -> {
            dispute.setDisputeResult(disputeResult);
            dispute.setIsClosed();
            resultHandler.handleResult();
        }, faultHandler);
    }

    public void sendDisputeChatMessage(String disputeId, String message, ArrayList<Attachment> attachments) {
        Optional<Dispute> disputeOptional = this.arbitrationManager.findDisputeById(disputeId);
        if (!disputeOptional.isPresent()) {
            throw new IllegalStateException(String.format("dispute with id '%s' not found", disputeId));
        }
        Dispute dispute = disputeOptional.get();
        if (!this.arbitrationManager.canSendChatMessages(dispute)) {
            throw new IllegalStateException(String.format("dispute with id '%s' cannot send chat messages (must be open or stored to mailbox)", disputeId));
        }
        ChatMessage chatMessage = new ChatMessage(this.arbitrationManager.getSupportType(), dispute.getTradeId(), dispute.getTraderId(), this.arbitrationManager.isTrader(dispute), message, this.arbitrationManager.getMyAddress(), attachments);
        dispute.addAndPersistChatMessage(chatMessage);
        this.arbitrationManager.sendChatMessage(chatMessage);
    }

    public static enum PayoutSuggestion {
        BUYER_GETS_TRADE_AMOUNT,
        BUYER_GETS_ALL,
        SELLER_GETS_TRADE_AMOUNT,
        SELLER_GETS_ALL,
        CUSTOM;

    }
}

