/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.config.Config;
import haveno.common.crypto.IncorrectPasswordException;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.FaultHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.api.CoreAccountService;
import haveno.core.api.CoreDisputeAgentsService;
import haveno.core.api.CoreDisputesService;
import haveno.core.api.CoreHelpService;
import haveno.core.api.CoreNotificationService;
import haveno.core.api.CoreOffersService;
import haveno.core.api.CorePaymentAccountsService;
import haveno.core.api.CorePriceService;
import haveno.core.api.CoreTradesService;
import haveno.core.api.CoreWalletsService;
import haveno.core.api.NotificationListener;
import haveno.core.api.XmrConnectionService;
import haveno.core.api.XmrLocalNode;
import haveno.core.api.model.AddressBalanceInfo;
import haveno.core.api.model.BalancesInfo;
import haveno.core.api.model.MarketDepthInfo;
import haveno.core.api.model.MarketPriceInfo;
import haveno.core.api.model.PaymentAccountForm;
import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.app.AppStartupState;
import haveno.core.monetary.Price;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOffer;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.support.dispute.Attachment;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.Trade;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.xmr.XmrNodeSettings;
import haveno.proto.grpc.NotificationMessage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import monero.common.MoneroRpcConnection;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroTxWallet;
import org.bitcoinj.core.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CoreApi {
    private static final Logger log = LoggerFactory.getLogger(CoreApi.class);
    private final Config config;
    private final AppStartupState appStartupState;
    private final CoreAccountService coreAccountService;
    private final CoreDisputeAgentsService coreDisputeAgentsService;
    private final CoreDisputesService coreDisputeService;
    private final CoreHelpService coreHelpService;
    private final CoreOffersService coreOffersService;
    private final CorePaymentAccountsService paymentAccountsService;
    private final CorePriceService corePriceService;
    private final CoreTradesService coreTradesService;
    private final CoreWalletsService walletsService;
    private final TradeStatisticsManager tradeStatisticsManager;
    private final CoreNotificationService notificationService;
    private final XmrConnectionService xmrConnectionService;
    private final XmrLocalNode xmrLocalNode;

    @Inject
    public CoreApi(Config config, AppStartupState appStartupState, CoreAccountService coreAccountService, CoreDisputeAgentsService coreDisputeAgentsService, CoreDisputesService coreDisputeService, CoreHelpService coreHelpService, CoreOffersService coreOffersService, CorePaymentAccountsService paymentAccountsService, CorePriceService corePriceService, CoreTradesService coreTradesService, CoreWalletsService walletsService, TradeStatisticsManager tradeStatisticsManager, CoreNotificationService notificationService, XmrConnectionService xmrConnectionService, XmrLocalNode xmrLocalNode) {
        this.config = config;
        this.appStartupState = appStartupState;
        this.coreAccountService = coreAccountService;
        this.coreDisputeAgentsService = coreDisputeAgentsService;
        this.coreDisputeService = coreDisputeService;
        this.coreHelpService = coreHelpService;
        this.coreOffersService = coreOffersService;
        this.paymentAccountsService = paymentAccountsService;
        this.coreTradesService = coreTradesService;
        this.corePriceService = corePriceService;
        this.walletsService = walletsService;
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.notificationService = notificationService;
        this.xmrConnectionService = xmrConnectionService;
        this.xmrLocalNode = xmrLocalNode;
    }

    public String getVersion() {
        return "1.2.2";
    }

    public String getMethodHelp(String methodName) {
        return this.coreHelpService.getMethodHelp(methodName);
    }

    public boolean accountExists() {
        return this.coreAccountService.accountExists();
    }

    public boolean isAccountOpen() {
        return this.coreAccountService.isAccountOpen();
    }

    public void createAccount(String password) {
        this.coreAccountService.createAccount(password);
    }

    public void openAccount(String password) throws IncorrectPasswordException {
        this.coreAccountService.openAccount(password);
    }

    public boolean isAppInitialized() {
        return this.appStartupState.isApplicationFullyInitialized();
    }

    public void changePassword(String oldPassword, String newPassword) {
        this.coreAccountService.changePassword(oldPassword, newPassword);
    }

    public void closeAccount() {
        this.coreAccountService.closeAccount();
    }

    public void deleteAccount(Runnable onShutdown) {
        this.coreAccountService.deleteAccount(onShutdown);
    }

    public void backupAccount(int bufferSize, Consumer<InputStream> consume, Consumer<Exception> error) {
        this.coreAccountService.backupAccount(bufferSize, consume, error);
    }

    public void restoreAccount(InputStream zipStream, int bufferSize, Runnable onShutdown) throws Exception {
        this.coreAccountService.restoreAccount(zipStream, bufferSize, onShutdown);
    }

    public void addXmrConnection(MoneroRpcConnection connection) {
        this.xmrConnectionService.addConnection(connection);
    }

    public void removeXmrConnection(String connectionUri) {
        this.xmrConnectionService.removeConnection(connectionUri);
    }

    public MoneroRpcConnection getXmrConnection() {
        return this.xmrConnectionService.getConnection();
    }

    public List<MoneroRpcConnection> getXmrConnections() {
        return this.xmrConnectionService.getConnections();
    }

    public void setXmrConnection(String connectionUri) {
        this.xmrConnectionService.setConnection(connectionUri);
    }

    public void setXmrConnection(MoneroRpcConnection connection) {
        this.xmrConnectionService.setConnection(connection);
    }

    public MoneroRpcConnection checkXmrConnection() {
        return this.xmrConnectionService.checkConnection();
    }

    public List<MoneroRpcConnection> checkXmrConnections() {
        return this.xmrConnectionService.checkConnections();
    }

    public void startCheckingXmrConnection(Long refreshPeriod) {
        this.xmrConnectionService.startCheckingConnection(refreshPeriod);
    }

    public void stopCheckingXmrConnection() {
        this.xmrConnectionService.stopCheckingConnection();
    }

    public MoneroRpcConnection getBestXmrConnection() {
        return this.xmrConnectionService.getBestConnection();
    }

    public void setXmrConnectionAutoSwitch(boolean autoSwitch) {
        this.xmrConnectionService.setAutoSwitch(autoSwitch);
    }

    public boolean getXmrConnectionAutoSwitch() {
        return this.xmrConnectionService.getAutoSwitch();
    }

    public boolean isXmrNodeOnline() {
        return this.xmrLocalNode.isDetected();
    }

    public XmrNodeSettings getXmrNodeSettings() {
        return this.xmrLocalNode.getNodeSettings();
    }

    public void startXmrNode(XmrNodeSettings settings) throws IOException {
        this.xmrLocalNode.start(settings);
    }

    public void stopXmrNode() {
        this.xmrLocalNode.stop();
    }

    public BalancesInfo getBalances(String currencyCode) {
        return this.walletsService.getBalances(currencyCode);
    }

    public String getXmrSeed() {
        return this.walletsService.getXmrSeed();
    }

    public String getXmrPrimaryAddress() {
        return this.walletsService.getXmrPrimaryAddress();
    }

    public String getXmrNewSubaddress() {
        return this.walletsService.getXmrNewSubaddress();
    }

    public List<MoneroTxWallet> getXmrTxs() {
        return this.walletsService.getXmrTxs();
    }

    public MoneroTxWallet createXmrTx(List<MoneroDestination> destinations) {
        return this.walletsService.createXmrTx(destinations);
    }

    public List<MoneroTxWallet> createXmrSweepTxs(String address) {
        return this.walletsService.createXmrSweepTxs(address);
    }

    public List<String> relayXmrTxs(List<String> metadatas) {
        return this.walletsService.relayXmrTxs(metadatas);
    }

    public long getAddressBalance(String addressString) {
        return this.walletsService.getAddressBalance(addressString);
    }

    public AddressBalanceInfo getAddressBalanceInfo(String addressString) {
        return this.walletsService.getAddressBalanceInfo(addressString);
    }

    public List<AddressBalanceInfo> getFundingAddresses() {
        return this.walletsService.getFundingAddresses();
    }

    public Transaction getTransaction(String txId) {
        return this.walletsService.getTransaction(txId);
    }

    public void setWalletPassword(String password, String newPassword) {
        this.walletsService.setWalletPassword(password, newPassword);
    }

    public void lockWallet() {
        this.walletsService.lockWallet();
    }

    public void unlockWallet(String password, long timeout) {
        this.walletsService.unlockWallet(password, timeout);
    }

    public void removeWalletPassword(String password) {
        this.walletsService.removeWalletPassword(password);
    }

    public List<TradeStatistics3> getTradeStatistics() {
        return new ArrayList<TradeStatistics3>((Collection<TradeStatistics3>)this.tradeStatisticsManager.getObservableTradeStatisticsSet());
    }

    public int getNumConfirmationsForMostRecentTransaction(String addressString) {
        return this.walletsService.getNumConfirmationsForMostRecentTransaction(addressString);
    }

    public void addNotificationListener(NotificationListener listener) {
        this.notificationService.addListener(listener);
    }

    public void sendNotification(NotificationMessage notification) {
        this.notificationService.sendNotification(notification);
    }

    public List<Dispute> getDisputes() {
        return this.coreDisputeService.getDisputes();
    }

    public Dispute getDispute(String tradeId) {
        return this.coreDisputeService.getDispute(tradeId);
    }

    public void openDispute(String tradeId, ResultHandler resultHandler, FaultHandler faultHandler) {
        this.coreDisputeService.openDispute(tradeId, resultHandler, faultHandler);
    }

    public void resolveDispute(String tradeId, DisputeResult.Winner winner, DisputeResult.Reason reason, String summaryNotes, long customPayoutAmount) {
        this.coreDisputeService.resolveDispute(tradeId, winner, reason, summaryNotes, customPayoutAmount);
    }

    public void sendDisputeChatMessage(String disputeId, String message, ArrayList<Attachment> attachments) {
        this.coreDisputeService.sendDisputeChatMessage(disputeId, message, attachments);
    }

    public void registerDisputeAgent(String disputeAgentType, String registrationKey, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.coreDisputeAgentsService.registerDisputeAgent(disputeAgentType, registrationKey, resultHandler, errorMessageHandler);
    }

    public void unregisterDisputeAgent(String disputeAgentType, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.coreDisputeAgentsService.unregisterDisputeAgent(disputeAgentType, resultHandler, errorMessageHandler);
    }

    public Offer getOffer(String id) {
        return this.coreOffersService.getOffer(id);
    }

    public List<Offer> getOffers(String direction, String currencyCode) {
        return this.coreOffersService.getOffers(direction, currencyCode);
    }

    public List<OpenOffer> getMyOffers(String direction, String currencyCode) {
        return this.coreOffersService.getMyOffers(direction, currencyCode);
    }

    public OpenOffer getMyOffer(String id) {
        return this.coreOffersService.getMyOffer(id);
    }

    public void postOffer(String currencyCode, String directionAsString, String priceAsString, boolean useMarketBasedPrice, double marketPriceMargin, long amountAsLong, long minAmountAsLong, double securityDepositPct, String triggerPriceAsString, boolean reserveExactAmount, String paymentAccountId, boolean isPrivateOffer, boolean buyerAsTakerWithoutDeposit, String extraInfo, String sourceOfferId, Consumer<Offer> resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.coreOffersService.postOffer(currencyCode, directionAsString, priceAsString, useMarketBasedPrice, marketPriceMargin, amountAsLong, minAmountAsLong, securityDepositPct, triggerPriceAsString, reserveExactAmount, paymentAccountId, isPrivateOffer, buyerAsTakerWithoutDeposit, extraInfo, sourceOfferId, resultHandler, errorMessageHandler);
    }

    public Offer editOffer(String offerId, String currencyCode, OfferDirection direction, Price price, boolean useMarketBasedPrice, double marketPriceMargin, BigInteger amount, BigInteger minAmount, double securityDepositPct, PaymentAccount paymentAccount, boolean isPrivateOffer, boolean buyerAsTakerWithoutDeposit, String extraInfo) {
        return this.coreOffersService.editOffer(offerId, currencyCode, direction, price, useMarketBasedPrice, marketPriceMargin, amount, minAmount, securityDepositPct, paymentAccount, isPrivateOffer, buyerAsTakerWithoutDeposit, extraInfo);
    }

    public void cancelOffer(String id, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.coreOffersService.cancelOffer(id, resultHandler, errorMessageHandler);
    }

    public PaymentAccount createPaymentAccount(PaymentAccountForm form) {
        return this.paymentAccountsService.createPaymentAccount(form);
    }

    public Set<PaymentAccount> getPaymentAccounts() {
        return this.paymentAccountsService.getPaymentAccounts();
    }

    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentAccountsService.getPaymentMethods();
    }

    public PaymentAccountForm getPaymentAccountForm(String paymentMethodId) {
        return this.paymentAccountsService.getPaymentAccountForm(paymentMethodId);
    }

    public PaymentAccountForm getPaymentAccountForm(PaymentAccount paymentAccount) {
        return this.paymentAccountsService.getPaymentAccountForm(paymentAccount);
    }

    public PaymentAccount createCryptoCurrencyPaymentAccount(String accountName, String currencyCode, String address, boolean tradeInstant) {
        return this.paymentAccountsService.createCryptoCurrencyPaymentAccount(accountName, currencyCode, address, tradeInstant);
    }

    public void deletePaymentAccount(String paymentAccountId) {
        this.paymentAccountsService.deletePaymentAccount(paymentAccountId);
    }

    public List<PaymentMethod> getCryptoCurrencyPaymentMethods() {
        return this.paymentAccountsService.getCryptoCurrencyPaymentMethods();
    }

    public void validateFormField(PaymentAccountForm form, PaymentAccountFormField.FieldId fieldId, String value) {
        this.paymentAccountsService.validateFormField(form, fieldId, value);
    }

    public double getMarketPrice(String currencyCode) throws ExecutionException, InterruptedException, TimeoutException {
        return this.corePriceService.getMarketPrice(currencyCode);
    }

    public List<MarketPriceInfo> getMarketPrices() throws ExecutionException, InterruptedException, TimeoutException {
        return this.corePriceService.getMarketPrices();
    }

    public MarketDepthInfo getMarketDepth(String currencyCode) throws ExecutionException, InterruptedException, TimeoutException {
        return this.corePriceService.getMarketDepth(currencyCode);
    }

    public void takeOffer(String offerId, String paymentAccountId, long amountAsLong, String challenge, Consumer<Trade> resultHandler, ErrorMessageHandler errorMessageHandler) {
        Offer offer = this.coreOffersService.getOffer(offerId);
        offer.setChallenge(challenge);
        this.coreTradesService.takeOffer(offer, paymentAccountId, amountAsLong, resultHandler, errorMessageHandler);
    }

    public void confirmPaymentSent(String tradeId, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.coreTradesService.confirmPaymentSent(tradeId, resultHandler, errorMessageHandler);
    }

    public void confirmPaymentReceived(String tradeId, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.coreTradesService.confirmPaymentReceived(tradeId, resultHandler, errorMessageHandler);
    }

    public void closeTrade(String tradeId) {
        this.coreTradesService.closeTrade(tradeId);
    }

    public Trade getTrade(String tradeId) {
        return this.coreTradesService.getTrade(tradeId);
    }

    public List<Trade> getTrades() {
        return this.coreTradesService.getTrades();
    }

    public List<ChatMessage> getChatMessages(String tradeId) {
        return this.coreTradesService.getChatMessages(tradeId);
    }

    public void sendChatMessage(String tradeId, String message) {
        this.coreTradesService.sendChatMessage(tradeId, message);
    }

    public Config getConfig() {
        return this.config;
    }
}

