/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.config.Config;
import haveno.common.crypto.IncorrectPasswordException;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.KeyStorage;
import haveno.common.file.FileUtil;
import haveno.common.persistence.PersistenceManager;
import haveno.common.util.ZipUtils;
import haveno.core.api.AccountServiceListener;
import haveno.core.api.XmrLocalNode;
import haveno.core.xmr.wallet.XmrWalletService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CoreAccountService {
    private static final Logger log = LoggerFactory.getLogger(CoreAccountService.class);
    private final Config config;
    private final KeyStorage keyStorage;
    private final KeyRing keyRing;
    private String password;
    private List<AccountServiceListener> listeners = new ArrayList<AccountServiceListener>();

    @Inject
    public CoreAccountService(Config config, KeyStorage keyStorage, KeyRing keyRing) {
        this.config = config;
        this.keyStorage = keyStorage;
        this.keyRing = keyRing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AccountServiceListener listener) {
        List<AccountServiceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(AccountServiceListener listener) {
        List<AccountServiceListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.remove(listener);
        }
    }

    public boolean accountExists() {
        return this.keyStorage.allKeyFilesExist();
    }

    public boolean isAccountOpen() {
        return this.keyRing.isUnlocked() && this.accountExists();
    }

    public void checkAccountOpen() {
        Preconditions.checkState((boolean)this.isAccountOpen(), (Object)"Account not open");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAccount(String password) {
        if (this.accountExists()) {
            throw new IllegalStateException("Cannot create account if account already exists");
        }
        this.keyRing.generateKeys(password);
        this.password = password;
        List<AccountServiceListener> list = this.listeners;
        synchronized (list) {
            for (AccountServiceListener listener : new ArrayList<AccountServiceListener>(this.listeners)) {
                listener.onAccountCreated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAccount(String password) throws IncorrectPasswordException {
        if (!this.accountExists()) {
            throw new IllegalStateException("Cannot open account if account does not exist");
        }
        if (this.keyRing.unlockKeys(password, false)) {
            this.password = password;
            List<AccountServiceListener> list = this.listeners;
            synchronized (list) {
                for (AccountServiceListener listener : new ArrayList<AccountServiceListener>(this.listeners)) {
                    listener.onAccountOpened();
                }
            }
        } else {
            throw new IllegalStateException("keyRing.unlockKeys() returned false, that should never happen");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String oldPassword, String newPassword) {
        if (!this.isAccountOpen()) {
            throw new IllegalStateException("Cannot change password on unopened account");
        }
        if ("".equals(oldPassword)) {
            oldPassword = null;
        }
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)oldPassword)) {
            throw new IllegalStateException("Incorrect password");
        }
        if (newPassword != null && newPassword.length() < 8) {
            throw new IllegalStateException("Password must be at least 8 characters");
        }
        this.keyStorage.saveKeyRing(this.keyRing, oldPassword, newPassword);
        this.password = newPassword;
        List<AccountServiceListener> list = this.listeners;
        synchronized (list) {
            for (AccountServiceListener listener : new ArrayList<AccountServiceListener>(this.listeners)) {
                listener.onPasswordChanged(oldPassword, newPassword);
            }
        }
    }

    public void verifyPassword(String password) throws IncorrectPasswordException {
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            throw new IncorrectPasswordException("Incorrect password");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAccount() {
        if (!this.isAccountOpen()) {
            throw new IllegalStateException("Cannot close unopened account");
        }
        this.keyRing.lockKeys();
        List<AccountServiceListener> list = this.listeners;
        synchronized (list) {
            for (AccountServiceListener listener : new ArrayList<AccountServiceListener>(this.listeners)) {
                listener.onAccountClosed();
            }
        }
    }

    public void backupAccount(int bufferSize, Consumer<InputStream> consume, Consumer<Exception> error) {
        if (!this.accountExists()) {
            throw new IllegalStateException("Cannot backup non existing account");
        }
        PersistenceManager.flushAllDataToDiskAtBackup(() -> {
            try {
                File dataDir = new File(this.config.appDataDir.getPath());
                PipedInputStream in = new PipedInputStream(bufferSize);
                PipedOutputStream out = new PipedOutputStream(in);
                log.info("Zipping directory " + String.valueOf(dataDir));
                List<File> excludedFiles = Arrays.asList(new File(XmrWalletService.MONERO_WALLET_RPC_PATH), new File(XmrLocalNode.MONEROD_PATH));
                new Thread(() -> {
                    try {
                        ZipUtils.zipDirToStream((File)dataDir, (OutputStream)out, (int)bufferSize, (Collection)excludedFiles);
                    }
                    catch (Exception ex) {
                        error.accept(ex);
                    }
                }).start();
                consume.accept(in);
            }
            catch (IOException err) {
                error.accept(err);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreAccount(InputStream inputStream, int bufferSize, Runnable onShutdown) throws Exception {
        if (this.accountExists()) {
            throw new IllegalStateException("Cannot restore account if there is an existing account");
        }
        File dataDir = new File(this.config.appDataDir.getPath());
        ZipUtils.unzipToDir((File)dataDir, (InputStream)inputStream, (int)bufferSize);
        List<AccountServiceListener> list = this.listeners;
        synchronized (list) {
            for (AccountServiceListener listener : new ArrayList<AccountServiceListener>(this.listeners)) {
                listener.onAccountRestored(onShutdown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAccount(Runnable onShutdown) {
        try {
            if (this.isAccountOpen()) {
                this.closeAccount();
            }
            List<AccountServiceListener> list = this.listeners;
            synchronized (list) {
                for (AccountServiceListener listener : new ArrayList<AccountServiceListener>(this.listeners)) {
                    listener.onAccountDeleted(onShutdown);
                }
            }
            File dataDir = new File(this.config.appDataDir.getPath());
            FileUtil.deleteDirectory((File)dataDir, null, (boolean)false);
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
    }

    public String getPassword() {
        return this.password;
    }
}

