/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.alert;

import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.config.Config;
import haveno.common.crypto.KeyRing;
import haveno.core.alert.Alert;
import haveno.core.user.User;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.storage.HashMapChangedListener;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertManager {
    private static final Logger log = LoggerFactory.getLogger(AlertManager.class);
    private final P2PService p2PService;
    private final KeyRing keyRing;
    private final User user;
    private final ObjectProperty<Alert> alertMessageProperty = new SimpleObjectProperty();
    private final boolean useDevPrivilegeKeys;
    private ECKey alertSigningKey;

    @Inject
    public AlertManager(P2PService p2PService, KeyRing keyRing, User user, @Named(value="ignoreDevMsg") boolean ignoreDevMsg, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        this.p2PService = p2PService;
        this.keyRing = keyRing;
        this.user = user;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        if (!ignoreDevMsg) {
            p2PService.addHashSetChangedListener(new HashMapChangedListener(){

                public void onAdded(Collection<ProtectedStorageEntry> protectedStorageEntries) {
                    protectedStorageEntries.forEach(protectedStorageEntry -> {
                        Alert alert;
                        ProtectedStoragePayload protectedStoragePayload = protectedStorageEntry.getProtectedStoragePayload();
                        if (protectedStoragePayload instanceof Alert && AlertManager.this.verifySignature(alert = (Alert)protectedStoragePayload)) {
                            AlertManager.this.alertMessageProperty.set((Object)alert);
                        }
                    });
                }

                public void onRemoved(Collection<ProtectedStorageEntry> protectedStorageEntries) {
                    protectedStorageEntries.forEach(protectedStorageEntry -> {
                        ProtectedStoragePayload protectedStoragePayload = protectedStorageEntry.getProtectedStoragePayload();
                        if (protectedStoragePayload instanceof Alert && AlertManager.this.verifySignature((Alert)protectedStoragePayload)) {
                            AlertManager.this.alertMessageProperty.set(null);
                        }
                    });
                }
            });
        }
    }

    protected List<String> getPubKeyList() {
        if (this.useDevPrivilegeKeys) {
            return List.of("027a381b5333a56e1cc3d90d3a7d07f26509adf7029ed06fc997c656621f8da1ee");
        }
        switch (Config.baseCurrencyNetwork()) {
            case XMR_LOCAL: {
                return List.of("027a381b5333a56e1cc3d90d3a7d07f26509adf7029ed06fc997c656621f8da1ee", "024baabdba90e7cc0dc4626ef73ea9d722ea7085d1104491da8c76f28187513492");
            }
            case XMR_STAGENET: {
                return List.of("03aa23e062afa0dda465f46986f8aa8d0374ad3e3f256141b05681dcb1e39c3859", "02d3beb1293ca2ca14e6d42ca8bd18089a62aac62fd6bb23923ee6ead46ac60fba", "0374dd70f3fa6e47ec5ab97932e1cec6233e98e6ae3129036b17118650c44fd3de");
            }
            case XMR_MAINNET: {
                return List.of("02d8ac0fbe4e25f4a1d68b95936f25fc2e1b218e161cb5ed6661c7ab4c85f1fd4f", "02e9dc14edddde19cc9f829a0739d0ab0c7310154ad94a15d477b51d85991b5a8a", "03c8efdf81287ce8b3212241e6aa7cdf094ecbed2d2f119730a3e4d596a764106a");
            }
        }
        throw new RuntimeException("Unhandled base currency network: " + String.valueOf(Config.baseCurrencyNetwork()));
    }

    public ReadOnlyObjectProperty<Alert> alertMessageProperty() {
        return this.alertMessageProperty;
    }

    public boolean addAlertMessageIfKeyIsValid(Alert alert, String privKeyString) {
        boolean isKeyValid;
        if (this.user.getDevelopersAlert() != null) {
            this.removeAlertMessageIfKeyIsValid(privKeyString);
        }
        if (isKeyValid = this.isKeyValid(privKeyString)) {
            this.signAndAddSignatureToAlertMessage(alert);
            this.user.setDevelopersAlert(alert);
            boolean result = this.p2PService.addProtectedStorageEntry((ProtectedStoragePayload)alert);
            if (result) {
                log.trace("Add alertMessage to network was successful. AlertMessage={}", (Object)alert);
            }
        }
        return isKeyValid;
    }

    public boolean removeAlertMessageIfKeyIsValid(String privKeyString) {
        Alert alert = this.user.getDevelopersAlert();
        if (this.isKeyValid(privKeyString) && alert != null) {
            if (this.p2PService.removeData((ProtectedStoragePayload)alert)) {
                log.trace("Remove alertMessage from network was successful. AlertMessage={}", (Object)alert);
            }
            this.user.setDevelopersAlert(null);
            return true;
        }
        return false;
    }

    private boolean isKeyValid(String privKeyString) {
        try {
            this.alertSigningKey = ECKey.fromPrivate((BigInteger)new BigInteger(1, Utils.HEX.decode((CharSequence)privKeyString)));
            return this.getPubKeyList().contains(Utils.HEX.encode(this.alertSigningKey.getPubKey()));
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void signAndAddSignatureToAlertMessage(Alert alert) {
        String alertMessageAsHex = Utils.HEX.encode(alert.getMessage().getBytes(Charsets.UTF_8));
        String signatureAsBase64 = this.alertSigningKey.signMessage(alertMessageAsHex);
        alert.setSigAndPubKey(signatureAsBase64, this.keyRing.getSignatureKeyPair().getPublic());
    }

    private boolean verifySignature(Alert alert) {
        String alertMessageAsHex = Utils.HEX.encode(alert.getMessage().getBytes(Charsets.UTF_8));
        for (String pubKeyAsHex : this.getPubKeyList()) {
            try {
                ECKey.fromPublicOnly((byte[])Utils.HEX.decode((CharSequence)pubKeyAsHex)).verifyMessage(alertMessageAsHex, alert.getSignatureAsBase64());
                return true;
            }
            catch (SignatureException signatureException) {
            }
        }
        log.warn("verifySignature failed");
        return false;
    }
}

