/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.alert;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import haveno.common.app.Version;
import haveno.common.crypto.Sig;
import haveno.common.util.CollectionUtils;
import haveno.common.util.ExtraDataMapValidator;
import haveno.core.user.Preferences;
import haveno.network.p2p.storage.payload.ExpirablePayload;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Alert;
import protobuf.StoragePayload;

public final class Alert
implements ProtectedStoragePayload,
ExpirablePayload {
    private static final Logger log = LoggerFactory.getLogger(Alert.class);
    public static final long TTL = TimeUnit.DAYS.toMillis(90L);
    private final String message;
    private final boolean isUpdateInfo;
    private final boolean isPreReleaseInfo;
    private final String version;
    @Nullable
    private byte[] ownerPubKeyBytes;
    @Nullable
    private String signatureAsBase64;
    @Nullable
    private PublicKey ownerPubKey;
    @Nullable
    private Map<String, String> extraDataMap;

    public Alert(String message, boolean isUpdateInfo, boolean isPreReleaseInfo, String version) {
        this.message = message;
        this.isUpdateInfo = isUpdateInfo;
        this.isPreReleaseInfo = isPreReleaseInfo;
        this.version = version;
    }

    public Alert(String message, boolean isUpdateInfo, boolean isPreReleaseInfo, String version, byte[] ownerPubKeyBytes, String signatureAsBase64, Map<String, String> extraDataMap) {
        this.message = message;
        this.isUpdateInfo = isUpdateInfo;
        this.isPreReleaseInfo = isPreReleaseInfo;
        this.version = version;
        this.ownerPubKeyBytes = ownerPubKeyBytes;
        this.signatureAsBase64 = signatureAsBase64;
        this.extraDataMap = ExtraDataMapValidator.getValidatedExtraDataMap(extraDataMap);
        this.ownerPubKey = Sig.getPublicKeyFromBytes((byte[])ownerPubKeyBytes);
    }

    public StoragePayload toProtoMessage() {
        Preconditions.checkNotNull((Object)this.ownerPubKeyBytes, (Object)"storagePublicKeyBytes must not be null");
        Preconditions.checkNotNull((Object)this.signatureAsBase64, (Object)"signatureAsBase64 must not be null");
        Alert.Builder builder = protobuf.Alert.newBuilder().setMessage(this.message).setIsUpdateInfo(this.isUpdateInfo).setIsPreReleaseInfo(this.isPreReleaseInfo).setVersion(this.version).setOwnerPubKeyBytes(ByteString.copyFrom((byte[])this.ownerPubKeyBytes)).setSignatureAsBase64(this.signatureAsBase64);
        Optional.ofNullable(this.getExtraDataMap()).ifPresent(arg_0 -> ((Alert.Builder)builder).putAllExtraData(arg_0));
        return StoragePayload.newBuilder().setAlert(builder).build();
    }

    @Nullable
    public static Alert fromProto(protobuf.Alert proto) {
        if (proto.getSignatureAsBase64().isEmpty()) {
            return null;
        }
        return new Alert(proto.getMessage(), proto.getIsUpdateInfo(), proto.getIsPreReleaseInfo(), proto.getVersion(), proto.getOwnerPubKeyBytes().toByteArray(), proto.getSignatureAsBase64(), CollectionUtils.isEmpty((Map)proto.getExtraDataMap()) ? null : proto.getExtraDataMap());
    }

    public long getTTL() {
        return TTL;
    }

    public void setSigAndPubKey(String signatureAsBase64, PublicKey ownerPubKey) {
        this.signatureAsBase64 = signatureAsBase64;
        this.ownerPubKey = ownerPubKey;
        this.ownerPubKeyBytes = Sig.getPublicKeyBytes((PublicKey)ownerPubKey);
    }

    public boolean isNewVersion(Preferences preferences) {
        if (this.isUpdateInfo || this.isPreReleaseInfo && preferences.isNotifyOnPreRelease()) {
            return Version.isNewVersion((String)this.version);
        }
        return false;
    }

    public boolean isSoftwareUpdateNotification() {
        return this.isUpdateInfo || this.isPreReleaseInfo;
    }

    public boolean canShowPopup(Preferences preferences) {
        return this.isNewVersion(preferences) && preferences.showAgain(this.showAgainKey());
    }

    public String showAgainKey() {
        return "Update_" + this.version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)o;
        if (this.isUpdateInfo() != other.isUpdateInfo()) {
            return false;
        }
        if (this.isPreReleaseInfo() != other.isPreReleaseInfo()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        if (!Arrays.equals(this.getOwnerPubKeyBytes(), other.getOwnerPubKeyBytes())) {
            return false;
        }
        String this$signatureAsBase64 = this.getSignatureAsBase64();
        String other$signatureAsBase64 = other.getSignatureAsBase64();
        if (this$signatureAsBase64 == null ? other$signatureAsBase64 != null : !this$signatureAsBase64.equals(other$signatureAsBase64)) {
            return false;
        }
        PublicKey this$ownerPubKey = this.getOwnerPubKey();
        PublicKey other$ownerPubKey = other.getOwnerPubKey();
        if (this$ownerPubKey == null ? other$ownerPubKey != null : !this$ownerPubKey.equals(other$ownerPubKey)) {
            return false;
        }
        Map<String, String> this$extraDataMap = this.getExtraDataMap();
        Map<String, String> other$extraDataMap = other.getExtraDataMap();
        return !(this$extraDataMap == null ? other$extraDataMap != null : !((Object)this$extraDataMap).equals(other$extraDataMap));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUpdateInfo() ? 79 : 97);
        result = result * 59 + (this.isPreReleaseInfo() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOwnerPubKeyBytes());
        String $signatureAsBase64 = this.getSignatureAsBase64();
        result = result * 59 + ($signatureAsBase64 == null ? 43 : $signatureAsBase64.hashCode());
        PublicKey $ownerPubKey = this.getOwnerPubKey();
        result = result * 59 + ($ownerPubKey == null ? 43 : $ownerPubKey.hashCode());
        Map<String, String> $extraDataMap = this.getExtraDataMap();
        result = result * 59 + ($extraDataMap == null ? 43 : ((Object)$extraDataMap).hashCode());
        return result;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isUpdateInfo() {
        return this.isUpdateInfo;
    }

    public boolean isPreReleaseInfo() {
        return this.isPreReleaseInfo;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public byte[] getOwnerPubKeyBytes() {
        return this.ownerPubKeyBytes;
    }

    @Nullable
    public String getSignatureAsBase64() {
        return this.signatureAsBase64;
    }

    @Nullable
    public PublicKey getOwnerPubKey() {
        return this.ownerPubKey;
    }

    @Nullable
    public Map<String, String> getExtraDataMap() {
        return this.extraDataMap;
    }

    public String toString() {
        return "Alert(message=" + this.getMessage() + ", isUpdateInfo=" + this.isUpdateInfo() + ", isPreReleaseInfo=" + this.isPreReleaseInfo() + ", version=" + this.getVersion() + ", ownerPubKeyBytes=" + Arrays.toString(this.getOwnerPubKeyBytes()) + ", signatureAsBase64=" + this.getSignatureAsBase64() + ", ownerPubKey=" + String.valueOf(this.getOwnerPubKey()) + ", extraDataMap=" + String.valueOf(this.getExtraDataMap()) + ")";
    }
}

