/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.account.witness;

import com.google.common.base.Preconditions;
import haveno.common.crypto.Hash;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.util.Utilities;
import haveno.core.account.sign.SignedWitness;
import haveno.core.account.sign.SignedWitnessService;
import haveno.core.account.witness.AccountAgeWitness;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.trade.Trade;
import haveno.network.p2p.storage.P2PDataStorage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountAgeWitnessUtils {
    private static final Logger log = LoggerFactory.getLogger(AccountAgeWitnessUtils.class);
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final SignedWitnessService signedWitnessService;
    private final KeyRing keyRing;

    AccountAgeWitnessUtils(AccountAgeWitnessService accountAgeWitnessService, SignedWitnessService signedWitnessService, KeyRing keyRing) {
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.signedWitnessService = signedWitnessService;
        this.keyRing = keyRing;
    }

    public void logSignedWitnesses() {
        Set<SignedWitness> orphanSigners = this.signedWitnessService.getRootSignedWitnessSet(true);
        log.info("Orphaned signed account age witnesses:");
        orphanSigners.forEach(w -> {
            log.info("{}: Signer PKH: {} Owner PKH: {} time: {}", new Object[]{w.getVerificationMethod().toString(), Utilities.bytesAsHexString((byte[])Hash.getRipemd160hash((byte[])w.getSignerPubKey())).substring(0, 7), Utilities.bytesAsHexString((byte[])Hash.getRipemd160hash((byte[])w.getWitnessOwnerPubKey())).substring(0, 7), w.getDate()});
            this.logChild((SignedWitness)w, "  ", new Stack<P2PDataStorage.ByteArray>());
        });
    }

    private void logChild(SignedWitness sigWit, String initString, Stack<P2PDataStorage.ByteArray> excluded) {
        log.info("{}AEW: {} PKH: {} time: {}", new Object[]{initString, Utilities.bytesAsHexString((byte[])sigWit.getAccountAgeWitnessHash()).substring(0, 7), Utilities.bytesAsHexString((byte[])Hash.getRipemd160hash((byte[])sigWit.getWitnessOwnerPubKey())).substring(0, 7), sigWit.getDate()});
        this.signedWitnessService.getSignedWitnessMapValues().forEach(w -> {
            if (!excluded.contains(new P2PDataStorage.ByteArray(w.getWitnessOwnerPubKey())) && Arrays.equals(w.getSignerPubKey(), sigWit.getWitnessOwnerPubKey())) {
                excluded.push(new P2PDataStorage.ByteArray(w.getWitnessOwnerPubKey()));
                this.logChild((SignedWitness)w, initString + "  ", excluded);
                excluded.pop();
            }
        });
    }

    public void logSigners() {
        log.info("Signers per AEW");
        Collection<SignedWitness> signedWitnessMapValues = this.signedWitnessService.getSignedWitnessMapValues();
        signedWitnessMapValues.forEach(w -> {
            log.info("AEW {}", (Object)Utilities.bytesAsHexString((byte[])w.getAccountAgeWitnessHash()));
            signedWitnessMapValues.forEach(ww -> {
                if (Arrays.equals(w.getSignerPubKey(), ww.getWitnessOwnerPubKey())) {
                    log.info("  {}", (Object)Utilities.bytesAsHexString((byte[])ww.getAccountAgeWitnessHash()));
                }
            });
        });
    }

    public void logUnsignedSignerPubKeys() {
        log.info("Unsigned signer pubkeys");
        this.signedWitnessService.getUnsignedSignerPubKeys().forEach(signedWitness -> log.info("PK hash {} date {}", (Object)Utilities.bytesAsHexString((byte[])Hash.getRipemd160hash((byte[])signedWitness.getSignerPubKey())), (Object)signedWitness.getDate()));
    }

    private String getWitnessDebugLog(PaymentAccountPayload paymentAccountPayload, PubKeyRing pubKeyRing) {
        Optional<AccountAgeWitness> accountAgeWitness = this.accountAgeWitnessService.findWitness(paymentAccountPayload, pubKeyRing);
        if (!accountAgeWitness.isPresent()) {
            byte[] accountInputDataWithSalt = this.accountAgeWitnessService.getAccountInputDataWithSalt(paymentAccountPayload);
            byte[] hash = Hash.getSha256Ripemd160hash((byte[])Utilities.concatenateByteArrays((byte[])accountInputDataWithSalt, (byte[])pubKeyRing.getSignaturePubKeyBytes()));
            return "No accountAgeWitness found for paymentAccountPayload with hash " + Utilities.bytesAsHexString((byte[])hash);
        }
        AccountAgeWitnessService.SignState signState = this.accountAgeWitnessService.getSignState(accountAgeWitness.get());
        return signState.name() + " " + signState.getDisplayString() + "\n" + accountAgeWitness.toString();
    }

    public void witnessDebugLog(Trade trade, @Nullable AccountAgeWitness myWitness) {
        Preconditions.checkNotNull((Object)trade.getContract());
        Preconditions.checkNotNull((Object)trade.getBuyer().getPaymentAccountPayload());
        boolean checkingSignTrade = true;
        boolean isBuyer = trade.getContract().isMyRoleBuyer(this.keyRing.getPubKeyRing());
        AccountAgeWitness witness = myWitness;
        if (witness == null) {
            witness = isBuyer ? this.accountAgeWitnessService.getMyWitness(trade.getBuyer().getPaymentAccountPayload()) : this.accountAgeWitnessService.getMyWitness(trade.getSeller().getPaymentAccountPayload());
            checkingSignTrade = false;
        }
        boolean isSignWitnessTrade = this.accountAgeWitnessService.accountIsSigner(witness) && !this.accountAgeWitnessService.peerHasSignedWitness(trade) && this.accountAgeWitnessService.tradeAmountIsSufficient(trade.getAmount());
        log.debug("AccountSigning debug log: \ntradeId: {}\nis buyer: {}\nbuyer account age witness info: {}\nseller account age witness info: {}\nchecking for sign trade: {}\nis myWitness signer: {}\npeer has signed witness: {}\ntrade amount: {}\ntrade amount is sufficient: {}\nisSignWitnessTrade: {}", new Object[]{trade.getId(), isBuyer, this.getWitnessDebugLog(trade.getBuyer().getPaymentAccountPayload(), trade.getContract().getBuyerPubKeyRing()), this.getWitnessDebugLog(trade.getSeller().getPaymentAccountPayload(), trade.getContract().getSellerPubKeyRing()), checkingSignTrade, this.accountAgeWitnessService.accountIsSigner(witness), this.accountAgeWitnessService.peerHasSignedWitness(trade), trade.getAmount(), this.accountAgeWitnessService.tradeAmountIsSufficient(trade.getAmount()), isSignWitnessTrade});
    }
}

