/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.account.witness;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.core.account.witness.AccountAgeWitness;
import haveno.core.account.witness.AccountAgeWitnessStore;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.persistence.HistoricalDataStoreService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountAgeWitnessStorageService
extends HistoricalDataStoreService<AccountAgeWitnessStore> {
    private static final Logger log = LoggerFactory.getLogger(AccountAgeWitnessStorageService.class);
    private static final String FILE_NAME = "AccountAgeWitnessStore";

    @Inject
    public AccountAgeWitnessStorageService(@Named(value="storageDir") File storageDir, PersistenceManager<AccountAgeWitnessStore> persistenceManager) {
        super(storageDir, persistenceManager);
    }

    public String getFileName() {
        return FILE_NAME;
    }

    protected void initializePersistenceManager() {
        this.persistenceManager.initialize((PersistableEnvelope)((AccountAgeWitnessStore)this.store), PersistenceManager.Source.NETWORK);
    }

    public boolean canHandle(PersistableNetworkPayload payload) {
        return payload instanceof AccountAgeWitness;
    }

    protected AccountAgeWitnessStore createStore() {
        return new AccountAgeWitnessStore();
    }
}

