/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.account.sign;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.common.crypto.CryptoException;
import haveno.common.crypto.Hash;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.Sig;
import haveno.common.util.Utilities;
import haveno.core.account.sign.SignedWitness;
import haveno.core.account.sign.SignedWitnessStorageService;
import haveno.core.account.witness.AccountAgeWitness;
import haveno.core.filter.FilterManager;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.User;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.persistence.AppendOnlyDataStoreService;
import haveno.network.p2p.storage.persistence.MapStoreService;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedWitnessService {
    private static final Logger log = LoggerFactory.getLogger(SignedWitnessService.class);
    public static final long SIGNER_AGE_DAYS = 30L;
    private static final long SIGNER_AGE = 30L * ChronoUnit.DAYS.getDuration().toMillis();
    public static final BigInteger MINIMUM_TRADE_AMOUNT_FOR_SIGNING = HavenoUtils.xmrToAtomicUnits(0.1);
    private final KeyRing keyRing;
    private final P2PService p2PService;
    private final ArbitratorManager arbitratorManager;
    private final SignedWitnessStorageService signedWitnessStorageService;
    private final User user;
    private final FilterManager filterManager;
    private final Map<P2PDataStorage.ByteArray, SignedWitness> signedWitnessMap = new HashMap<P2PDataStorage.ByteArray, SignedWitness>();
    private final Map<P2PDataStorage.ByteArray, Set<SignedWitness>> signedWitnessSetByAccountAgeWitnessHash = new HashMap<P2PDataStorage.ByteArray, Set<SignedWitness>>();
    private final Map<P2PDataStorage.ByteArray, Set<SignedWitness>> signedWitnessSetByOwnerPubKey = new HashMap<P2PDataStorage.ByteArray, Set<SignedWitness>>();
    private final Map<P2PDataStorage.ByteArray, Boolean> verifySignatureWithDSAKeyResultCache = new HashMap<P2PDataStorage.ByteArray, Boolean>();
    private final Map<P2PDataStorage.ByteArray, Boolean> verifySignatureWithECKeyResultCache = new HashMap<P2PDataStorage.ByteArray, Boolean>();

    @Inject
    public SignedWitnessService(KeyRing keyRing, P2PService p2PService, ArbitratorManager arbitratorManager, SignedWitnessStorageService signedWitnessStorageService, AppendOnlyDataStoreService appendOnlyDataStoreService, User user, FilterManager filterManager) {
        this.keyRing = keyRing;
        this.p2PService = p2PService;
        this.arbitratorManager = arbitratorManager;
        this.signedWitnessStorageService = signedWitnessStorageService;
        this.user = user;
        this.filterManager = filterManager;
        appendOnlyDataStoreService.addService((MapStoreService)signedWitnessStorageService);
    }

    public void onAllServicesInitialized() {
        this.p2PService.getP2PDataStorage().addAppendOnlyDataStoreListener(payload -> {
            if (payload instanceof SignedWitness) {
                this.addToMap((SignedWitness)payload);
            }
        });
        this.signedWitnessStorageService.getMap().values().forEach(e -> {
            if (e instanceof SignedWitness) {
                this.addToMap((SignedWitness)e);
            }
        });
        if (this.p2PService.isBootstrapped()) {
            this.onBootstrapComplete();
        } else {
            this.p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

                public void onDataReceived() {
                    SignedWitnessService.this.onBootstrapComplete();
                }
            });
        }
    }

    private void onBootstrapComplete() {
        if (this.user.getRegisteredArbitrator() != null) {
            UserThread.runAfter(this::doRepublishAllSignedWitnesses, (long)60L);
        }
    }

    public Collection<SignedWitness> getSignedWitnessMapValues() {
        return this.signedWitnessMap.values();
    }

    public List<Long> getVerifiedWitnessDateList(AccountAgeWitness accountAgeWitness) {
        if (!this.isSignedAccountAgeWitness(accountAgeWitness)) {
            return new ArrayList<Long>();
        }
        return this.getSignedWitnessSet(accountAgeWitness).stream().filter(this::verifySignature).map(SignedWitness::getDate).sorted().collect(Collectors.toList());
    }

    public List<Long> getWitnessDateList(AccountAgeWitness accountAgeWitness) {
        return this.getSignedWitnessSet(accountAgeWitness).stream().map(SignedWitness::getDate).sorted().collect(Collectors.toList());
    }

    public boolean isSignedByArbitrator(AccountAgeWitness accountAgeWitness) {
        return this.getSignedWitnessSet(accountAgeWitness).stream().map(SignedWitness::isSignedByArbitrator).findAny().orElse(false);
    }

    public boolean isFilteredWitness(AccountAgeWitness accountAgeWitness) {
        return this.getSignedWitnessSet(accountAgeWitness).stream().map(SignedWitness::getWitnessOwnerPubKey).anyMatch(ownerPubKey -> this.filterManager.isWitnessSignerPubKeyBanned(Utils.HEX.encode(ownerPubKey)));
    }

    private byte[] ownerPubKey(AccountAgeWitness accountAgeWitness) {
        return this.getSignedWitnessSet(accountAgeWitness).stream().map(SignedWitness::getWitnessOwnerPubKey).findFirst().orElse(null);
    }

    public String ownerPubKeyAsString(AccountAgeWitness accountAgeWitness) {
        return this.getSignedWitnessSet(accountAgeWitness).stream().map(signedWitness -> Utils.HEX.encode(signedWitness.getWitnessOwnerPubKey())).findFirst().orElse("");
    }

    @VisibleForTesting
    public Set<SignedWitness> getSignedWitnessSetByOwnerPubKey(byte[] ownerPubKey) {
        return this.getSignedWitnessMapValues().stream().filter(e -> Arrays.equals(e.getWitnessOwnerPubKey(), ownerPubKey)).collect(Collectors.toSet());
    }

    public boolean publishOwnSignedWitness(SignedWitness signedWitness) {
        if (!Arrays.equals(signedWitness.getWitnessOwnerPubKey(), this.keyRing.getPubKeyRing().getSignaturePubKeyBytes()) || !this.verifySigner(signedWitness)) {
            return false;
        }
        log.info("Publish own signedWitness {}", (Object)signedWitness);
        this.publishSignedWitness(signedWitness);
        return true;
    }

    public void signAndPublishAccountAgeWitness(BigInteger tradeAmount, AccountAgeWitness accountAgeWitness, ECKey key, PublicKey peersPubKey) {
        this.signAndPublishAccountAgeWitness(tradeAmount, accountAgeWitness, key, peersPubKey.getEncoded(), new Date().getTime());
    }

    public String signAndPublishAccountAgeWitness(AccountAgeWitness accountAgeWitness, ECKey key, byte[] peersPubKey, long time) {
        byte[] witnessPubKey = peersPubKey == null ? this.ownerPubKey(accountAgeWitness) : peersPubKey;
        return this.signAndPublishAccountAgeWitness(MINIMUM_TRADE_AMOUNT_FOR_SIGNING, accountAgeWitness, key, witnessPubKey, time);
    }

    public String signTraderPubKey(ECKey key, byte[] peersPubKey, long childSignTime) {
        long time = childSignTime - SIGNER_AGE - 1L;
        AccountAgeWitness dummyAccountAgeWitness = new AccountAgeWitness(Hash.getRipemd160hash((byte[])peersPubKey), time);
        return this.signAndPublishAccountAgeWitness(MINIMUM_TRADE_AMOUNT_FOR_SIGNING, dummyAccountAgeWitness, key, peersPubKey, time);
    }

    private String signAndPublishAccountAgeWitness(BigInteger tradeAmount, AccountAgeWitness accountAgeWitness, ECKey key, byte[] peersPubKey, long time) {
        if (this.isSignedAccountAgeWitness(accountAgeWitness)) {
            String err = "Arbitrator trying to sign already signed accountagewitness " + accountAgeWitness.toString();
            log.warn(err);
            return err;
        }
        if (peersPubKey == null) {
            String err = "Trying to sign accountAgeWitness " + accountAgeWitness.toString() + "\nwith owner pubkey=null";
            log.warn(err);
            return err;
        }
        String accountAgeWitnessHashAsHex = Utilities.encodeToHex((byte[])accountAgeWitness.getHash());
        String signatureBase64 = key.signMessage(accountAgeWitnessHashAsHex);
        SignedWitness signedWitness = new SignedWitness(SignedWitness.VerificationMethod.ARBITRATOR, accountAgeWitness.getHash(), signatureBase64.getBytes(Charsets.UTF_8), key.getPubKey(), peersPubKey, time, tradeAmount.longValueExact());
        this.publishSignedWitness(signedWitness);
        log.info("Arbitrator signed witness {}", (Object)signedWitness.toString());
        return "";
    }

    public void selfSignAndPublishAccountAgeWitness(AccountAgeWitness accountAgeWitness) throws CryptoException {
        log.info("Sign own accountAgeWitness {}", (Object)accountAgeWitness);
        this.signAndPublishAccountAgeWitness(MINIMUM_TRADE_AMOUNT_FOR_SIGNING, accountAgeWitness, this.keyRing.getSignatureKeyPair().getPublic());
    }

    public Optional<SignedWitness> signAndPublishAccountAgeWitness(BigInteger tradeAmount, AccountAgeWitness accountAgeWitness, PublicKey peersPubKey) throws CryptoException {
        if (this.isSignedAccountAgeWitness(accountAgeWitness)) {
            log.warn("Trader trying to sign already signed accountagewitness {}", (Object)accountAgeWitness.toString());
            return Optional.empty();
        }
        if (!this.isSufficientTradeAmountForSigning(tradeAmount)) {
            log.warn("Trader tried to sign account with too little trade amount");
            return Optional.empty();
        }
        byte[] signature = Sig.sign((PrivateKey)this.keyRing.getSignatureKeyPair().getPrivate(), (byte[])accountAgeWitness.getHash());
        SignedWitness signedWitness = new SignedWitness(SignedWitness.VerificationMethod.TRADE, accountAgeWitness.getHash(), signature, this.keyRing.getSignatureKeyPair().getPublic().getEncoded(), peersPubKey.getEncoded(), new Date().getTime(), tradeAmount.longValueExact());
        this.publishSignedWitness(signedWitness);
        log.info("Trader signed witness {}", (Object)signedWitness.toString());
        return Optional.of(signedWitness);
    }

    public boolean verifySignature(SignedWitness signedWitness) {
        if (signedWitness.isSignedByArbitrator()) {
            return this.verifySignatureWithECKey(signedWitness);
        }
        return this.verifySignatureWithDSAKey(signedWitness);
    }

    private boolean verifySignatureWithECKey(SignedWitness signedWitness) {
        P2PDataStorage.ByteArray hash = new P2PDataStorage.ByteArray(signedWitness.getHash());
        if (this.verifySignatureWithECKeyResultCache.containsKey(hash)) {
            return this.verifySignatureWithECKeyResultCache.get(hash);
        }
        try {
            String message = Utilities.encodeToHex((byte[])signedWitness.getAccountAgeWitnessHash());
            String signatureBase64 = new String(signedWitness.getSignature(), Charsets.UTF_8);
            ECKey key = ECKey.fromPublicOnly((byte[])signedWitness.getSignerPubKey());
            String pubKeyHex = Utilities.encodeToHex((byte[])key.getPubKey());
            if (this.arbitratorManager.isPublicKeyInList(pubKeyHex)) {
                key.verifyMessage(message, signatureBase64);
                this.verifySignatureWithECKeyResultCache.put(hash, true);
                return true;
            }
            log.warn("Provided EC key is not in list of valid arbitrators: " + pubKeyHex);
            this.verifySignatureWithECKeyResultCache.put(hash, false);
            return false;
        }
        catch (SignatureException e) {
            log.warn("verifySignature signedWitness failed. signedWitness={}", (Object)signedWitness);
            log.warn("Caused by ", (Throwable)e);
            this.verifySignatureWithECKeyResultCache.put(hash, false);
            return false;
        }
    }

    private boolean verifySignatureWithDSAKey(SignedWitness signedWitness) {
        P2PDataStorage.ByteArray hash = new P2PDataStorage.ByteArray(signedWitness.getHash());
        if (this.verifySignatureWithDSAKeyResultCache.containsKey(hash)) {
            return this.verifySignatureWithDSAKeyResultCache.get(hash);
        }
        try {
            PublicKey signaturePubKey = Sig.getPublicKeyFromBytes((byte[])signedWitness.getSignerPubKey());
            Sig.verify((PublicKey)signaturePubKey, (byte[])signedWitness.getAccountAgeWitnessHash(), (byte[])signedWitness.getSignature());
            this.verifySignatureWithDSAKeyResultCache.put(hash, true);
            return true;
        }
        catch (CryptoException e) {
            log.warn("verifySignature signedWitness failed. signedWitness={}", (Object)signedWitness);
            log.warn("Caused by ", (Throwable)e);
            this.verifySignatureWithDSAKeyResultCache.put(hash, false);
            return false;
        }
    }

    public Set<SignedWitness> getSignedWitnessSet(AccountAgeWitness accountAgeWitness) {
        P2PDataStorage.ByteArray key = new P2PDataStorage.ByteArray(accountAgeWitness.getHash());
        return this.signedWitnessSetByAccountAgeWitnessHash.getOrDefault(key, new HashSet());
    }

    public Set<SignedWitness> getArbitratorsSignedWitnessSet(AccountAgeWitness accountAgeWitness) {
        return this.getSignedWitnessSet(accountAgeWitness).stream().filter(SignedWitness::isSignedByArbitrator).collect(Collectors.toSet());
    }

    public Set<SignedWitness> getTrustedPeerSignedWitnessSet(AccountAgeWitness accountAgeWitness) {
        return this.getSignedWitnessSet(accountAgeWitness).stream().filter(e -> !e.isSignedByArbitrator()).collect(Collectors.toSet());
    }

    public Set<SignedWitness> getRootSignedWitnessSet(boolean includeSignedByArbitrator) {
        return this.getSignedWitnessMapValues().stream().filter(witness -> this.getSignedWitnessSetByOwnerPubKey(witness.getSignerPubKey(), new Stack<P2PDataStorage.ByteArray>()).isEmpty()).filter(witness -> includeSignedByArbitrator || witness.getVerificationMethod() != SignedWitness.VerificationMethod.ARBITRATOR).collect(Collectors.toSet());
    }

    public Set<SignedWitness> getUnsignedSignerPubKeys() {
        HashMap oldestUnsignedSigners = new HashMap();
        this.getRootSignedWitnessSet(false).forEach(signedWitness -> oldestUnsignedSigners.compute(new P2PDataStorage.ByteArray(signedWitness.getSignerPubKey()), (key, oldValue) -> oldValue == null ? signedWitness : (oldValue.getDate() > signedWitness.getDate() ? signedWitness : oldValue)));
        return new HashSet<SignedWitness>(oldestUnsignedSigners.values());
    }

    private Set<SignedWitness> getSignedWitnessSetByOwnerPubKey(byte[] ownerPubKey, Stack<P2PDataStorage.ByteArray> excluded) {
        P2PDataStorage.ByteArray key = new P2PDataStorage.ByteArray(ownerPubKey);
        if (this.signedWitnessSetByOwnerPubKey.containsKey(key)) {
            return this.signedWitnessSetByOwnerPubKey.get(key).stream().filter(e -> !excluded.contains(new P2PDataStorage.ByteArray(e.getSignerPubKey()))).collect(Collectors.toSet());
        }
        return new HashSet<SignedWitness>();
    }

    public boolean isSignedAccountAgeWitness(AccountAgeWitness accountAgeWitness) {
        return this.isSignerAccountAgeWitness(accountAgeWitness, new Date().getTime() + SIGNER_AGE);
    }

    public boolean isSignerAccountAgeWitness(AccountAgeWitness accountAgeWitness) {
        return this.isSignerAccountAgeWitness(accountAgeWitness, new Date().getTime());
    }

    public boolean isSufficientTradeAmountForSigning(BigInteger tradeAmount) {
        return tradeAmount.compareTo(MINIMUM_TRADE_AMOUNT_FOR_SIGNING) >= 0;
    }

    private boolean verifySigner(SignedWitness signedWitness) {
        return this.getSignedWitnessSetByOwnerPubKey(signedWitness.getWitnessOwnerPubKey(), new Stack<P2PDataStorage.ByteArray>()).stream().anyMatch(w -> this.isValidSignerWitnessInternal((SignedWitness)w, signedWitness.getDate(), new Stack<P2PDataStorage.ByteArray>()));
    }

    private boolean isSignerAccountAgeWitness(AccountAgeWitness accountAgeWitness, long time) {
        Stack<P2PDataStorage.ByteArray> excludedPubKeys = new Stack<P2PDataStorage.ByteArray>();
        Set<SignedWitness> signedWitnessSet = this.getSignedWitnessSet(accountAgeWitness);
        for (SignedWitness signedWitness : signedWitnessSet) {
            if (!this.isValidSignerWitnessInternal(signedWitness, time, excludedPubKeys)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidSignerWitnessInternal(SignedWitness signedWitness, long childSignedWitnessDateMillis, Stack<P2PDataStorage.ByteArray> excludedPubKeys) {
        if (this.filterManager.isWitnessSignerPubKeyBanned(Utils.HEX.encode(signedWitness.getWitnessOwnerPubKey()))) {
            return false;
        }
        if (!this.verifySignature(signedWitness)) {
            return false;
        }
        if (signedWitness.isSignedByArbitrator()) {
            return true;
        }
        if (!this.verifyDate(signedWitness, childSignedWitnessDateMillis)) {
            return false;
        }
        if (excludedPubKeys.size() >= 2000) {
            return false;
        }
        excludedPubKeys.push(new P2PDataStorage.ByteArray(signedWitness.getSignerPubKey()));
        excludedPubKeys.push(new P2PDataStorage.ByteArray(signedWitness.getWitnessOwnerPubKey()));
        Set<SignedWitness> signerSignedWitnessSet = this.getSignedWitnessSetByOwnerPubKey(signedWitness.getSignerPubKey(), excludedPubKeys);
        for (SignedWitness signerSignedWitness : signerSignedWitnessSet) {
            if (!this.isValidSignerWitnessInternal(signerSignedWitness, signedWitness.getDate(), excludedPubKeys)) continue;
            return true;
        }
        excludedPubKeys.pop();
        excludedPubKeys.pop();
        return false;
    }

    private boolean verifyDate(SignedWitness signedWitness, long childSignedWitnessDateMillis) {
        long childSignedWitnessDateMinusChargebackPeriodMillis = Instant.ofEpochMilli(childSignedWitnessDateMillis).minus(SIGNER_AGE, ChronoUnit.MILLIS).toEpochMilli();
        long signedWitnessDateMillis = signedWitness.getDate();
        return signedWitnessDateMillis <= childSignedWitnessDateMinusChargebackPeriodMillis;
    }

    @VisibleForTesting
    public void addToMap(SignedWitness signedWitness) {
        this.signedWitnessMap.putIfAbsent(signedWitness.getHashAsByteArray(), signedWitness);
        P2PDataStorage.ByteArray accountAgeWitnessHash = new P2PDataStorage.ByteArray(signedWitness.getAccountAgeWitnessHash());
        this.signedWitnessSetByAccountAgeWitnessHash.putIfAbsent(accountAgeWitnessHash, new HashSet());
        this.signedWitnessSetByAccountAgeWitnessHash.get(accountAgeWitnessHash).add(signedWitness);
        P2PDataStorage.ByteArray ownerPubKey = new P2PDataStorage.ByteArray(signedWitness.getWitnessOwnerPubKey());
        this.signedWitnessSetByOwnerPubKey.putIfAbsent(ownerPubKey, new HashSet());
        this.signedWitnessSetByOwnerPubKey.get(ownerPubKey).add(signedWitness);
    }

    private void publishSignedWitness(SignedWitness signedWitness) {
        if (!this.signedWitnessMap.containsKey(signedWitness.getHashAsByteArray())) {
            log.info("broadcast signed witness {}", (Object)signedWitness.toString());
            this.p2PService.addPersistableNetworkPayload((PersistableNetworkPayload)signedWitness, true);
            this.addToMap(signedWitness);
        }
    }

    private void doRepublishAllSignedWitnesses() {
        this.getSignedWitnessMapValues().forEach(signedWitness -> this.p2PService.addPersistableNetworkPayload((PersistableNetworkPayload)signedWitness, true));
    }

    @VisibleForTesting
    public void removeSignedWitness(SignedWitness signedWitness) {
        P2PDataStorage.ByteArray ownerPubKey;
        this.signedWitnessMap.remove(signedWitness.getHashAsByteArray());
        P2PDataStorage.ByteArray accountAgeWitnessHash = new P2PDataStorage.ByteArray(signedWitness.getAccountAgeWitnessHash());
        if (this.signedWitnessSetByAccountAgeWitnessHash.containsKey(accountAgeWitnessHash)) {
            Set<SignedWitness> set = this.signedWitnessSetByAccountAgeWitnessHash.get(accountAgeWitnessHash);
            set.remove(signedWitness);
            if (set.isEmpty()) {
                this.signedWitnessSetByAccountAgeWitnessHash.remove(accountAgeWitnessHash);
            }
        }
        if (this.signedWitnessSetByOwnerPubKey.containsKey(ownerPubKey = new P2PDataStorage.ByteArray(signedWitness.getWitnessOwnerPubKey()))) {
            Set<SignedWitness> set = this.signedWitnessSetByOwnerPubKey.get(ownerPubKey);
            set.remove(signedWitness);
            if (set.isEmpty()) {
                this.signedWitnessSetByOwnerPubKey.remove(ownerPubKey);
            }
        }
    }
}

