/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.account.sign;

import com.google.protobuf.ByteString;
import haveno.common.app.Capabilities;
import haveno.common.app.Capability;
import haveno.common.crypto.Hash;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.Utilities;
import haveno.core.trade.HavenoUtils;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.CapabilityRequiringPayload;
import haveno.network.p2p.storage.payload.DateTolerantPayload;
import haveno.network.p2p.storage.payload.ProcessOncePersistableNetworkPayload;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PersistableNetworkPayload;
import protobuf.SignedWitness;

public final class SignedWitness
implements ProcessOncePersistableNetworkPayload,
haveno.network.p2p.storage.payload.PersistableNetworkPayload,
DateTolerantPayload,
CapabilityRequiringPayload {
    private static final Logger log = LoggerFactory.getLogger(SignedWitness.class);
    private static final long TOLERANCE = TimeUnit.DAYS.toMillis(1L);
    private final VerificationMethod verificationMethod;
    private final byte[] accountAgeWitnessHash;
    private final byte[] signature;
    private final byte[] signerPubKey;
    private final byte[] witnessOwnerPubKey;
    private final long date;
    private final long tradeAmount;
    private final transient byte[] hash;

    public SignedWitness(VerificationMethod verificationMethod, byte[] accountAgeWitnessHash, byte[] signature, byte[] signerPubKey, byte[] witnessOwnerPubKey, long date, long tradeAmount) {
        this.verificationMethod = verificationMethod;
        this.accountAgeWitnessHash = (byte[])accountAgeWitnessHash.clone();
        this.signature = (byte[])signature.clone();
        this.signerPubKey = (byte[])signerPubKey.clone();
        this.witnessOwnerPubKey = (byte[])witnessOwnerPubKey.clone();
        this.date = date;
        this.tradeAmount = tradeAmount;
        byte[] data = Utilities.concatenateByteArrays((byte[])accountAgeWitnessHash, (byte[])signature);
        data = Utilities.concatenateByteArrays((byte[])data, (byte[])signerPubKey);
        this.hash = Hash.getSha256Ripemd160hash((byte[])data);
    }

    public PersistableNetworkPayload toProtoMessage() {
        SignedWitness.Builder builder = protobuf.SignedWitness.newBuilder().setVerificationMethod(VerificationMethod.toProtoMessage(this.verificationMethod)).setAccountAgeWitnessHash(ByteString.copyFrom((byte[])this.accountAgeWitnessHash)).setSignature(ByteString.copyFrom((byte[])this.signature)).setSignerPubKey(ByteString.copyFrom((byte[])this.signerPubKey)).setWitnessOwnerPubKey(ByteString.copyFrom((byte[])this.witnessOwnerPubKey)).setDate(this.date).setTradeAmount(this.tradeAmount);
        return PersistableNetworkPayload.newBuilder().setSignedWitness(builder).build();
    }

    public protobuf.SignedWitness toProtoSignedWitness() {
        return this.toProtoMessage().getSignedWitness();
    }

    public static SignedWitness fromProto(protobuf.SignedWitness proto) {
        return new SignedWitness(VerificationMethod.fromProto(proto.getVerificationMethod()), proto.getAccountAgeWitnessHash().toByteArray(), proto.getSignature().toByteArray(), proto.getSignerPubKey().toByteArray(), proto.getWitnessOwnerPubKey().toByteArray(), proto.getDate(), proto.getTradeAmount());
    }

    public boolean isDateInTolerance(Clock clock) {
        return Math.abs(clock.millis() - this.date) <= TOLERANCE;
    }

    public boolean verifyHashSize() {
        return this.hash.length == 20;
    }

    public Capabilities getRequiredCapabilities() {
        return new Capabilities(new Capability[]{Capability.SIGNED_ACCOUNT_AGE_WITNESS});
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean isSignedByArbitrator() {
        return this.verificationMethod == VerificationMethod.ARBITRATOR;
    }

    public P2PDataStorage.ByteArray getHashAsByteArray() {
        return new P2PDataStorage.ByteArray(this.hash);
    }

    public String toString() {
        return "SignedWitness{\n     verificationMethod=" + String.valueOf((Object)this.verificationMethod) + ",\n     witnessHash=" + Utilities.bytesAsHexString((byte[])this.accountAgeWitnessHash) + ",\n     signature=" + Utilities.bytesAsHexString((byte[])this.signature) + ",\n     signerPubKey=" + Utilities.bytesAsHexString((byte[])this.signerPubKey) + ",\n     witnessOwnerPubKey=" + Utilities.bytesAsHexString((byte[])this.witnessOwnerPubKey) + ",\n     date=" + String.valueOf(Instant.ofEpochMilli(this.date)) + ",\n     tradeAmount=" + HavenoUtils.formatXmr(this.tradeAmount, true) + ",\n     hash=" + Utilities.bytesAsHexString((byte[])this.hash) + "\n}";
    }

    public VerificationMethod getVerificationMethod() {
        return this.verificationMethod;
    }

    public byte[] getAccountAgeWitnessHash() {
        return this.accountAgeWitnessHash;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getSignerPubKey() {
        return this.signerPubKey;
    }

    public byte[] getWitnessOwnerPubKey() {
        return this.witnessOwnerPubKey;
    }

    public long getDate() {
        return this.date;
    }

    public long getTradeAmount() {
        return this.tradeAmount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignedWitness)) {
            return false;
        }
        SignedWitness other = (SignedWitness)o;
        if (this.getDate() != other.getDate()) {
            return false;
        }
        if (this.getTradeAmount() != other.getTradeAmount()) {
            return false;
        }
        VerificationMethod this$verificationMethod = this.getVerificationMethod();
        VerificationMethod other$verificationMethod = other.getVerificationMethod();
        if (this$verificationMethod == null ? other$verificationMethod != null : !((Object)((Object)this$verificationMethod)).equals((Object)other$verificationMethod)) {
            return false;
        }
        if (!Arrays.equals(this.getAccountAgeWitnessHash(), other.getAccountAgeWitnessHash())) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        if (!Arrays.equals(this.getSignerPubKey(), other.getSignerPubKey())) {
            return false;
        }
        return Arrays.equals(this.getWitnessOwnerPubKey(), other.getWitnessOwnerPubKey());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $date = this.getDate();
        result = result * 59 + (int)($date >>> 32 ^ $date);
        long $tradeAmount = this.getTradeAmount();
        result = result * 59 + (int)($tradeAmount >>> 32 ^ $tradeAmount);
        VerificationMethod $verificationMethod = this.getVerificationMethod();
        result = result * 59 + ($verificationMethod == null ? 43 : ((Object)((Object)$verificationMethod)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getAccountAgeWitnessHash());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        result = result * 59 + Arrays.hashCode(this.getSignerPubKey());
        result = result * 59 + Arrays.hashCode(this.getWitnessOwnerPubKey());
        return result;
    }

    public static enum VerificationMethod {
        ARBITRATOR,
        TRADE;


        public static VerificationMethod fromProto(SignedWitness.VerificationMethod method) {
            return (VerificationMethod)ProtoUtil.enumFromProto(VerificationMethod.class, (String)method.name());
        }

        public static SignedWitness.VerificationMethod toProtoMessage(VerificationMethod method) {
            return SignedWitness.VerificationMethod.valueOf((String)method.name());
        }
    }
}

