/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc.interceptor;

import com.google.inject.Inject;
import haveno.common.config.Config;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;

public class PasswordAuthInterceptor
implements ServerInterceptor {
    private static final String PASSWORD_KEY = "password";
    private final String expectedPasswordValue;

    @Inject
    public PasswordAuthInterceptor(Config config) {
        this.expectedPasswordValue = config.apiPassword;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata headers, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        String actualPasswordValue = (String)headers.get(Metadata.Key.of((String)PASSWORD_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        if (actualPasswordValue == null) {
            throw new StatusRuntimeException(Status.UNAUTHENTICATED.withDescription(String.format("missing '%s' rpc header value", PASSWORD_KEY)));
        }
        if (!actualPasswordValue.equals(this.expectedPasswordValue)) {
            throw new StatusRuntimeException(Status.UNAUTHENTICATED.withDescription(String.format("incorrect '%s' rpc header value", PASSWORD_KEY)));
        }
        return serverCallHandler.startCall(serverCall, headers);
    }
}

