/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import haveno.core.api.CoreApi;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.daemon.grpc.interceptor.CallRateMeteringInterceptor;
import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import haveno.daemon.grpc.interceptor.GrpcServiceRateMeteringConfig;
import haveno.proto.grpc.AddConnectionReply;
import haveno.proto.grpc.AddConnectionRequest;
import haveno.proto.grpc.CheckConnectionReply;
import haveno.proto.grpc.CheckConnectionRequest;
import haveno.proto.grpc.CheckConnectionsReply;
import haveno.proto.grpc.CheckConnectionsRequest;
import haveno.proto.grpc.GetAutoSwitchReply;
import haveno.proto.grpc.GetAutoSwitchRequest;
import haveno.proto.grpc.GetBestConnectionReply;
import haveno.proto.grpc.GetBestConnectionRequest;
import haveno.proto.grpc.GetConnectionReply;
import haveno.proto.grpc.GetConnectionRequest;
import haveno.proto.grpc.GetConnectionsReply;
import haveno.proto.grpc.GetConnectionsRequest;
import haveno.proto.grpc.RemoveConnectionReply;
import haveno.proto.grpc.RemoveConnectionRequest;
import haveno.proto.grpc.SetAutoSwitchReply;
import haveno.proto.grpc.SetAutoSwitchRequest;
import haveno.proto.grpc.SetConnectionReply;
import haveno.proto.grpc.SetConnectionRequest;
import haveno.proto.grpc.StartCheckingConnectionReply;
import haveno.proto.grpc.StartCheckingConnectionRequest;
import haveno.proto.grpc.StopCheckingConnectionReply;
import haveno.proto.grpc.StopCheckingConnectionRequest;
import haveno.proto.grpc.UrlConnection;
import haveno.proto.grpc.XmrConnectionsGrpc;
import io.grpc.ServerInterceptor;
import io.grpc.stub.StreamObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import monero.common.MoneroRpcConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcXmrConnectionService
extends XmrConnectionsGrpc.XmrConnectionsImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcXmrConnectionService.class);
    private final CoreApi coreApi;
    private final GrpcExceptionHandler exceptionHandler;

    @Inject
    public GrpcXmrConnectionService(CoreApi coreApi, GrpcExceptionHandler exceptionHandler) {
        this.coreApi = coreApi;
        this.exceptionHandler = exceptionHandler;
    }

    public void addConnection(AddConnectionRequest request, StreamObserver<AddConnectionReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            this.coreApi.addXmrConnection(GrpcXmrConnectionService.toMoneroRpcConnection(request.getConnection()));
            return AddConnectionReply.newBuilder().build();
        });
    }

    public void removeConnection(RemoveConnectionRequest request, StreamObserver<RemoveConnectionReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            this.coreApi.removeXmrConnection(GrpcXmrConnectionService.validateUri(request.getUrl()));
            return RemoveConnectionReply.newBuilder().build();
        });
    }

    public void getConnection(GetConnectionRequest request, StreamObserver<GetConnectionReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            UrlConnection replyConnection = GrpcXmrConnectionService.toUrlConnection(this.coreApi.getXmrConnection());
            GetConnectionReply.Builder builder = GetConnectionReply.newBuilder();
            if (replyConnection != null) {
                builder.setConnection(replyConnection);
            }
            return builder.build();
        });
    }

    public void getConnections(GetConnectionsRequest request, StreamObserver<GetConnectionsReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            List connections = this.coreApi.getXmrConnections();
            List replyConnections = connections.stream().map(GrpcXmrConnectionService::toUrlConnection).collect(Collectors.toList());
            return GetConnectionsReply.newBuilder().addAllConnections(replyConnections).build();
        });
    }

    public void setConnection(SetConnectionRequest request, StreamObserver<SetConnectionReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            if (request.getUrl() != null && !request.getUrl().isEmpty()) {
                this.coreApi.setXmrConnection(GrpcXmrConnectionService.validateUri(request.getUrl()));
            } else if (request.hasConnection()) {
                this.coreApi.setXmrConnection(GrpcXmrConnectionService.toMoneroRpcConnection(request.getConnection()));
            } else {
                this.coreApi.setXmrConnection((MoneroRpcConnection)null);
            }
            return SetConnectionReply.newBuilder().build();
        });
    }

    public void checkConnection(CheckConnectionRequest request, StreamObserver<CheckConnectionReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            MoneroRpcConnection connection = this.coreApi.checkXmrConnection();
            UrlConnection replyConnection = GrpcXmrConnectionService.toUrlConnection(connection);
            CheckConnectionReply.Builder builder = CheckConnectionReply.newBuilder();
            if (replyConnection != null) {
                builder.setConnection(replyConnection);
            }
            return builder.build();
        });
    }

    public void checkConnections(CheckConnectionsRequest request, StreamObserver<CheckConnectionsReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            List connections = this.coreApi.checkXmrConnections();
            List replyConnections = connections.stream().map(GrpcXmrConnectionService::toUrlConnection).collect(Collectors.toList());
            return CheckConnectionsReply.newBuilder().addAllConnections(replyConnections).build();
        });
    }

    public void startCheckingConnection(StartCheckingConnectionRequest request, StreamObserver<StartCheckingConnectionReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            int refreshMillis = request.getRefreshPeriod();
            Long refreshPeriod = refreshMillis == 0 ? null : Long.valueOf(refreshMillis);
            this.coreApi.startCheckingXmrConnection(refreshPeriod);
            return StartCheckingConnectionReply.newBuilder().build();
        });
    }

    public void stopCheckingConnection(StopCheckingConnectionRequest request, StreamObserver<StopCheckingConnectionReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            this.coreApi.stopCheckingXmrConnection();
            return StopCheckingConnectionReply.newBuilder().build();
        });
    }

    public void getBestConnection(GetBestConnectionRequest request, StreamObserver<GetBestConnectionReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            MoneroRpcConnection connection = this.coreApi.getBestXmrConnection();
            UrlConnection replyConnection = GrpcXmrConnectionService.toUrlConnection(connection);
            GetBestConnectionReply.Builder builder = GetBestConnectionReply.newBuilder();
            if (replyConnection != null) {
                builder.setConnection(replyConnection);
            }
            return builder.build();
        });
    }

    public void setAutoSwitch(SetAutoSwitchRequest request, StreamObserver<SetAutoSwitchReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            this.coreApi.setXmrConnectionAutoSwitch(request.getAutoSwitch());
            return SetAutoSwitchReply.newBuilder().build();
        });
    }

    public void getAutoSwitch(GetAutoSwitchRequest request, StreamObserver<GetAutoSwitchReply> responseObserver) {
        this.handleRequest(responseObserver, () -> {
            GetAutoSwitchReply.Builder builder = GetAutoSwitchReply.newBuilder();
            builder.setAutoSwitch(this.coreApi.getXmrConnectionAutoSwitch());
            return builder.build();
        });
    }

    private <_Reply> void handleRequest(StreamObserver<_Reply> responseObserver, RpcRequestHandler<_Reply> handler) {
        try {
            _Reply reply = handler.handleRequest();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    private static UrlConnection toUrlConnection(MoneroRpcConnection rpcConnection) {
        if (rpcConnection == null) {
            return null;
        }
        return UrlConnection.newBuilder().setUrl(rpcConnection.getUri()).setPriority(rpcConnection.getPriority()).setOnlineStatus(GrpcXmrConnectionService.toOnlineStatus(rpcConnection.isOnline())).setAuthenticationStatus(GrpcXmrConnectionService.toAuthenticationStatus(rpcConnection.isAuthenticated())).build();
    }

    private static UrlConnection.AuthenticationStatus toAuthenticationStatus(Boolean authenticated) {
        if (authenticated == null) {
            return UrlConnection.AuthenticationStatus.NO_AUTHENTICATION;
        }
        if (authenticated.booleanValue()) {
            return UrlConnection.AuthenticationStatus.AUTHENTICATED;
        }
        return UrlConnection.AuthenticationStatus.NOT_AUTHENTICATED;
    }

    private static UrlConnection.OnlineStatus toOnlineStatus(Boolean online) {
        if (online == null) {
            return UrlConnection.OnlineStatus.UNKNOWN;
        }
        if (online.booleanValue()) {
            return UrlConnection.OnlineStatus.ONLINE;
        }
        return UrlConnection.OnlineStatus.OFFLINE;
    }

    private static MoneroRpcConnection toMoneroRpcConnection(UrlConnection uriConnection) throws MalformedURLException {
        if (uriConnection == null) {
            return null;
        }
        return new MoneroRpcConnection(GrpcXmrConnectionService.validateUri(uriConnection.getUrl()), GrpcXmrConnectionService.nullIfEmpty(uriConnection.getUsername()), GrpcXmrConnectionService.nullIfEmpty(uriConnection.getPassword())).setPriority(uriConnection.getPriority());
    }

    private static String validateUri(String url) throws MalformedURLException {
        if (url.isEmpty()) {
            throw new IllegalArgumentException("URL is required");
        }
        return new URL(url).toString();
    }

    private static String nullIfEmpty(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    /*
     * Exception decompiling
     */
    final ServerInterceptor[] interceptors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<ServerInterceptor> rateMeteringInterceptor() {
        return GrpcServiceRateMeteringConfig.getCustomRateMeteringInterceptor(this.coreApi.getConfig().appDataDir, ((Object)((Object)this)).getClass()).or(() -> Optional.of(CallRateMeteringInterceptor.valueOf((Map<String, GrpcCallRateMeter>)new HashMap<String, GrpcCallRateMeter>(){
            {
                int allowedCallsPerTimeWindow = 10;
                this.put(XmrConnectionsGrpc.getAddConnectionMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getRemoveConnectionMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getGetConnectionMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getGetConnectionsMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getSetConnectionMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getCheckConnectionMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getCheckConnectionsMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getStartCheckingConnectionMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getStopCheckingConnectionMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getGetBestConnectionMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
                this.put(XmrConnectionsGrpc.getSetAutoSwitchMethod().getFullMethodName(), new GrpcCallRateMeter(allowedCallsPerTimeWindow, TimeUnit.SECONDS));
            }
        })));
    }

    private static /* synthetic */ ServerInterceptor[] lambda$interceptors$13() {
        return new ServerInterceptor[0];
    }

    @FunctionalInterface
    private static interface RpcRequestHandler<_Reply> {
        public _Reply handleRequest() throws Exception;
    }
}

