/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import haveno.common.config.Config;
import haveno.core.api.CoreApi;
import haveno.core.api.model.TradeInfo;
import haveno.core.trade.Trade;
import haveno.daemon.grpc.GrpcErrorMessageHandler;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.daemon.grpc.interceptor.CallRateMeteringInterceptor;
import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import haveno.daemon.grpc.interceptor.GrpcServiceRateMeteringConfig;
import haveno.proto.grpc.CompleteTradeReply;
import haveno.proto.grpc.CompleteTradeRequest;
import haveno.proto.grpc.ConfirmPaymentReceivedReply;
import haveno.proto.grpc.ConfirmPaymentReceivedRequest;
import haveno.proto.grpc.ConfirmPaymentSentReply;
import haveno.proto.grpc.ConfirmPaymentSentRequest;
import haveno.proto.grpc.GetChatMessagesReply;
import haveno.proto.grpc.GetChatMessagesRequest;
import haveno.proto.grpc.GetTradeReply;
import haveno.proto.grpc.GetTradeRequest;
import haveno.proto.grpc.GetTradesReply;
import haveno.proto.grpc.GetTradesRequest;
import haveno.proto.grpc.SendChatMessageReply;
import haveno.proto.grpc.SendChatMessageRequest;
import haveno.proto.grpc.TakeOfferReply;
import haveno.proto.grpc.TakeOfferRequest;
import haveno.proto.grpc.TradesGrpc;
import io.grpc.ServerInterceptor;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcTradesService
extends TradesGrpc.TradesImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcTradesService.class);
    private final CoreApi coreApi;
    private final GrpcExceptionHandler exceptionHandler;

    @Inject
    public GrpcTradesService(CoreApi coreApi, GrpcExceptionHandler exceptionHandler) {
        this.coreApi = coreApi;
        this.exceptionHandler = exceptionHandler;
    }

    public void getTrade(GetTradeRequest req, StreamObserver<GetTradeReply> responseObserver) {
        try {
            Trade trade = this.coreApi.getTrade(req.getTradeId());
            GetTradeReply reply = GetTradeReply.newBuilder().setTrade(TradeInfo.toTradeInfo((Trade)trade).toProtoMessage()).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (IllegalArgumentException cause) {
            cause.printStackTrace();
            this.exceptionHandler.handleExceptionAsWarning(log, "getTrade", cause, responseObserver);
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getTrades(GetTradesRequest req, StreamObserver<GetTradesReply> responseObserver) {
        try {
            List trades = this.coreApi.getTrades().stream().map(TradeInfo::toTradeInfo).collect(Collectors.toList());
            GetTradesReply reply = GetTradesReply.newBuilder().addAllTrades((Iterable)trades.stream().map(TradeInfo::toProtoMessage).collect(Collectors.toList())).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void takeOffer(TakeOfferRequest req, StreamObserver<TakeOfferReply> responseObserver) {
        GrpcErrorMessageHandler errorMessageHandler = new GrpcErrorMessageHandler(TradesGrpc.getTakeOfferMethod().getFullMethodName(), responseObserver, this.exceptionHandler, log);
        try {
            this.coreApi.takeOffer(req.getOfferId(), req.getPaymentAccountId(), req.getAmount(), req.getChallenge(), trade -> {
                TradeInfo tradeInfo = TradeInfo.toTradeInfo((Trade)trade);
                TakeOfferReply reply = TakeOfferReply.newBuilder().setTrade(tradeInfo.toProtoMessage()).build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
            }, errorMessage -> {
                if (!errorMessageHandler.isErrorHandled()) {
                    errorMessageHandler.handleErrorMessage(errorMessage);
                }
            });
        }
        catch (Throwable cause) {
            cause.printStackTrace();
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void confirmPaymentSent(ConfirmPaymentSentRequest req, StreamObserver<ConfirmPaymentSentReply> responseObserver) {
        GrpcErrorMessageHandler errorMessageHandler = new GrpcErrorMessageHandler(TradesGrpc.getConfirmPaymentSentMethod().getFullMethodName(), responseObserver, this.exceptionHandler, log);
        try {
            this.coreApi.confirmPaymentSent(req.getTradeId(), () -> {
                ConfirmPaymentSentReply reply = ConfirmPaymentSentReply.newBuilder().build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
            }, errorMessage -> {
                if (!errorMessageHandler.isErrorHandled()) {
                    errorMessageHandler.handleErrorMessage(errorMessage);
                }
            });
        }
        catch (Throwable cause) {
            cause.printStackTrace();
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void confirmPaymentReceived(ConfirmPaymentReceivedRequest req, StreamObserver<ConfirmPaymentReceivedReply> responseObserver) {
        GrpcErrorMessageHandler errorMessageHandler = new GrpcErrorMessageHandler(TradesGrpc.getConfirmPaymentReceivedMethod().getFullMethodName(), responseObserver, this.exceptionHandler, log);
        try {
            this.coreApi.confirmPaymentReceived(req.getTradeId(), () -> {
                ConfirmPaymentReceivedReply reply = ConfirmPaymentReceivedReply.newBuilder().build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
            }, errorMessage -> {
                if (!errorMessageHandler.isErrorHandled()) {
                    errorMessageHandler.handleErrorMessage(errorMessage);
                }
            });
        }
        catch (Throwable cause) {
            cause.printStackTrace();
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void completeTrade(CompleteTradeRequest req, StreamObserver<CompleteTradeReply> responseObserver) {
        try {
            this.coreApi.closeTrade(req.getTradeId());
            CompleteTradeReply reply = CompleteTradeReply.newBuilder().build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getChatMessages(GetChatMessagesRequest req, StreamObserver<GetChatMessagesReply> responseObserver) {
        try {
            List tradeChats = this.coreApi.getChatMessages(req.getTradeId()).stream().map(msg -> msg.toProtoNetworkEnvelope().getChatMessage()).collect(Collectors.toList());
            GetChatMessagesReply reply = GetChatMessagesReply.newBuilder().addAllMessage(tradeChats).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void sendChatMessage(SendChatMessageRequest req, StreamObserver<SendChatMessageReply> responseObserver) {
        try {
            this.coreApi.sendChatMessage(req.getTradeId(), req.getMessage());
            SendChatMessageReply reply = SendChatMessageReply.newBuilder().build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    /*
     * Exception decompiling
     */
    final ServerInterceptor[] interceptors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final Optional<ServerInterceptor> rateMeteringInterceptor() {
        return GrpcServiceRateMeteringConfig.getCustomRateMeteringInterceptor(this.coreApi.getConfig().appDataDir, ((Object)((Object)this)).getClass()).or(() -> Optional.of(CallRateMeteringInterceptor.valueOf((Map<String, GrpcCallRateMeter>)new HashMap<String, GrpcCallRateMeter>(){
            {
                this.put(TradesGrpc.getGetTradeMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 1, TimeUnit.SECONDS));
                this.put(TradesGrpc.getGetTradesMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 1, TimeUnit.SECONDS));
                this.put(TradesGrpc.getTakeOfferMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
                this.put(TradesGrpc.getConfirmPaymentSentMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
                this.put(TradesGrpc.getConfirmPaymentReceivedMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
                this.put(TradesGrpc.getCompleteTradeMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
                this.put(TradesGrpc.getWithdrawFundsMethod().getFullMethodName(), new GrpcCallRateMeter(3, TimeUnit.MINUTES));
                this.put(TradesGrpc.getGetChatMessagesMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 4, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
                this.put(TradesGrpc.getSendChatMessageMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 4, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
            }
        })));
    }

    private static /* synthetic */ ServerInterceptor[] lambda$interceptors$8() {
        return new ServerInterceptor[0];
    }
}

