/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.core.app.HavenoHeadlessApp;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.proto.grpc.ShutdownServerGrpc;
import haveno.proto.grpc.StopReply;
import haveno.proto.grpc.StopRequest;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcShutdownService
extends ShutdownServerGrpc.ShutdownServerImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcShutdownService.class);
    private final GrpcExceptionHandler exceptionHandler;

    @Inject
    public GrpcShutdownService(GrpcExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void stop(StopRequest req, final StreamObserver<StopReply> responseObserver) {
        try {
            log.info("Shutdown request received.");
            HavenoHeadlessApp.setOnGracefulShutDownHandler((Runnable)new Runnable(){

                @Override
                public void run() {
                    StopReply reply = StopReply.newBuilder().build();
                    responseObserver.onNext((Object)reply);
                    responseObserver.onCompleted();
                }
            });
            UserThread.runAfter((Runnable)HavenoHeadlessApp.getShutDownHandler(), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }
}

