/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.config.Config;
import haveno.core.api.CoreContext;
import haveno.daemon.grpc.GrpcAccountService;
import haveno.daemon.grpc.GrpcDisputeAgentsService;
import haveno.daemon.grpc.GrpcDisputesService;
import haveno.daemon.grpc.GrpcGetTradeStatisticsService;
import haveno.daemon.grpc.GrpcHelpService;
import haveno.daemon.grpc.GrpcNotificationsService;
import haveno.daemon.grpc.GrpcOffersService;
import haveno.daemon.grpc.GrpcPaymentAccountsService;
import haveno.daemon.grpc.GrpcPriceService;
import haveno.daemon.grpc.GrpcShutdownService;
import haveno.daemon.grpc.GrpcTradesService;
import haveno.daemon.grpc.GrpcVersionService;
import haveno.daemon.grpc.GrpcWalletsService;
import haveno.daemon.grpc.GrpcXmrConnectionService;
import haveno.daemon.grpc.GrpcXmrNodeService;
import haveno.daemon.grpc.interceptor.PasswordAuthInterceptor;
import io.grpc.BindableService;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GrpcServer {
    private static final Logger log = LoggerFactory.getLogger(GrpcServer.class);
    private final Server server;

    @Inject
    public GrpcServer(CoreContext coreContext, Config config, PasswordAuthInterceptor passwordAuthInterceptor, GrpcAccountService accountService, GrpcDisputeAgentsService disputeAgentsService, GrpcDisputesService disputesService, GrpcHelpService helpService, GrpcOffersService offersService, GrpcPaymentAccountsService paymentAccountsService, GrpcPriceService priceService, GrpcShutdownService shutdownService, GrpcVersionService versionService, GrpcGetTradeStatisticsService tradeStatisticsService, GrpcTradesService tradesService, GrpcWalletsService walletsService, GrpcNotificationsService notificationsService, GrpcXmrConnectionService moneroConnectionsService, GrpcXmrNodeService moneroNodeService) {
        this.server = ServerBuilder.forPort((int)config.apiPort).addService((BindableService)shutdownService).intercept((ServerInterceptor)passwordAuthInterceptor).addService(ServerInterceptors.interceptForward((BindableService)accountService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : accountService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)disputeAgentsService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : disputeAgentsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)disputesService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : disputesService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)helpService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : helpService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)offersService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : offersService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)paymentAccountsService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : paymentAccountsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)priceService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : priceService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)tradeStatisticsService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : tradeStatisticsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)tradesService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : tradesService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)versionService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : versionService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)walletsService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : walletsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)notificationsService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : notificationsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)moneroConnectionsService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : moneroConnectionsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)moneroNodeService, (ServerInterceptor[])(config.disableRateLimits ? this.interceptors() : moneroNodeService.interceptors()))).build();
        coreContext.setApiUser(true);
    }

    private ServerInterceptor[] interceptors() {
        return new ServerInterceptor[]{this.callLoggingInterceptor()};
    }

    private ServerInterceptor callLoggingInterceptor() {
        return new ServerInterceptor(this){

            public <RequestT, ResponseT> ServerCall.Listener<RequestT> interceptCall(ServerCall<RequestT, ResponseT> call, Metadata headers, ServerCallHandler<RequestT, ResponseT> next) {
                log.debug("GRPC endpoint called: " + call.getMethodDescriptor().getFullMethodName());
                return next.startCall(call, headers);
            }
        };
    }

    public void start() {
        try {
            this.server.start();
            log.info("listening on port {}", (Object)this.server.getPort());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void shutdown() {
        log.info("Server shutdown started");
        this.server.shutdown();
        log.info("Server shutdown complete");
    }
}

