/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import haveno.common.config.Config;
import haveno.core.api.CoreApi;
import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountFactory;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.proto.CoreProtoResolver;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.daemon.grpc.interceptor.CallRateMeteringInterceptor;
import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import haveno.daemon.grpc.interceptor.GrpcServiceRateMeteringConfig;
import haveno.proto.grpc.CreateCryptoCurrencyPaymentAccountReply;
import haveno.proto.grpc.CreateCryptoCurrencyPaymentAccountRequest;
import haveno.proto.grpc.CreatePaymentAccountReply;
import haveno.proto.grpc.CreatePaymentAccountRequest;
import haveno.proto.grpc.DeletePaymentAccountReply;
import haveno.proto.grpc.DeletePaymentAccountRequest;
import haveno.proto.grpc.GetCryptoCurrencyPaymentMethodsReply;
import haveno.proto.grpc.GetCryptoCurrencyPaymentMethodsRequest;
import haveno.proto.grpc.GetPaymentAccountFormReply;
import haveno.proto.grpc.GetPaymentAccountFormRequest;
import haveno.proto.grpc.GetPaymentAccountsReply;
import haveno.proto.grpc.GetPaymentAccountsRequest;
import haveno.proto.grpc.GetPaymentMethodsReply;
import haveno.proto.grpc.GetPaymentMethodsRequest;
import haveno.proto.grpc.PaymentAccountsGrpc;
import haveno.proto.grpc.ValidateFormFieldReply;
import haveno.proto.grpc.ValidateFormFieldRequest;
import io.grpc.ServerInterceptor;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PaymentAccountForm;
import protobuf.PaymentAccountFormField;

class GrpcPaymentAccountsService
extends PaymentAccountsGrpc.PaymentAccountsImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcPaymentAccountsService.class);
    private final CoreApi coreApi;
    private final GrpcExceptionHandler exceptionHandler;

    @Inject
    public GrpcPaymentAccountsService(CoreApi coreApi, GrpcExceptionHandler exceptionHandler) {
        this.coreApi = coreApi;
        this.exceptionHandler = exceptionHandler;
    }

    public void createPaymentAccount(CreatePaymentAccountRequest req, StreamObserver<CreatePaymentAccountReply> responseObserver) {
        try {
            PaymentAccount paymentAccount = this.coreApi.createPaymentAccount(haveno.core.api.model.PaymentAccountForm.fromProto((PaymentAccountForm)req.getPaymentAccountForm()));
            CreatePaymentAccountReply reply = CreatePaymentAccountReply.newBuilder().setPaymentAccount(paymentAccount.toProtoMessage()).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getPaymentAccounts(GetPaymentAccountsRequest req, StreamObserver<GetPaymentAccountsReply> responseObserver) {
        try {
            List paymentAccounts = this.coreApi.getPaymentAccounts().stream().map(PaymentAccount::toProtoMessage).collect(Collectors.toList());
            GetPaymentAccountsReply reply = GetPaymentAccountsReply.newBuilder().addAllPaymentAccounts(paymentAccounts).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getPaymentMethods(GetPaymentMethodsRequest req, StreamObserver<GetPaymentMethodsReply> responseObserver) {
        try {
            List paymentMethods = this.coreApi.getPaymentMethods().stream().map(PaymentMethod::toProtoMessage).collect(Collectors.toList());
            GetPaymentMethodsReply reply = GetPaymentMethodsReply.newBuilder().addAllPaymentMethods(paymentMethods).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getPaymentAccountForm(GetPaymentAccountFormRequest req, StreamObserver<GetPaymentAccountFormReply> responseObserver) {
        try {
            haveno.core.api.model.PaymentAccountForm form = null;
            if (req.getPaymentMethodId().isEmpty()) {
                PaymentAccount account = PaymentAccountFactory.getPaymentAccount((PaymentMethod)PaymentMethod.getPaymentMethod((String)req.getPaymentAccountPayload().getPaymentMethodId()));
                account.setAccountName("tmp");
                account.init(PaymentAccountPayload.fromProto((protobuf.PaymentAccountPayload)req.getPaymentAccountPayload(), (CoreProtoResolver)new CoreProtoResolver()));
                account.setAccountName(null);
                form = this.coreApi.getPaymentAccountForm(account);
            } else {
                form = this.coreApi.getPaymentAccountForm(req.getPaymentMethodId());
            }
            GetPaymentAccountFormReply reply = GetPaymentAccountFormReply.newBuilder().setPaymentAccountForm(form.toProtoMessage()).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void createCryptoCurrencyPaymentAccount(CreateCryptoCurrencyPaymentAccountRequest req, StreamObserver<CreateCryptoCurrencyPaymentAccountReply> responseObserver) {
        try {
            PaymentAccount paymentAccount = this.coreApi.createCryptoCurrencyPaymentAccount(req.getAccountName(), req.getCurrencyCode(), req.getAddress(), req.getTradeInstant());
            CreateCryptoCurrencyPaymentAccountReply reply = CreateCryptoCurrencyPaymentAccountReply.newBuilder().setPaymentAccount(paymentAccount.toProtoMessage()).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void deletePaymentAccount(DeletePaymentAccountRequest req, StreamObserver<DeletePaymentAccountReply> responseObserver) {
        try {
            this.coreApi.deletePaymentAccount(req.getPaymentAccountId());
            DeletePaymentAccountReply reply = DeletePaymentAccountReply.newBuilder().build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getCryptoCurrencyPaymentMethods(GetCryptoCurrencyPaymentMethodsRequest req, StreamObserver<GetCryptoCurrencyPaymentMethodsReply> responseObserver) {
        try {
            List paymentMethods = this.coreApi.getCryptoCurrencyPaymentMethods().stream().map(PaymentMethod::toProtoMessage).collect(Collectors.toList());
            GetCryptoCurrencyPaymentMethodsReply reply = GetCryptoCurrencyPaymentMethodsReply.newBuilder().addAllPaymentMethods(paymentMethods).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void validateFormField(ValidateFormFieldRequest req, StreamObserver<ValidateFormFieldReply> responseObserver) {
        try {
            this.coreApi.validateFormField(haveno.core.api.model.PaymentAccountForm.fromProto((PaymentAccountForm)req.getForm()), PaymentAccountFormField.FieldId.fromProto((PaymentAccountFormField.FieldId)req.getFieldId()), req.getValue());
            ValidateFormFieldReply reply = ValidateFormFieldReply.newBuilder().build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    /*
     * Exception decompiling
     */
    final ServerInterceptor[] interceptors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final Optional<ServerInterceptor> rateMeteringInterceptor() {
        return GrpcServiceRateMeteringConfig.getCustomRateMeteringInterceptor(this.coreApi.getConfig().appDataDir, ((Object)((Object)this)).getClass()).or(() -> Optional.of(CallRateMeteringInterceptor.valueOf((Map<String, GrpcCallRateMeter>)new HashMap<String, GrpcCallRateMeter>(){
            {
                this.put(PaymentAccountsGrpc.getCreatePaymentAccountMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 100 : 1, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
                this.put(PaymentAccountsGrpc.getCreateCryptoCurrencyPaymentAccountMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 100 : 1, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
                this.put(PaymentAccountsGrpc.getGetPaymentAccountsMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 100 : 1, TimeUnit.SECONDS));
                this.put(PaymentAccountsGrpc.getGetPaymentMethodsMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 100 : 1, TimeUnit.SECONDS));
                this.put(PaymentAccountsGrpc.getGetPaymentAccountFormMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 100 : 1, TimeUnit.SECONDS));
            }
        })));
    }

    private static /* synthetic */ ServerInterceptor[] lambda$interceptors$1() {
        return new ServerInterceptor[0];
    }
}

