/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import haveno.common.config.Config;
import haveno.core.api.CoreApi;
import haveno.core.api.model.OfferInfo;
import haveno.core.offer.Offer;
import haveno.core.offer.OpenOffer;
import haveno.daemon.grpc.GrpcErrorMessageHandler;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.daemon.grpc.interceptor.CallRateMeteringInterceptor;
import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import haveno.daemon.grpc.interceptor.GrpcServiceRateMeteringConfig;
import haveno.proto.grpc.CancelOfferReply;
import haveno.proto.grpc.CancelOfferRequest;
import haveno.proto.grpc.GetMyOfferReply;
import haveno.proto.grpc.GetMyOfferRequest;
import haveno.proto.grpc.GetMyOffersReply;
import haveno.proto.grpc.GetMyOffersRequest;
import haveno.proto.grpc.GetOfferReply;
import haveno.proto.grpc.GetOfferRequest;
import haveno.proto.grpc.GetOffersReply;
import haveno.proto.grpc.GetOffersRequest;
import haveno.proto.grpc.OffersGrpc;
import haveno.proto.grpc.PostOfferReply;
import haveno.proto.grpc.PostOfferRequest;
import io.grpc.ServerInterceptor;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcOffersService
extends OffersGrpc.OffersImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcOffersService.class);
    private final CoreApi coreApi;
    private final GrpcExceptionHandler exceptionHandler;

    @Inject
    public GrpcOffersService(CoreApi coreApi, GrpcExceptionHandler exceptionHandler) {
        this.coreApi = coreApi;
        this.exceptionHandler = exceptionHandler;
    }

    public void getOffer(GetOfferRequest req, StreamObserver<GetOfferReply> responseObserver) {
        try {
            Offer offer = this.coreApi.getOffer(req.getId());
            GetOfferReply reply = GetOfferReply.newBuilder().setOffer(OfferInfo.toOfferInfo((Offer)offer).toProtoMessage()).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getMyOffer(GetMyOfferRequest req, StreamObserver<GetMyOfferReply> responseObserver) {
        try {
            OpenOffer openOffer = this.coreApi.getMyOffer(req.getId());
            GetMyOfferReply reply = GetMyOfferReply.newBuilder().setOffer(OfferInfo.toMyOfferInfo((OpenOffer)openOffer).toProtoMessage()).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getOffers(GetOffersRequest req, StreamObserver<GetOffersReply> responseObserver) {
        try {
            List result = this.coreApi.getOffers(req.getDirection(), req.getCurrencyCode()).stream().map(OfferInfo::toOfferInfo).collect(Collectors.toList());
            GetOffersReply reply = GetOffersReply.newBuilder().addAllOffers((Iterable)result.stream().map(OfferInfo::toProtoMessage).collect(Collectors.toList())).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getMyOffers(GetMyOffersRequest req, StreamObserver<GetMyOffersReply> responseObserver) {
        try {
            ArrayList<OfferInfo> result = new ArrayList<OfferInfo>();
            for (OpenOffer offer : this.coreApi.getMyOffers(req.getDirection(), req.getCurrencyCode())) {
                result.add(OfferInfo.toMyOfferInfo((OpenOffer)offer));
            }
            GetMyOffersReply reply = GetMyOffersReply.newBuilder().addAllOffers((Iterable)result.stream().map(OfferInfo::toProtoMessage).collect(Collectors.toList())).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void postOffer(PostOfferRequest req, StreamObserver<PostOfferReply> responseObserver) {
        GrpcErrorMessageHandler errorMessageHandler = new GrpcErrorMessageHandler(OffersGrpc.getPostOfferMethod().getFullMethodName(), responseObserver, this.exceptionHandler, log);
        try {
            this.coreApi.postOffer(req.getCurrencyCode(), req.getDirection(), req.getPrice(), req.getUseMarketBasedPrice(), req.getMarketPriceMarginPct(), req.getAmount(), req.getMinAmount(), req.getSecurityDepositPct(), req.getTriggerPrice(), req.getReserveExactAmount(), req.getPaymentAccountId(), req.getIsPrivateOffer(), req.getBuyerAsTakerWithoutDeposit(), req.getExtraInfo(), req.getSourceOfferId(), offer -> {
                OpenOffer openOffer = this.coreApi.getMyOffer(offer.getId());
                OfferInfo offerInfo = OfferInfo.toMyOfferInfo((OpenOffer)openOffer);
                PostOfferReply reply = PostOfferReply.newBuilder().setOffer(offerInfo.toProtoMessage()).build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
            }, errorMessage -> {
                if (!errorMessageHandler.isErrorHandled()) {
                    errorMessageHandler.handleErrorMessage(errorMessage);
                }
            });
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void cancelOffer(CancelOfferRequest req, StreamObserver<CancelOfferReply> responseObserver) {
        GrpcErrorMessageHandler errorMessageHandler = new GrpcErrorMessageHandler(OffersGrpc.getCancelOfferMethod().getFullMethodName(), responseObserver, this.exceptionHandler, log);
        try {
            this.coreApi.cancelOffer(req.getId(), () -> {
                CancelOfferReply reply = CancelOfferReply.newBuilder().build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
            }, errorMessage -> {
                if (!errorMessageHandler.isErrorHandled()) {
                    errorMessageHandler.handleErrorMessage(errorMessage);
                }
            });
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    /*
     * Exception decompiling
     */
    final ServerInterceptor[] interceptors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final Optional<ServerInterceptor> rateMeteringInterceptor() {
        return GrpcServiceRateMeteringConfig.getCustomRateMeteringInterceptor(this.coreApi.getConfig().appDataDir, ((Object)((Object)this)).getClass()).or(() -> Optional.of(CallRateMeteringInterceptor.valueOf((Map<String, GrpcCallRateMeter>)new HashMap<String, GrpcCallRateMeter>(){
            {
                this.put(OffersGrpc.getGetOfferMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, TimeUnit.SECONDS));
                this.put(OffersGrpc.getGetMyOfferMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, TimeUnit.SECONDS));
                this.put(OffersGrpc.getGetOffersMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, TimeUnit.SECONDS));
                this.put(OffersGrpc.getGetMyOffersMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
                this.put(OffersGrpc.getPostOfferMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
                this.put(OffersGrpc.getCancelOfferMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 75 : 3, Config.baseCurrencyNetwork().isTestnet() ? TimeUnit.SECONDS : TimeUnit.MINUTES));
            }
        })));
    }

    private static /* synthetic */ ServerInterceptor[] lambda$interceptors$5() {
        return new ServerInterceptor[0];
    }
}

