/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import haveno.core.api.CoreApi;
import haveno.core.api.NotificationListener;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.daemon.grpc.interceptor.CallRateMeteringInterceptor;
import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import haveno.daemon.grpc.interceptor.GrpcServiceRateMeteringConfig;
import haveno.proto.grpc.NotificationMessage;
import haveno.proto.grpc.NotificationsGrpc;
import haveno.proto.grpc.RegisterNotificationListenerRequest;
import haveno.proto.grpc.SendNotificationReply;
import haveno.proto.grpc.SendNotificationRequest;
import io.grpc.Context;
import io.grpc.ServerInterceptor;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcNotificationsService
extends NotificationsGrpc.NotificationsImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcNotificationsService.class);
    private final CoreApi coreApi;
    private final GrpcExceptionHandler exceptionHandler;

    @Inject
    public GrpcNotificationsService(CoreApi coreApi, GrpcExceptionHandler exceptionHandler) {
        this.coreApi = coreApi;
        this.exceptionHandler = exceptionHandler;
    }

    public void registerNotificationListener(RegisterNotificationListenerRequest request, StreamObserver<NotificationMessage> responseObserver) {
        Context ctx = Context.current().fork();
        ctx.run(() -> {
            try {
                this.coreApi.addNotificationListener((NotificationListener)new GrpcNotificationListener(responseObserver));
            }
            catch (Throwable t) {
                this.exceptionHandler.handleException(log, t, responseObserver);
            }
        });
    }

    public void sendNotification(SendNotificationRequest request, StreamObserver<SendNotificationReply> responseObserver) {
        Context ctx = Context.current().fork();
        ctx.run(() -> {
            try {
                this.coreApi.sendNotification(request.getNotification());
                responseObserver.onNext((Object)SendNotificationReply.newBuilder().build());
                responseObserver.onCompleted();
            }
            catch (Throwable t) {
                this.exceptionHandler.handleException(log, t, responseObserver);
            }
        });
    }

    /*
     * Exception decompiling
     */
    final ServerInterceptor[] interceptors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final Optional<ServerInterceptor> rateMeteringInterceptor() {
        return GrpcServiceRateMeteringConfig.getCustomRateMeteringInterceptor(this.coreApi.getConfig().appDataDir, ((Object)((Object)this)).getClass()).or(() -> Optional.of(CallRateMeteringInterceptor.valueOf((Map<String, GrpcCallRateMeter>)new HashMap<String, GrpcCallRateMeter>(){
            {
                this.put(NotificationsGrpc.getRegisterNotificationListenerMethod().getFullMethodName(), new GrpcCallRateMeter(10, TimeUnit.SECONDS));
                this.put(NotificationsGrpc.getSendNotificationMethod().getFullMethodName(), new GrpcCallRateMeter(10, TimeUnit.SECONDS));
            }
        })));
    }

    private static /* synthetic */ ServerInterceptor[] lambda$interceptors$3() {
        return new ServerInterceptor[0];
    }

    private static final class GrpcNotificationListener
    implements NotificationListener {
        @NonNull
        private final StreamObserver<NotificationMessage> responseObserver;

        public void onMessage(@NonNull NotificationMessage message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (!((ServerCallStreamObserver)this.responseObserver).isCancelled()) {
                this.responseObserver.onNext((Object)message);
            }
        }

        public GrpcNotificationListener(@NonNull StreamObserver<NotificationMessage> responseObserver) {
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver is marked non-null but is null");
            }
            this.responseObserver = responseObserver;
        }

        @NonNull
        public StreamObserver<NotificationMessage> getResponseObserver() {
            return this.responseObserver;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GrpcNotificationListener)) {
                return false;
            }
            GrpcNotificationListener other = (GrpcNotificationListener)o;
            StreamObserver<NotificationMessage> this$responseObserver = this.getResponseObserver();
            StreamObserver<NotificationMessage> other$responseObserver = other.getResponseObserver();
            return !(this$responseObserver == null ? other$responseObserver != null : !this$responseObserver.equals(other$responseObserver));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StreamObserver<NotificationMessage> $responseObserver = this.getResponseObserver();
            result = result * 59 + ($responseObserver == null ? 43 : $responseObserver.hashCode());
            return result;
        }

        public String toString() {
            return "GrpcNotificationsService.GrpcNotificationListener(responseObserver=" + String.valueOf(this.getResponseObserver()) + ")";
        }
    }
}

