/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;

@Singleton
class GrpcExceptionHandler {
    private final Predicate<Throwable> isExpectedException = t -> t instanceof IllegalStateException || t instanceof IllegalArgumentException;
    private final Function<String, String> cliStyleErrorMessage = e -> {
        String[] line = e.split("\\r?\\n");
        int lastLine = line.length;
        return line[lastLine - 1].toLowerCase();
    };

    @Inject
    public GrpcExceptionHandler() {
    }

    public synchronized void handleException(Logger log, Throwable t, StreamObserver<?> responseObserver) {
        log.error("", t);
        StatusRuntimeException grpcStatusRuntimeException = this.wrapException(t);
        responseObserver.onError((Throwable)grpcStatusRuntimeException);
        throw grpcStatusRuntimeException;
    }

    public synchronized void handleExceptionAsWarning(Logger log, String calledMethod, Throwable t, StreamObserver<?> responseObserver) {
        log.warn(calledMethod + " -> " + t.getMessage());
        StatusRuntimeException grpcStatusRuntimeException = this.wrapException(t);
        responseObserver.onError((Throwable)grpcStatusRuntimeException);
        throw grpcStatusRuntimeException;
    }

    public void handleErrorMessage(Logger log, String errorMessage, StreamObserver<?> responseObserver) {
        log.error(errorMessage);
        StatusRuntimeException grpcStatusRuntimeException = new StatusRuntimeException(Status.UNKNOWN.withDescription(this.cliStyleErrorMessage.apply(errorMessage)));
        responseObserver.onError((Throwable)grpcStatusRuntimeException);
        throw grpcStatusRuntimeException;
    }

    private StatusRuntimeException wrapException(Throwable t) {
        if (this.isExpectedException.test(t)) {
            if (t.getCause() != null) {
                return new StatusRuntimeException(this.mapGrpcErrorStatus(t.getCause(), t.getCause().getMessage()));
            }
            return new StatusRuntimeException(this.mapGrpcErrorStatus(t, t.getMessage()));
        }
        return new StatusRuntimeException(this.mapGrpcErrorStatus(t, "unexpected error on server"));
    }

    private Status mapGrpcErrorStatus(Throwable t, String description) {
        switch (t.getClass().getSimpleName()) {
            case "IllegalArgumentException": {
                return Status.INVALID_ARGUMENT.withDescription(description);
            }
        }
        return Status.UNKNOWN.withDescription(description);
    }
}

