/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import haveno.common.handlers.ErrorMessageHandler;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.proto.grpc.AvailabilityResultWithDescription;
import haveno.proto.grpc.TakeOfferReply;
import haveno.proto.grpc.TradesGrpc;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import org.slf4j.Logger;
import protobuf.AvailabilityResult;

public class GrpcErrorMessageHandler
implements ErrorMessageHandler {
    private boolean isErrorHandled = false;
    private final String fullMethodName;
    private final StreamObserver<?> responseObserver;
    private final GrpcExceptionHandler exceptionHandler;
    private final Logger log;

    public GrpcErrorMessageHandler(String fullMethodName, StreamObserver<?> responseObserver, GrpcExceptionHandler exceptionHandler, Logger log) {
        this.fullMethodName = fullMethodName;
        this.exceptionHandler = exceptionHandler;
        this.responseObserver = responseObserver;
        this.log = log;
    }

    public synchronized void handleErrorMessage(String errorMessage) {
        if (!this.isErrorHandled) {
            this.isErrorHandled = true;
            this.log.error(errorMessage);
            if (this.takeOfferWasCalled()) {
                this.handleTakeOfferError(errorMessage);
            } else {
                this.exceptionHandler.handleErrorMessage(this.log, errorMessage, this.responseObserver);
            }
        }
    }

    private void handleTakeOfferError(String errorMessage) {
        try {
            AvailabilityResultWithDescription failureReason = this.getAvailabilityResultWithDescription(errorMessage);
            TakeOfferReply reply = TakeOfferReply.newBuilder().setFailureReason(failureReason).build();
            StreamObserver<?> takeOfferResponseObserver = this.responseObserver;
            takeOfferResponseObserver.onNext((Object)reply);
            takeOfferResponseObserver.onCompleted();
        }
        catch (IllegalArgumentException ex) {
            this.exceptionHandler.handleErrorMessage(this.log, errorMessage, this.responseObserver);
        }
    }

    private AvailabilityResultWithDescription getAvailabilityResultWithDescription(String errorMessage) {
        AvailabilityResult proto = this.getAvailabilityResult(errorMessage);
        String description = this.getAvailabilityResultDescription(proto);
        return AvailabilityResultWithDescription.newBuilder().setAvailabilityResult(proto).setDescription(description).build();
    }

    private AvailabilityResult getAvailabilityResult(String errorMessage) {
        return Arrays.stream(AvailabilityResult.values()).filter(e -> errorMessage.toUpperCase().contains(e.name())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find an AvailabilityResult in error message:%n%s", errorMessage)));
    }

    private String getAvailabilityResultDescription(AvailabilityResult proto) {
        return haveno.core.offer.AvailabilityResult.fromProto((AvailabilityResult)proto).description();
    }

    private boolean takeOfferWasCalled() {
        return this.fullMethodName.equals(TradesGrpc.getTakeOfferMethod().getFullMethodName());
    }

    public boolean isErrorHandled() {
        return this.isErrorHandled;
    }
}

