/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import haveno.common.config.Config;
import haveno.common.proto.ProtoUtil;
import haveno.core.api.CoreApi;
import haveno.core.support.dispute.Attachment;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeResult;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.daemon.grpc.interceptor.CallRateMeteringInterceptor;
import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import haveno.daemon.grpc.interceptor.GrpcServiceRateMeteringConfig;
import haveno.proto.grpc.DisputesGrpc;
import haveno.proto.grpc.GetDisputeReply;
import haveno.proto.grpc.GetDisputeRequest;
import haveno.proto.grpc.GetDisputesReply;
import haveno.proto.grpc.GetDisputesRequest;
import haveno.proto.grpc.OpenDisputeReply;
import haveno.proto.grpc.OpenDisputeRequest;
import haveno.proto.grpc.ResolveDisputeReply;
import haveno.proto.grpc.ResolveDisputeRequest;
import haveno.proto.grpc.SendDisputeChatMessageReply;
import haveno.proto.grpc.SendDisputeChatMessageRequest;
import io.grpc.ServerInterceptor;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcDisputesService
extends DisputesGrpc.DisputesImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcDisputesService.class);
    private final CoreApi coreApi;
    private final GrpcExceptionHandler exceptionHandler;

    @Inject
    public GrpcDisputesService(CoreApi coreApi, GrpcExceptionHandler exceptionHandler) {
        this.coreApi = coreApi;
        this.exceptionHandler = exceptionHandler;
    }

    public void openDispute(OpenDisputeRequest req, StreamObserver<OpenDisputeReply> responseObserver) {
        try {
            this.coreApi.openDispute(req.getTradeId(), () -> {
                OpenDisputeReply reply = OpenDisputeReply.newBuilder().build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
            }, (errorMessage, throwable) -> {
                log.info("Error in openDispute" + errorMessage);
                this.exceptionHandler.handleErrorMessage(log, errorMessage, responseObserver);
            });
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void getDispute(GetDisputeRequest req, StreamObserver<GetDisputeReply> responseObserver) {
        try {
            Dispute dispute = this.coreApi.getDispute(req.getTradeId());
            GetDisputeReply reply = GetDisputeReply.newBuilder().setDispute(dispute.toProtoMessage()).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleExceptionAsWarning(log, ((Object)((Object)this)).getClass().getName() + ".getDispute", cause, responseObserver);
        }
    }

    public void getDisputes(GetDisputesRequest req, StreamObserver<GetDisputesReply> responseObserver) {
        try {
            List disputes = this.coreApi.getDisputes();
            List disputesProtobuf = disputes.stream().map(d -> d.toProtoMessage()).collect(Collectors.toList());
            GetDisputesReply reply = GetDisputesReply.newBuilder().addAllDisputes(disputesProtobuf).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    public void resolveDispute(ResolveDisputeRequest req, StreamObserver<ResolveDisputeReply> responseObserver) {
        try {
            DisputeResult.Winner winner = (DisputeResult.Winner)ProtoUtil.enumFromProto(DisputeResult.Winner.class, (String)req.getWinner().name());
            DisputeResult.Reason reason = (DisputeResult.Reason)ProtoUtil.enumFromProto(DisputeResult.Reason.class, (String)req.getReason().name());
            this.coreApi.resolveDispute(req.getTradeId(), winner, reason, req.getSummaryNotes(), req.getCustomPayoutAmount());
            ResolveDisputeReply reply = ResolveDisputeReply.newBuilder().build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            cause.printStackTrace();
            this.exceptionHandler.handleExceptionAsWarning(log, ((Object)((Object)this)).getClass().getName() + ".resolveDispute", cause, responseObserver);
        }
    }

    public void sendDisputeChatMessage(SendDisputeChatMessageRequest req, StreamObserver<SendDisputeChatMessageReply> responseObserver) {
        try {
            List attachmentsProto = req.getAttachmentsList();
            List attachments = attachmentsProto.stream().map(a -> Attachment.fromProto((protobuf.Attachment)a)).collect(Collectors.toList());
            this.coreApi.sendDisputeChatMessage(req.getDisputeId(), req.getMessage(), new ArrayList(attachments));
            SendDisputeChatMessageReply reply = SendDisputeChatMessageReply.newBuilder().build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    /*
     * Exception decompiling
     */
    final ServerInterceptor[] interceptors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final Optional<ServerInterceptor> rateMeteringInterceptor() {
        return GrpcServiceRateMeteringConfig.getCustomRateMeteringInterceptor(this.coreApi.getConfig().appDataDir, ((Object)((Object)this)).getClass()).or(() -> Optional.of(CallRateMeteringInterceptor.valueOf((Map<String, GrpcCallRateMeter>)new HashMap<String, GrpcCallRateMeter>(){
            {
                this.put(DisputesGrpc.getGetDisputeMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 20 : 1, TimeUnit.SECONDS));
                this.put(DisputesGrpc.getGetDisputesMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 10 : 1, TimeUnit.SECONDS));
                this.put(DisputesGrpc.getResolveDisputeMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 40 : 1, TimeUnit.SECONDS));
                this.put(DisputesGrpc.getOpenDisputeMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 20 : 1, TimeUnit.SECONDS));
                this.put(DisputesGrpc.getSendDisputeChatMessageMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 40 : 2, TimeUnit.SECONDS));
            }
        })));
    }

    private static /* synthetic */ ServerInterceptor[] lambda$interceptors$5() {
        return new ServerInterceptor[0];
    }
}

