/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.app;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import haveno.common.UserThread;
import haveno.common.app.AppModule;
import haveno.common.crypto.IncorrectPasswordException;
import haveno.common.handlers.ResultHandler;
import haveno.common.persistence.PersistenceManager;
import haveno.common.setup.GracefulShutDownHandler;
import haveno.core.api.AccountServiceListener;
import haveno.core.app.ConsoleInput;
import haveno.core.app.CoreModule;
import haveno.core.app.HavenoHeadlessAppMain;
import haveno.daemon.app.HavenoDaemon;
import haveno.daemon.grpc.GrpcServer;
import java.io.Console;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HavenoDaemonMain
extends HavenoHeadlessAppMain {
    private static final Logger log = LoggerFactory.getLogger(HavenoDaemonMain.class);
    private GrpcServer grpcServer;

    public static void main(String[] args) {
        boolean keepRunning = true;
        while (keepRunning) {
            keepRunning = false;
            HavenoDaemonMain daemon = new HavenoDaemonMain();
            int ret = daemon.execute(args);
            if (ret == 0) {
                UserThread.execute(() -> daemon.gracefulShutDown(() -> {}));
                continue;
            }
            if (ret != 2) continue;
            AtomicBoolean shuttingDown = new AtomicBoolean(true);
            UserThread.execute(() -> daemon.gracefulShutDown(() -> shuttingDown.set(false), false));
            keepRunning = true;
            try {
                while (shuttingDown.get()) {
                    Thread.sleep(1000L);
                }
                PersistenceManager.reset();
            }
            catch (InterruptedException e) {
                System.out.println("interrupted!");
            }
        }
    }

    protected void configUserThread() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(((Object)((Object)this)).getClass().getSimpleName()).setDaemon(true).build();
        UserThread.setExecutor((Executor)Executors.newSingleThreadExecutor(threadFactory));
    }

    protected void launchApplication() {
        this.headlessApp = new HavenoDaemon();
        UserThread.execute(this::onApplicationLaunched);
    }

    protected void onApplicationLaunched() {
        super.onApplicationLaunched();
        this.headlessApp.setGracefulShutDownHandler((GracefulShutDownHandler)this);
    }

    protected AppModule getModule() {
        return new CoreModule(this.config);
    }

    protected void applyInjector() {
        super.applyInjector();
        this.headlessApp.setInjector(this.injector);
    }

    protected void startApplication() {
        this.headlessApp.startApplication();
        this.onApplicationStarted();
    }

    protected void onApplicationStarted() {
        super.onApplicationStarted();
    }

    public void gracefulShutDown(ResultHandler resultHandler, boolean exit) {
        super.gracefulShutDown(resultHandler, exit);
        if (this.grpcServer != null) {
            this.grpcServer.shutdown();
        }
    }

    protected CompletableFuture<Boolean> loginAccount() {
        CompletableFuture opened = super.loginAccount();
        this.grpcServer = (GrpcServer)this.injector.getInstance(GrpcServer.class);
        CompletableFuture<Boolean> inputResult = new CompletableFuture<Boolean>();
        try {
            if (((Boolean)opened.get()).booleanValue()) {
                this.grpcServer.start();
                return opened;
            }
            final ConsoleInput reader = new ConsoleInput(Integer.MAX_VALUE, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            Thread t = new Thread(() -> this.interactiveLogin(reader));
            AccountServiceListener accountListener = new AccountServiceListener(this){

                public void onAccountCreated() {
                    this.onLogin();
                }

                public void onAccountOpened() {
                    this.onLogin();
                }

                private void onLogin() {
                    log.info("Logged in successfully");
                    reader.cancel();
                }
            };
            this.accountService.addListener(accountListener);
            this.grpcServer.start();
            try {
                if (!this.accountService.isAccountOpen()) {
                    log.info("Interactive login required");
                    t.start();
                    t.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.accountService.removeListener(accountListener);
            inputResult.complete(this.accountService.isAccountOpen());
        }
        catch (InterruptedException | ExecutionException e) {
            inputResult.completeExceptionally(e);
        }
        return inputResult;
    }

    protected boolean interactiveLogin(ConsoleInput reader) {
        Console console = System.console();
        if (console == null) {
            log.info("No console available, account must be opened through rpc");
            try {
                reader.readLine();
            }
            catch (InterruptedException | CancellationException ex) {
                log.info("Reader interrupted, continuing startup");
            }
            return false;
        }
        String openedOrCreated = "Account unlocked\n";
        boolean accountExists = this.accountService.accountExists();
        while (!this.accountService.isAccountOpen()) {
            try {
                String password;
                if (accountExists) {
                    try {
                        System.out.printf("Password:\n", new Object[0]);
                        password = reader.readLine();
                        this.accountService.openAccount(password);
                    }
                    catch (IncorrectPasswordException ipe) {
                        System.out.printf("Incorrect password\n", new Object[0]);
                    }
                    continue;
                }
                System.out.printf("Creating a new account\n", new Object[0]);
                System.out.printf("Password:\n", new Object[0]);
                password = reader.readLine();
                System.out.printf("Confirm:\n", new Object[0]);
                String passwordConfirm = reader.readLine();
                if (password.equals(passwordConfirm)) {
                    this.accountService.createAccount(password);
                    openedOrCreated = "Account created\n";
                    continue;
                }
                System.out.printf("Passwords did not match\n", new Object[0]);
            }
            catch (Exception ex) {
                log.debug(ex.getMessage());
                return false;
            }
        }
        System.out.printf(openedOrCreated, new Object[0]);
        return true;
    }
}

