/*
 * Decompiled with CFR 0.152.
 */
package haveno.statistics;

import com.google.inject.Injector;
import haveno.core.app.misc.AppSetup;
import haveno.core.app.misc.AppSetupWithP2P;
import haveno.core.offer.OfferBookService;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statistics {
    private static final Logger log = LoggerFactory.getLogger(Statistics.class);
    private Injector injector;
    private OfferBookService offerBookService;
    private PriceFeedService priceFeedService;
    private TradeStatisticsManager tradeStatisticsManager;
    private P2PService p2pService;
    private AppSetup appSetup;

    public void startApplication() {
        this.p2pService = (P2PService)this.injector.getInstance(P2PService.class);
        this.offerBookService = (OfferBookService)this.injector.getInstance(OfferBookService.class);
        this.priceFeedService = (PriceFeedService)this.injector.getInstance(PriceFeedService.class);
        this.tradeStatisticsManager = (TradeStatisticsManager)this.injector.getInstance(TradeStatisticsManager.class);
        this.priceFeedService.setCurrencyCode("USD");
        this.p2pService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

            public void onDataReceived() {
                log.info("onBootstrapComplete: we start requestPriceFeed");
                Statistics.this.priceFeedService.startRequestingPrices(price -> log.info("requestPriceFeed. price=" + price), (errorMessage, throwable) -> log.warn("Exception at requestPriceFeed: " + throwable.getMessage()));
                Statistics.this.tradeStatisticsManager.onAllServicesInitialized();
            }
        });
        this.appSetup = (AppSetup)this.injector.getInstance(AppSetupWithP2P.class);
        this.appSetup.start();
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }
}

