/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest.linux;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ThreadedStreamHandler
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ThreadedStreamHandler.class);
    final InputStream inputStream;
    final StringBuilder outputBuffer = new StringBuilder();

    ThreadedStreamHandler(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void run() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                this.outputBuffer.append(line).append("\n");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void doSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public StringBuilder getOutputBuffer() {
        return this.outputBuffer;
    }
}

