/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest.linux;

import haveno.apitest.linux.ThreadedStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SystemCommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(SystemCommandExecutor.class);
    private final List<String> cmdOptions;
    private ThreadedStreamHandler inputStreamHandler;
    private ThreadedStreamHandler errorStreamHandler;

    public SystemCommandExecutor(List<String> cmdOptions) {
        if (cmdOptions.isEmpty()) {
            throw new IllegalStateException("No command params specified.");
        }
        if (cmdOptions.contains("sudo")) {
            throw new IllegalStateException("'sudo' commands are prohibited.");
        }
        log.trace("System cmd options {}", cmdOptions);
        this.cmdOptions = cmdOptions;
    }

    public int exec() throws IOException, InterruptedException {
        return this.exec(true);
    }

    public int exec(boolean waitOnErrStream) throws IOException, InterruptedException {
        Process process = new ProcessBuilder(this.cmdOptions).start();
        InputStream inputStream = process.getInputStream();
        InputStream errorStream = process.getErrorStream();
        this.inputStreamHandler = new ThreadedStreamHandler(inputStream);
        this.errorStreamHandler = new ThreadedStreamHandler(errorStream);
        this.inputStreamHandler.start();
        this.errorStreamHandler.start();
        int exitStatus = process.waitFor();
        this.inputStreamHandler.interrupt();
        this.errorStreamHandler.interrupt();
        this.inputStreamHandler.join();
        if (waitOnErrStream) {
            this.errorStreamHandler.join();
        }
        return exitStatus;
    }

    public StringBuilder getStandardErrorFromCommand() {
        return this.errorStreamHandler.getOutputBuffer();
    }

    public StringBuilder getStandardOutputFromCommand() {
        return this.inputStreamHandler.getOutputBuffer();
    }
}

