/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest.linux;

import haveno.apitest.config.ApiTestConfig;
import haveno.apitest.config.HavenoAppConfig;
import haveno.apitest.linux.AbstractLinuxProcess;
import haveno.apitest.linux.BashCommand;
import haveno.apitest.linux.LinuxProcess;
import haveno.daemon.app.HavenoDaemonMain;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HavenoProcess
extends AbstractLinuxProcess
implements LinuxProcess {
    private static final Logger log = LoggerFactory.getLogger(HavenoProcess.class);
    private final HavenoAppConfig havenoAppConfig;
    private final String baseCurrencyNetwork;
    private final String genesisTxId;
    private final int genesisBlockHeight;
    private final String seedNodes;
    private final boolean useLocalhostForP2P;
    public final boolean useDevPrivilegeKeys;
    private final String findHavenoPidScript;
    private final String debugOpts;

    public HavenoProcess(HavenoAppConfig havenoAppConfig, ApiTestConfig config) {
        super(havenoAppConfig.appName, config);
        this.havenoAppConfig = havenoAppConfig;
        this.baseCurrencyNetwork = "XMR_STAGENET";
        this.genesisTxId = "30af0050040befd8af25068cc697e418e09c2d8ebd8d411d2240591b9ec203cf";
        this.genesisBlockHeight = 111;
        this.seedNodes = "localhost:2002";
        this.useLocalhostForP2P = true;
        this.useDevPrivilegeKeys = true;
        this.findHavenoPidScript = (config.isRunningTest ? "." : "./apitest") + "/scripts/get-haveno-pid.sh";
        this.debugOpts = config.enableHavenoDebugging ? " -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + havenoAppConfig.remoteDebugPort : "";
    }

    @Override
    public void start() {
        try {
            if (this.config.runSubprojectJars) {
                this.runJar();
            } else {
                this.runStartupScript();
            }
        }
        catch (Throwable t) {
            this.startupExceptions.add(t);
        }
    }

    @Override
    public long getPid() {
        return this.pid;
    }

    @Override
    public void shutdown() {
        try {
            log.info("Shutting down {} ...", (Object)this.havenoAppConfig.appName);
            if (!BashCommand.isAlive(this.pid)) {
                this.shutdownExceptions.add(new IllegalStateException(String.format("%s already shut down", this.havenoAppConfig.appName)));
                return;
            }
            String killCmd = "kill -15 " + this.pid;
            if (new BashCommand(killCmd).run().getExitStatus() != 0) {
                this.shutdownExceptions.add(new IllegalStateException(String.format("Could not shut down %s", this.havenoAppConfig.appName)));
                return;
            }
            for (int i = 0; i < 5; ++i) {
                if (!BashCommand.isAlive(this.pid)) {
                    log.info("{} stopped", (Object)this.havenoAppConfig.appName);
                    break;
                }
                TimeUnit.MILLISECONDS.sleep(2500L);
            }
            if (BashCommand.isAlive(this.pid)) {
                this.shutdownExceptions.add(new IllegalStateException(String.format("%s shutdown did not work", this.havenoAppConfig.appName)));
            }
        }
        catch (Exception e) {
            this.shutdownExceptions.add(new IllegalStateException(String.format("Error shutting down %s", this.havenoAppConfig.appName), e));
        }
    }

    public void verifyAppNotRunning() throws IOException, InterruptedException {
        long pid = this.findHavenoAppPid();
        if (pid >= 0L) {
            throw new IllegalStateException(String.format("%s %s already running with pid %d", this.havenoAppConfig.mainClassName, this.havenoAppConfig.appName, pid));
        }
    }

    public void verifyAppDataDirInstalled() {
        switch (this.havenoAppConfig) {
            case alicedaemon: 
            case alicedesktop: 
            case bobdaemon: 
            case bobdesktop: {
                File havenoDataDir = new File(this.config.rootAppDataDir, this.havenoAppConfig.appName);
                if (havenoDataDir.exists()) break;
                throw new IllegalStateException(String.format("Application dataDir %s/%s not found", this.config.rootAppDataDir, this.havenoAppConfig.appName));
            }
        }
    }

    private void runJar() throws IOException, InterruptedException {
        String java = this.getJavaExecutable().getAbsolutePath();
        String classpath = System.getProperty("java.class.path");
        String havenoCmd = this.getJavaOptsSpec() + " " + java + " -cp " + classpath + " " + this.havenoAppConfig.mainClassName + " " + String.join((CharSequence)" ", this.getOptsList()) + " &";
        this.runBashCommand(havenoCmd);
    }

    private void runStartupScript() throws IOException, InterruptedException {
        String startupScriptPath = this.config.rootProjectDir + "/" + this.havenoAppConfig.startupScript;
        String havenoCmd = this.getJavaOptsSpec() + " " + startupScriptPath + " " + String.join((CharSequence)" ", this.getOptsList()) + " &";
        this.runBashCommand(havenoCmd);
    }

    private void runBashCommand(String havenoCmd) throws IOException, InterruptedException {
        String cmdDescription = this.config.runSubprojectJars ? "java -> " + this.havenoAppConfig.mainClassName + " -> " + this.havenoAppConfig.appName : this.havenoAppConfig.startupScript + " -> " + this.havenoAppConfig.appName;
        BashCommand bashCommand = new BashCommand(havenoCmd);
        log.info("Starting {} ...\n$ {}", (Object)cmdDescription, (Object)bashCommand.getCommand());
        bashCommand.runInBackground();
        if (bashCommand.getExitStatus() != 0) {
            throw new IllegalStateException(String.format("Error starting HavenoApp%n%s%nError: %s", this.havenoAppConfig.appName, bashCommand.getError()));
        }
        for (int i = 0; i < 4; ++i) {
            this.pid = this.findHavenoAppPid();
            if (this.pid != -1L) break;
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        if (!BashCommand.isAlive(this.pid)) {
            throw new IllegalStateException(String.format("Error finding pid for %s", this.name));
        }
        log.info("{} running with pid {}", (Object)cmdDescription, (Object)this.pid);
        log.info("Log {}", (Object)(String.valueOf(this.config.rootAppDataDir) + "/" + this.havenoAppConfig.appName + "/haveno.log"));
    }

    private long findHavenoAppPid() throws IOException, InterruptedException {
        String findPidCmd = this.findHavenoPidScript + " " + this.havenoAppConfig.mainClassName + " " + this.havenoAppConfig.appName;
        String psCmdOutput = new BashCommand(findPidCmd).run().getOutput();
        return psCmdOutput == null || psCmdOutput.isEmpty() ? -1L : Long.parseLong(psCmdOutput);
    }

    private String getJavaOptsSpec() {
        return "export JAVA_OPTS=\"" + this.havenoAppConfig.javaOpts + this.debugOpts + "\"; ";
    }

    private List<String> getOptsList() {
        return new ArrayList<String>(){
            {
                this.add("--appName=" + HavenoProcess.this.havenoAppConfig.appName);
                this.add("--appDataDir=" + HavenoProcess.this.config.rootAppDataDir.getAbsolutePath() + "/" + HavenoProcess.this.havenoAppConfig.appName);
                this.add("--nodePort=" + HavenoProcess.this.havenoAppConfig.nodePort);
                this.add("--rpcBlockNotificationPort=" + HavenoProcess.this.havenoAppConfig.rpcBlockNotificationPort);
                this.add("--rpcUser=" + HavenoProcess.this.config.bitcoinRpcUser);
                this.add("--rpcPassword=" + HavenoProcess.this.config.bitcoinRpcPassword);
                this.add("--rpcPort=" + HavenoProcess.this.config.bitcoinRpcPort);
                this.add("--seedNodes=" + HavenoProcess.this.seedNodes);
                this.add("--baseCurrencyNetwork=" + HavenoProcess.this.baseCurrencyNetwork);
                this.add("--useDevPrivilegeKeys=" + HavenoProcess.this.useDevPrivilegeKeys);
                this.add("--useLocalhostForP2P=" + HavenoProcess.this.useLocalhostForP2P);
                switch (HavenoProcess.this.havenoAppConfig) {
                    case seednode: {
                        break;
                    }
                    case alicedaemon: 
                    case alicedesktop: 
                    case bobdaemon: 
                    case bobdesktop: 
                    case arbdaemon: 
                    case arbdesktop: {
                        this.add("--genesisBlockHeight=" + HavenoProcess.this.genesisBlockHeight);
                        this.add("--genesisTxId=" + HavenoProcess.this.genesisTxId);
                        if (!HavenoProcess.this.havenoAppConfig.mainClassName.equals(HavenoDaemonMain.class.getName())) break;
                        this.add("--apiPassword=" + HavenoProcess.this.config.apiPassword);
                        this.add("--apiPort=" + HavenoProcess.this.havenoAppConfig.apiPort);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown HavenoAppConfig " + HavenoProcess.this.havenoAppConfig.name());
                    }
                }
            }
        };
    }

    private File getJavaExecutable() {
        File javaHome = Paths.get(System.getProperty("java.home"), new String[0]).toFile();
        if (!javaHome.exists()) {
            throw new IllegalStateException(String.format("$JAVA_HOME not found, cannot run %s", this.havenoAppConfig.mainClassName));
        }
        File javaExecutable = Paths.get(javaHome.getAbsolutePath(), "bin", "java").toFile();
        if (javaExecutable.exists() || javaExecutable.canExecute()) {
            return javaExecutable;
        }
        throw new IllegalStateException("$JAVA_HOME/bin/java not found or executable");
    }
}

