/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest.linux;

import haveno.apitest.config.ApiTestConfig;
import haveno.apitest.linux.AbstractLinuxProcess;
import haveno.apitest.linux.BashCommand;
import haveno.apitest.linux.LinuxProcess;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinDaemon
extends AbstractLinuxProcess
implements LinuxProcess {
    private static final Logger log = LoggerFactory.getLogger(BitcoinDaemon.class);

    public BitcoinDaemon(ApiTestConfig config) {
        super("bitcoind", config);
    }

    @Override
    public void start() throws InterruptedException, IOException {
        String berkeleyDbLibPathExport = this.config.berkeleyDbLibPath.equals("") ? "" : "export LD_LIBRARY_PATH=" + this.config.berkeleyDbLibPath + "; ";
        String bitcoindCmd = berkeleyDbLibPathExport + this.config.bitcoinPath + "/bitcoind -datadir=" + this.config.bitcoinDatadir + " -daemon -regtest=1 -server=1 -txindex=1 -peerbloomfilters=1 -debug=net -fallbackfee=0.0002 -rpcport=" + this.config.bitcoinRpcPort + " -rpcuser=" + this.config.bitcoinRpcUser + " -rpcpassword=" + this.config.bitcoinRpcPassword + " -blocknotify=\"" + this.config.bitcoinDatadir + "/blocknotify %s\"";
        BashCommand cmd = new BashCommand(bitcoindCmd).run();
        log.info("Starting ...\n$ {}", (Object)cmd.getCommand());
        if (cmd.getExitStatus() != 0) {
            this.startupExceptions.add(new IllegalStateException(String.format("Error starting bitcoind%nstatus: %d%nerror msg: %s", cmd.getExitStatus(), cmd.getError())));
            return;
        }
        this.pid = BashCommand.getPid("bitcoind");
        if (!BashCommand.isAlive(this.pid)) {
            throw new IllegalStateException("Error starting regtest bitcoind daemon:\n" + cmd.getCommand());
        }
        log.info("Running with pid {}", (Object)this.pid);
        log.info("Log {}", (Object)(this.config.bitcoinDatadir + "/regtest/debug.log"));
    }

    @Override
    public long getPid() {
        return this.pid;
    }

    @Override
    public void shutdown() {
        try {
            log.info("Shutting down bitcoind daemon...");
            if (!BashCommand.isAlive(this.pid)) {
                this.shutdownExceptions.add(new IllegalStateException("Bitcoind already shut down."));
                return;
            }
            if (new BashCommand("kill -15 " + this.pid).run().getExitStatus() != 0) {
                this.shutdownExceptions.add(new IllegalStateException("Could not shut down bitcoind; probably already stopped."));
                return;
            }
            TimeUnit.MILLISECONDS.sleep(2500L);
            if (BashCommand.isAlive(this.pid)) {
                this.shutdownExceptions.add(new IllegalStateException(String.format("Could not kill bitcoind process with pid %d.", this.pid)));
                return;
            }
            log.info("Stopped");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException e) {
            this.shutdownExceptions.add(new IllegalStateException("Error shutting down bitcoind.", e));
        }
    }
}

