/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest.linux;

import haveno.apitest.config.ApiTestConfig;
import haveno.apitest.linux.AbstractLinuxProcess;
import haveno.apitest.linux.BashCommand;
import haveno.apitest.linux.LinuxProcess;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinCli
extends AbstractLinuxProcess
implements LinuxProcess {
    private static final Logger log = LoggerFactory.getLogger(BitcoinCli.class);
    private final String command;
    private String commandWithOptions;
    private String output;
    private boolean error;
    private String errorMessage;

    public BitcoinCli(ApiTestConfig config, String command) {
        super("bitcoin-cli", config);
        this.command = command;
        this.error = false;
        this.errorMessage = null;
    }

    public BitcoinCli run() throws IOException, InterruptedException {
        this.start();
        return this;
    }

    public String getCommandWithOptions() {
        return this.commandWithOptions;
    }

    public String getOutput() {
        if (this.isError()) {
            throw new IllegalStateException(this.output);
        }
        return this.output;
    }

    public String[] getOutputValueAsStringArray() {
        if (this.isError()) {
            throw new IllegalStateException(this.output);
        }
        if (!this.output.startsWith("[") && !this.output.endsWith("]")) {
            throw new IllegalStateException(this.output + "\nis not a json array");
        }
        String[] lines = this.output.split("\n");
        String[] array = new String[lines.length - 2];
        for (int i = 1; i < lines.length - 1; ++i) {
            array[i - 1] = lines[i].replaceAll("[^a-zA-Z0-9.]", "");
        }
        return array;
    }

    public String getOutputValueAsString(String key) {
        if (this.isError()) {
            throw new IllegalStateException(this.output);
        }
        int keyIdx = this.output.indexOf("\"" + key + "\":");
        int eolIdx = this.output.indexOf("\n", keyIdx);
        String valueLine = this.output.substring(keyIdx, eolIdx);
        String[] keyValue = valueLine.split(":");
        return keyValue[1].replaceAll("[^a-zA-Z0-9.]", "");
    }

    public boolean getOutputValueAsBoolean(String key) {
        String valueStr = this.getOutputValueAsString(key);
        return Boolean.parseBoolean(valueStr);
    }

    public int getOutputValueAsInt(String key) {
        String valueStr = this.getOutputValueAsString(key);
        return Integer.parseInt(valueStr);
    }

    public double getOutputValueAsDouble(String key) {
        String valueStr = this.getOutputValueAsString(key);
        return Double.parseDouble(valueStr);
    }

    public long getOutputValueAsLong(String key) {
        String valueStr = this.getOutputValueAsString(key);
        return Long.parseLong(valueStr);
    }

    public boolean isError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void start() throws InterruptedException, IOException {
        this.verifyBitcoinPathsExist(false);
        this.verifyBitcoindRunning();
        this.commandWithOptions = this.config.bitcoinPath + "/bitcoin-cli -regtest  -rpcport=" + this.config.bitcoinRpcPort + " -rpcuser=" + this.config.bitcoinRpcUser + " -rpcpassword=" + this.config.bitcoinRpcPassword + " " + this.command;
        BashCommand bashCommand = new BashCommand(this.commandWithOptions).run();
        boolean bl = this.error = bashCommand.getExitStatus() != 0;
        if (this.error) {
            this.errorMessage = bashCommand.getError();
            if (this.errorMessage == null || this.errorMessage.isEmpty()) {
                throw new IllegalStateException("bitcoin-cli returned an error without a message");
            }
        } else {
            this.output = bashCommand.getOutput();
        }
    }

    @Override
    public long getPid() {
        throw new UnsupportedOperationException("getPid not supported");
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException("shutdown not supported");
    }
}

