/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest.linux;

import haveno.apitest.config.ApiTestConfig;
import haveno.apitest.linux.SystemCommandExecutor;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BashCommand {
    private static final Logger log = LoggerFactory.getLogger(BashCommand.class);
    private int exitStatus = -1;
    @Nullable
    private String output;
    @Nullable
    private String error;
    private final String command;
    private final int numResponseLines;

    public BashCommand(String command) {
        this(command, 0);
    }

    public BashCommand(String command, int numResponseLines) {
        this.command = command;
        this.numResponseLines = numResponseLines;
    }

    public BashCommand run() throws IOException, InterruptedException {
        SystemCommandExecutor commandExecutor = new SystemCommandExecutor(this.tokenizeSystemCommand());
        this.exitStatus = commandExecutor.exec();
        this.processOutput(commandExecutor);
        return this;
    }

    public BashCommand runInBackground() throws IOException, InterruptedException {
        SystemCommandExecutor commandExecutor = new SystemCommandExecutor(this.tokenizeSystemCommand());
        this.exitStatus = commandExecutor.exec(false);
        this.processOutput(commandExecutor);
        return this;
    }

    private void processOutput(SystemCommandExecutor commandExecutor) {
        StringBuilder stderr = commandExecutor.getStandardErrorFromCommand();
        if (stderr.length() > 0) {
            this.error = stderr.toString();
        }
        if (this.exitStatus != 0) {
            return;
        }
        StringBuilder stdout = commandExecutor.getStandardOutputFromCommand();
        String[] rawLines = stdout.toString().split("\n");
        StringBuilder truncatedLines = new StringBuilder();
        int limit = this.numResponseLines > 0 ? Math.min(this.numResponseLines, rawLines.length) : rawLines.length;
        for (int i = 0; i < limit; ++i) {
            String line = rawLines[i].length() >= 220 ? rawLines[i].substring(0, 220) + " ..." : rawLines[i];
            truncatedLines.append(line).append(i < limit - 1 ? "\n" : "");
        }
        this.output = truncatedLines.toString();
    }

    public String getCommand() {
        return this.command;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    @Nullable
    public String getOutput() {
        return this.output;
    }

    public String getError() {
        return this.error;
    }

    private List<String> tokenizeSystemCommand() {
        return new ArrayList<String>(){
            {
                this.add(ApiTestConfig.BASH_PATH_VALUE);
                this.add("-c");
                this.add(BashCommand.this.command);
            }
        };
    }

    public static String printSystemLoadString(Exception tracingException) throws IOException, InterruptedException {
        StackTraceElement[] stackTraceElement = tracingException.getStackTrace();
        StringBuilder stackTraceBuilder = new StringBuilder(tracingException.getMessage()).append("\n");
        int traceLimit = Math.min(stackTraceElement.length, 4);
        for (int i = 0; i < traceLimit; ++i) {
            stackTraceBuilder.append(stackTraceElement[i]).append("\n");
        }
        stackTraceBuilder.append("...");
        log.info(stackTraceBuilder.toString());
        BashCommand cmd = new BashCommand("ps -aux --sort -rss --headers", 2).run();
        return cmd.getOutput() + "\nSystem load: Memory (MB): " + BashCommand.getUsedMemoryInMB() + " / No. of threads: " + Thread.activeCount() + " JVM uptime (ms): " + ManagementFactory.getRuntimeMXBean().getUptime();
    }

    public static long getUsedMemoryInMB() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory() / 1024L / 1024L;
        long total = runtime.totalMemory() / 1024L / 1024L;
        return total - free;
    }

    public static long getPid(String processName) throws IOException, InterruptedException {
        String psCmd = "ps aux | pgrep " + processName + " | grep -v grep";
        String psCmdOutput = new BashCommand(psCmd).run().getOutput();
        if (psCmdOutput == null || psCmdOutput.isEmpty()) {
            return -1L;
        }
        return Long.parseLong(psCmdOutput);
    }

    public static BashCommand grep(String processName) throws IOException, InterruptedException {
        String c = "ps -aux | grep " + processName + " | grep -v grep";
        return new BashCommand(c).run();
    }

    public static boolean isAlive(long pid) throws IOException, InterruptedException {
        String isAliveScript = "if ps -p " + pid + " > /dev/null; then echo true; else echo false; fi";
        return new BashCommand(isAliveScript).run().getOutput().equals("true");
    }
}

