/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest.linux;

import haveno.apitest.config.ApiTestConfig;
import haveno.apitest.linux.BashCommand;
import haveno.apitest.linux.LinuxProcess;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLinuxProcess
implements LinuxProcess {
    private static final Logger log = LoggerFactory.getLogger(AbstractLinuxProcess.class);
    protected final String name;
    protected final ApiTestConfig config;
    protected long pid;
    protected final List<Throwable> startupExceptions;
    protected final List<Throwable> shutdownExceptions;

    public AbstractLinuxProcess(String name, ApiTestConfig config) {
        this.name = name;
        this.config = config;
        this.startupExceptions = new ArrayList<Throwable>();
        this.shutdownExceptions = new ArrayList<Throwable>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasStartupExceptions() {
        return !this.startupExceptions.isEmpty();
    }

    @Override
    public boolean hasShutdownExceptions() {
        return !this.shutdownExceptions.isEmpty();
    }

    @Override
    public void logExceptions(List<Throwable> exceptions, Logger log) {
        for (Throwable t : exceptions) {
            log.error("", t);
        }
    }

    @Override
    public List<Throwable> getStartupExceptions() {
        return this.startupExceptions;
    }

    @Override
    public List<Throwable> getShutdownExceptions() {
        return this.shutdownExceptions;
    }

    public void verifyBitcoinPathsExist() {
        this.verifyBitcoinPathsExist(false);
    }

    public void verifyBitcoinPathsExist(boolean verbose) {
        File berkeleyDbLibPath;
        if (verbose) {
            log.info(String.format("Checking bitcoind env...%n\t%-20s%s%n\t%-20s%s%n\t%-20s%s%n\t%-20s%s", "berkeleyDbLibPath", this.config.berkeleyDbLibPath, "bitcoinPath", this.config.bitcoinPath, "bitcoinDatadir", this.config.bitcoinDatadir, "blocknotify", this.config.bitcoinDatadir + "/blocknotify"));
        }
        if (!(this.config.berkeleyDbLibPath.equals("") || (berkeleyDbLibPath = new File(this.config.berkeleyDbLibPath)).exists() && berkeleyDbLibPath.canExecute())) {
            throw new IllegalStateException(String.valueOf(berkeleyDbLibPath) + " cannot be found or executed");
        }
        File bitcoindExecutable = Paths.get(this.config.bitcoinPath, "bitcoind").toFile();
        if (!bitcoindExecutable.exists() || !bitcoindExecutable.canExecute()) {
            throw new IllegalStateException(String.format("'%s' cannot be found or executed.%nA bitcoin-core v0.19 - v22 installation is required, and the 'bitcoinPath' must be configured in 'apitest.properties'", bitcoindExecutable.getAbsolutePath()));
        }
        File bitcoindDatadir = new File(this.config.bitcoinDatadir);
        if (!bitcoindDatadir.exists() || !bitcoindDatadir.canWrite()) {
            throw new IllegalStateException(String.valueOf(bitcoindDatadir) + " cannot be found or written to");
        }
        File blocknotify = new File(bitcoindDatadir, "blocknotify");
        if (!blocknotify.exists() || !blocknotify.canExecute()) {
            throw new IllegalStateException(blocknotify.getAbsolutePath() + " cannot be found or executed");
        }
    }

    public void verifyBitcoindRunning() throws IOException, InterruptedException {
        long bitcoindPid = BashCommand.getPid("bitcoind");
        if (bitcoindPid < 0L || !BashCommand.isAlive(bitcoindPid)) {
            throw new IllegalStateException("Bitcoind not running");
        }
    }
}

