/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest.config;

import haveno.daemon.grpc.GrpcVersionService;
import haveno.daemon.grpc.interceptor.GrpcServiceRateMeteringConfig;
import haveno.proto.grpc.DisputeAgentsGrpc;
import haveno.proto.grpc.GetVersionGrpc;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class ApiTestRateMeterInterceptorConfig {
    public static File getTestRateMeterInterceptorConfig() {
        String[] serviceClassNames;
        GrpcServiceRateMeteringConfig.Builder builder = new GrpcServiceRateMeteringConfig.Builder();
        builder.addCallRateMeter(GrpcVersionService.class.getSimpleName(), GetVersionGrpc.getGetVersionMethod().getFullMethodName(), 1, TimeUnit.SECONDS);
        builder.addCallRateMeter("GrpcDisputeAgentsService", DisputeAgentsGrpc.getRegisterDisputeAgentMethod().getFullMethodName(), 10, TimeUnit.SECONDS);
        for (String service : serviceClassNames = new String[]{"GrpcGetTradeStatisticsService", "GrpcHelpService", "GrpcOffersService", "GrpcPaymentAccountsService", "GrpcPriceService", "GrpcTradesService", "GrpcWalletsService"}) {
            builder.addCallRateMeter(service, "disabled", 1, TimeUnit.MILLISECONDS);
        }
        File file = builder.build();
        file.deleteOnExit();
        return file;
    }

    public static boolean hasCallRateMeteringConfigPathOpt(String[] args) {
        return Arrays.stream(args).anyMatch(a -> a.contains("--callRateMeteringConfigPath"));
    }

    public static String[] appendCallRateMeteringConfigPathOpt(String[] args, File rateMeterInterceptorConfig) {
        String[] rateMeteringConfigPathOpt = new String[]{"--callRateMeteringConfigPath=" + rateMeterInterceptorConfig.getAbsolutePath()};
        if (args.length == 0) {
            return rateMeteringConfigPathOpt;
        }
        String[] appendedOpts = new String[args.length + 1];
        System.arraycopy(args, 0, appendedOpts, 0, args.length);
        System.arraycopy(rateMeteringConfigPathOpt, 0, appendedOpts, args.length, rateMeteringConfigPathOpt.length);
        return appendedOpts;
    }
}

