/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest.config;

import haveno.common.config.CompositeOptionSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTestConfig {
    private static final Logger log = LoggerFactory.getLogger(ApiTestConfig.class);
    public static final String BTC = "BTC";
    public static final String EUR = "EUR";
    public static final String USD = "USD";
    public static final String XMR = "XMR";
    public static final String ARBITRATOR = "arbitrator";
    public static final String MEDIATOR = "mediator";
    public static final String REFUND_AGENT = "refundagent";
    static final String HELP = "help";
    static final String BASH_PATH = "bashPath";
    static final String BERKELEYDB_LIB_PATH = "berkeleyDbLibPath";
    static final String BITCOIN_PATH = "bitcoinPath";
    static final String BITCOIN_RPC_PORT = "bitcoinRpcPort";
    static final String BITCOIN_RPC_USER = "bitcoinRpcUser";
    static final String BITCOIN_RPC_PASSWORD = "bitcoinRpcPassword";
    static final String BITCOIN_REGTEST_HOST = "bitcoinRegtestHost";
    static final String CONFIG_FILE = "configFile";
    static final String ROOT_APP_DATA_DIR = "rootAppDataDir";
    static final String API_PASSWORD = "apiPassword";
    static final String RUN_SUBPROJECT_JARS = "runSubprojectJars";
    static final String HAVENO_APP_INIT_TIME = "havenoAppInitTime";
    static final String SKIP_TESTS = "skipTests";
    static final String SHUTDOWN_AFTER_TESTS = "shutdownAfterTests";
    static final String SUPPORTING_APPS = "supportingApps";
    static final String CALL_RATE_METERING_CONFIG_PATH = "callRateMeteringConfigPath";
    static final String ENABLE_HAVENO_DEBUGGING = "enableHavenoDebugging";
    static final String REGISTER_DISPUTE_AGENTS = "registerDisputeAgents";
    static final String DEFAULT_CONFIG_FILE_NAME = "apitest.properties";
    public static String BASH_PATH_VALUE;
    public final File defaultConfigFile;
    public final boolean helpRequested;
    public final File configFile;
    public final File rootAppDataDir;
    public final String bashPath;
    public final String berkeleyDbLibPath;
    public final String bitcoinPath;
    public final String bitcoinRegtestHost;
    public final int bitcoinRpcPort;
    public final String bitcoinRpcUser;
    public final String bitcoinRpcPassword;
    public final String apiPassword;
    public final boolean runSubprojectJars;
    public final long havenoAppInitTime;
    public final boolean skipTests;
    public final boolean shutdownAfterTests;
    public final List<String> supportingApps;
    public final String callRateMeteringConfigPath;
    public final boolean enableHavenoDebugging;
    public final boolean registerDisputeAgents;
    public final String bitcoinDatadir;
    public final String userDir;
    public final boolean isRunningTest;
    public final String rootProjectDir;
    public final String baseBuildResourcesDir;
    public final String baseSrcResourcesDir;
    private final OptionParser parser = new OptionParser();

    public ApiTestConfig(String ... args) {
        this.userDir = System.getProperty("user.dir");
        this.isRunningTest = Paths.get(this.userDir, new String[0]).getFileName().toString().equals("apitest");
        this.rootProjectDir = this.isRunningTest ? Paths.get(this.userDir, new String[0]).getParent().toFile().getAbsolutePath() : Paths.get(this.userDir, new String[0]).toFile().getAbsolutePath();
        this.baseBuildResourcesDir = Paths.get(this.rootProjectDir, "apitest", "build", "resources", "main").toFile().getAbsolutePath();
        this.baseSrcResourcesDir = Paths.get(this.rootProjectDir, "apitest", "src", "main", "resources").toFile().getAbsolutePath();
        this.defaultConfigFile = ApiTestConfig.absoluteConfigFile(this.baseBuildResourcesDir, DEFAULT_CONFIG_FILE_NAME);
        this.bitcoinDatadir = Paths.get(this.baseBuildResourcesDir, "Bitcoin-regtest").toFile().getAbsolutePath();
        AbstractOptionSpec helpOpt = this.parser.accepts(HELP, "Print this help text").forHelp();
        ArgumentAcceptingOptionSpec configFileOpt = this.parser.accepts(CONFIG_FILE, String.format("Specify configuration file. Relative paths will be prefixed by %s location.", this.userDir)).withRequiredArg().ofType(String.class).defaultsTo((Object)DEFAULT_CONFIG_FILE_NAME, (Object[])new String[0]);
        ArgumentAcceptingOptionSpec appDataDirOpt = this.parser.accepts(ROOT_APP_DATA_DIR, "Application data directory").withRequiredArg().ofType(File.class).defaultsTo((Object)new File(this.baseBuildResourcesDir), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec bashPathOpt = this.parser.accepts(BASH_PATH, "Bash path").withRequiredArg().ofType(String.class).defaultsTo((Object)(System.getenv("SHELL") == null || !System.getenv("SHELL").contains("bash") ? "/bin/bash" : System.getenv("SHELL")), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec berkeleyDbLibPathOpt = this.parser.accepts(BERKELEYDB_LIB_PATH, "Berkeley DB lib path").withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec bitcoinPathOpt = this.parser.accepts(BITCOIN_PATH, "Bitcoin path").withRequiredArg().ofType(String.class).defaultsTo((Object)"/usr/local/bin", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec bitcoinRegtestHostOpt = this.parser.accepts(BITCOIN_REGTEST_HOST, "Bitcoin Core regtest host").withRequiredArg().ofType(String.class).defaultsTo((Object)InetAddress.getLoopbackAddress().getHostAddress(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec bitcoinRpcPortOpt = this.parser.accepts(BITCOIN_RPC_PORT, "Bitcoin Core rpc port (non-default)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)19443, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec bitcoinRpcUserOpt = this.parser.accepts(BITCOIN_RPC_USER, "Bitcoin rpc user").withRequiredArg().ofType(String.class).defaultsTo((Object)"apitest", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec bitcoinRpcPasswordOpt = this.parser.accepts(BITCOIN_RPC_PASSWORD, "Bitcoin rpc password").withRequiredArg().ofType(String.class).defaultsTo((Object)"apitest", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec apiPasswordOpt = this.parser.accepts(API_PASSWORD, "gRPC API password").withRequiredArg().defaultsTo((Object)"xyz", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec runSubprojectJarsOpt = this.parser.accepts(RUN_SUBPROJECT_JARS, "Run subproject build jars instead of full build jars").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec havenoAppInitTimeOpt = this.parser.accepts(HAVENO_APP_INIT_TIME, "Amount of time (ms) to wait on a Haveno instance's initialization").withRequiredArg().ofType(Long.class).defaultsTo((Object)5000L, (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec skipTestsOpt = this.parser.accepts(SKIP_TESTS, "Start apps, but skip tests").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec shutdownAfterTestsOpt = this.parser.accepts(SHUTDOWN_AFTER_TESTS, "Terminate all processes after tests").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec supportingAppsOpt = this.parser.accepts(SUPPORTING_APPS, "Comma delimited list of supporting apps (bitcoind,seednode,arbdaemon,...").withRequiredArg().ofType(String.class).defaultsTo((Object)"bitcoind,seednode,arbdaemon,alicedaemon,bobdaemon", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec callRateMeteringConfigPathOpt = this.parser.accepts(CALL_RATE_METERING_CONFIG_PATH, "Install a ratemeters.json file to configure call rate metering interceptors").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec enableHavenoDebuggingOpt = this.parser.accepts(ENABLE_HAVENO_DEBUGGING, "Start Haveno apps with remote debug options").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec registerDisputeAgentsOpt = this.parser.accepts(REGISTER_DISPUTE_AGENTS, "Register dispute agents in arbitration daemon").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
        try {
            Optional<OptionSet> configFileOpts;
            CompositeOptionSet options = new CompositeOptionSet();
            OptionSet cliOpts = this.parser.parse(args);
            options.addOptionSet(cliOpts);
            File configFile = null;
            OptionSpec[] disallowedOpts = new OptionSpec[]{helpOpt, configFileOpt};
            boolean cliHasConfigFileOpt = cliOpts.has((OptionSpec)configFileOpt);
            boolean configFileHasBeenProcessed = false;
            if (cliHasConfigFileOpt && (configFile = new File((String)cliOpts.valueOf((OptionSpec)configFileOpt))).isAbsolute() && (configFileOpts = this.parseOptionsFrom(configFile, disallowedOpts)).isPresent()) {
                options.addOptionSet(configFileOpts.get());
                configFileHasBeenProcessed = true;
            }
            if (!configFileHasBeenProcessed) {
                configFile = cliHasConfigFileOpt && !configFile.isAbsolute() ? ApiTestConfig.absoluteConfigFile(this.userDir, configFile.getPath()) : this.defaultConfigFile;
                configFileOpts = this.parseOptionsFrom(configFile, disallowedOpts);
                configFileOpts.ifPresent(arg_0 -> ((CompositeOptionSet)options).addOptionSet(arg_0));
            }
            this.helpRequested = options.has((OptionSpec)helpOpt);
            this.configFile = configFile;
            this.rootAppDataDir = (File)options.valueOf((OptionSpec)appDataDirOpt);
            this.bashPath = (String)options.valueOf((OptionSpec)bashPathOpt);
            this.berkeleyDbLibPath = (String)options.valueOf((OptionSpec)berkeleyDbLibPathOpt);
            this.bitcoinPath = (String)options.valueOf((OptionSpec)bitcoinPathOpt);
            this.bitcoinRegtestHost = (String)options.valueOf((OptionSpec)bitcoinRegtestHostOpt);
            this.bitcoinRpcPort = (Integer)options.valueOf((OptionSpec)bitcoinRpcPortOpt);
            this.bitcoinRpcUser = (String)options.valueOf((OptionSpec)bitcoinRpcUserOpt);
            this.bitcoinRpcPassword = (String)options.valueOf((OptionSpec)bitcoinRpcPasswordOpt);
            this.apiPassword = (String)options.valueOf((OptionSpec)apiPasswordOpt);
            this.runSubprojectJars = (Boolean)options.valueOf((OptionSpec)runSubprojectJarsOpt);
            this.havenoAppInitTime = (Long)options.valueOf((OptionSpec)havenoAppInitTimeOpt);
            this.skipTests = (Boolean)options.valueOf((OptionSpec)skipTestsOpt);
            this.shutdownAfterTests = (Boolean)options.valueOf((OptionSpec)shutdownAfterTestsOpt);
            this.supportingApps = Arrays.asList(((String)options.valueOf((OptionSpec)supportingAppsOpt)).split(","));
            this.callRateMeteringConfigPath = (String)options.valueOf((OptionSpec)callRateMeteringConfigPathOpt);
            this.enableHavenoDebugging = (Boolean)options.valueOf((OptionSpec)enableHavenoDebuggingOpt);
            this.registerDisputeAgents = (Boolean)options.valueOf((OptionSpec)registerDisputeAgentsOpt);
            BASH_PATH_VALUE = this.bashPath;
        }
        catch (OptionException ex) {
            throw new IllegalStateException(String.format("Problem parsing option '%s': %s", ex.options().get(0), ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()));
        }
    }

    public boolean hasSupportingApp(String ... supportingApp) {
        return Arrays.stream(supportingApp).anyMatch(this.supportingApps::contains);
    }

    public void printHelp(OutputStream sink, HelpFormatter formatter) {
        try {
            this.parser.formatHelpWith(formatter);
            this.parser.printHelpOn(sink);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private Optional<OptionSet> parseOptionsFrom(File configFile, OptionSpec<?>[] disallowedOpts) {
        if (!configFile.exists() && !configFile.equals(ApiTestConfig.absoluteConfigFile(this.userDir, DEFAULT_CONFIG_FILE_NAME))) {
            throw new IllegalStateException(String.format("The specified config file '%s' does not exist.", configFile));
        }
        Properties properties = this.getProperties(configFile);
        ArrayList optionLines = new ArrayList();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> optionLines.add("--" + String.valueOf(k) + "=" + String.valueOf(v))));
        OptionSet configFileOpts = this.parser.parse(optionLines.toArray(new String[0]));
        for (OptionSpec<?> disallowedOpt : disallowedOpts) {
            if (!configFileOpts.has(disallowedOpt)) continue;
            throw new IllegalStateException(String.format("The '%s' option is disallowed in config files", disallowedOpt.options().get(0)));
        }
        return Optional.of(configFileOpts);
    }

    private Properties getProperties(File configFile) {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(configFile.getAbsolutePath()));
            return properties;
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Could not load properties from config file %s", configFile.getAbsolutePath()), ex);
        }
    }

    private static File absoluteConfigFile(String parentDir, String relativeConfigFilePath) {
        return new File(parentDir, relativeConfigFilePath);
    }
}

