/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest;

import haveno.apitest.config.ApiTestConfig;
import haveno.apitest.linux.BitcoinCli;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmokeTestBitcoind {
    private static final Logger log = LoggerFactory.getLogger(SmokeTestBitcoind.class);
    private final ApiTestConfig config;

    public SmokeTestBitcoind(ApiTestConfig config) {
        this.config = config;
    }

    public void run() throws IOException, InterruptedException {
        this.runBitcoinGetWalletInfo();
        String newBitcoinAddress = this.getNewAddress();
        this.generateToAddress(1, newBitcoinAddress);
    }

    public void runBitcoinGetWalletInfo() throws IOException, InterruptedException {
        log.info("Smoke test bitcoin-cli getwalletinfo");
        BitcoinCli walletInfo = new BitcoinCli(this.config, "getwalletinfo").run();
        log.info("{}\n{}", (Object)walletInfo.getCommandWithOptions(), (Object)walletInfo.getOutput());
        log.info("balance str = {}", (Object)walletInfo.getOutputValueAsString("balance"));
        log.info("balance dbl = {}", (Object)walletInfo.getOutputValueAsDouble("balance"));
        log.info("keypoololdest long = {}", (Object)walletInfo.getOutputValueAsLong("keypoololdest"));
        log.info("paytxfee dbl = {}", (Object)walletInfo.getOutputValueAsDouble("paytxfee"));
        log.info("keypoolsize_hd_internal int = {}", (Object)walletInfo.getOutputValueAsInt("keypoolsize_hd_internal"));
        log.info("private_keys_enabled bool = {}", (Object)walletInfo.getOutputValueAsBoolean("private_keys_enabled"));
        log.info("hdseedid str = {}", (Object)walletInfo.getOutputValueAsString("hdseedid"));
    }

    public String getNewAddress() throws IOException, InterruptedException {
        BitcoinCli newAddress = new BitcoinCli(this.config, "getnewaddress").run();
        log.info("{}\n{}", (Object)newAddress.getCommandWithOptions(), (Object)newAddress.getOutput());
        return newAddress.getOutput();
    }

    public void generateToAddress(int blocks, String address) throws IOException, InterruptedException {
        String generateToAddressCmd = String.format("generatetoaddress %d \"%s\"", blocks, address);
        BitcoinCli generateToAddress = new BitcoinCli(this.config, generateToAddressCmd).run();
        log.info("{}\n{}", (Object)generateToAddress.getCommandWithOptions(), (Object)generateToAddress.getOutputValueAsStringArray());
    }
}

