/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest;

import haveno.apitest.linux.LinuxProcess;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupTask
implements Callable<Status> {
    private static final Logger log = LoggerFactory.getLogger(SetupTask.class);
    private final LinuxProcess linuxProcess;
    private final CountDownLatch countdownLatch;

    public SetupTask(LinuxProcess linuxProcess, CountDownLatch countdownLatch) {
        this.linuxProcess = linuxProcess;
        this.countdownLatch = countdownLatch;
    }

    @Override
    public Status call() throws Exception {
        try {
            this.linuxProcess.start();
            TimeUnit.MILLISECONDS.sleep(1000L);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(String.format("Error starting %s", this.linuxProcess.getName()), ex);
        }
        Objects.requireNonNull(this.countdownLatch).countDown();
        return new Status(this.linuxProcess.getName(), LocalDateTime.now());
    }

    public LinuxProcess getLinuxProcess() {
        return this.linuxProcess;
    }

    public static class Status {
        private final String name;
        private final LocalDateTime startTime;

        public Status(String name, LocalDateTime startTime) {
            this.name = name;
            this.startTime = startTime;
        }

        public String getName() {
            return this.name;
        }

        public LocalDateTime getStartTime() {
            return this.startTime;
        }

        public String toString() {
            return "SetupTask.Status [name=" + this.name + ", completionTime=" + String.valueOf(this.startTime) + "]";
        }
    }
}

