/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest;

import haveno.apitest.SetupTask;
import haveno.apitest.config.ApiTestConfig;
import haveno.apitest.config.HavenoAppConfig;
import haveno.apitest.linux.BashCommand;
import haveno.apitest.linux.BitcoinDaemon;
import haveno.apitest.linux.HavenoProcess;
import haveno.apitest.linux.LinuxProcess;
import haveno.cli.GrpcClient;
import haveno.common.config.HavenoHelpFormatter;
import haveno.common.util.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import joptsimple.HelpFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scaffold {
    private static final Logger log = LoggerFactory.getLogger(Scaffold.class);
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_FAILURE = 1;
    public final ApiTestConfig config;
    @Nullable
    private SetupTask bitcoindTask;
    @Nullable
    private Future<SetupTask.Status> bitcoindTaskFuture;
    @Nullable
    private SetupTask seedNodeTask;
    @Nullable
    private Future<SetupTask.Status> seedNodeTaskFuture;
    @Nullable
    private SetupTask arbNodeTask;
    @Nullable
    private Future<SetupTask.Status> arbNodeTaskFuture;
    @Nullable
    private SetupTask aliceNodeTask;
    @Nullable
    private Future<SetupTask.Status> aliceNodeTaskFuture;
    @Nullable
    private SetupTask bobNodeTask;
    @Nullable
    private Future<SetupTask.Status> bobNodeTaskFuture;
    private final ExecutorService executor;

    public Scaffold(String supportingApps) {
        this(new ApiTestConfig("--supportingApps", supportingApps));
    }

    public Scaffold(String[] args) {
        this(new ApiTestConfig(args));
    }

    public Scaffold(ApiTestConfig config) {
        this.verifyNotWindows();
        this.config = config;
        this.executor = Executors.newFixedThreadPool(config.supportingApps.size());
        if (config.helpRequested) {
            config.printHelp(System.out, (HelpFormatter)new HavenoHelpFormatter("Haveno ApiTest", "haveno-apitest", "0.1.0"));
            System.exit(0);
        }
    }

    public Scaffold setUp() throws IOException, InterruptedException, ExecutionException {
        CountDownLatch countdownLatch = new CountDownLatch(this.config.supportingApps.size());
        this.startBackgroundProcesses(this.executor, countdownLatch);
        this.installShutdownHook();
        Objects.requireNonNull(countdownLatch).await();
        this.verifyStartupCompleted();
        this.maybeRegisterDisputeAgents();
        return this;
    }

    public void tearDown() {
        if (!this.executor.isTerminated()) {
            try {
                log.info("Shutting down executor service ...");
                this.executor.shutdownNow();
                this.executor.awaitTermination((long)this.config.supportingApps.size() * 2000L, TimeUnit.MILLISECONDS);
                SetupTask[] orderedTasks = new SetupTask[]{this.bobNodeTask, this.aliceNodeTask, this.arbNodeTask, this.seedNodeTask, this.bitcoindTask};
                Optional<Throwable> firstException = this.shutDownAll(orderedTasks);
                if (firstException.isPresent()) {
                    throw new IllegalStateException("There were errors shutting down one or more background instances.", firstException.get());
                }
                log.info("Teardown complete");
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private Optional<Throwable> shutDownAll(SetupTask[] orderedTasks) {
        Optional<Throwable> firstException = Optional.empty();
        for (SetupTask t : orderedTasks) {
            if (t == null || t.getLinuxProcess() == null) continue;
            try {
                LinuxProcess p = t.getLinuxProcess();
                p.shutdown();
                TimeUnit.MILLISECONDS.sleep(1000L);
                if (!p.hasShutdownExceptions()) continue;
                p.logExceptions(p.getShutdownExceptions(), log);
                if (firstException.isPresent()) continue;
                firstException = Optional.of(p.getShutdownExceptions().get(0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return firstException;
    }

    private void installBitcoinBlocknotify() {
        try {
            Path srcPath = Paths.get(this.config.baseSrcResourcesDir, "blocknotify");
            Path destPath = Paths.get(this.config.bitcoinDatadir, "blocknotify");
            Files.copy(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING);
            String chmod700Perms = "rwx------";
            Files.setPosixFilePermissions(destPath, PosixFilePermissions.fromString(chmod700Perms));
            log.info("Installed {} with perms {}.", (Object)destPath, (Object)chmod700Perms);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void installCallRateMeteringConfiguration(String dataDir) throws IOException, InterruptedException {
        if (this.config.callRateMeteringConfigPath.isEmpty()) {
            return;
        }
        File testRateMeteringFile = new File(this.config.callRateMeteringConfigPath);
        if (!testRateMeteringFile.exists()) {
            throw new FileNotFoundException(String.format("Call rate metering config file '%s' not found", this.config.callRateMeteringConfigPath));
        }
        BashCommand copyRateMeteringConfigFile = new BashCommand("cp -rf " + this.config.callRateMeteringConfigPath + " " + dataDir);
        if (copyRateMeteringConfigFile.run().getExitStatus() != 0) {
            throw new IllegalStateException(String.format("Could not install %s file in %s", testRateMeteringFile.getAbsolutePath(), dataDir));
        }
        Path destPath = Paths.get(dataDir, testRateMeteringFile.getName());
        String chmod700Perms = "rwx------";
        Files.setPosixFilePermissions(destPath, PosixFilePermissions.fromString(chmod700Perms));
        log.info("Installed {} with perms {}.", (Object)destPath, (Object)chmod700Perms);
    }

    private void installShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::tearDown));
    }

    private void startBackgroundProcesses(ExecutorService executor, CountDownLatch countdownLatch) throws InterruptedException, IOException {
        log.info("Starting supporting apps {}", (Object)this.config.supportingApps.toString());
        if (this.config.hasSupportingApp(BitcoinCoreApp.bitcoind.name())) {
            BitcoinDaemon bitcoinDaemon = new BitcoinDaemon(this.config);
            bitcoinDaemon.verifyBitcoinPathsExist(true);
            this.bitcoindTask = new SetupTask(bitcoinDaemon, countdownLatch);
            this.bitcoindTaskFuture = executor.submit(this.bitcoindTask);
            TimeUnit.MILLISECONDS.sleep(this.config.havenoAppInitTime);
            LinuxProcess bitcoindProcess = this.bitcoindTask.getLinuxProcess();
            if (bitcoindProcess.hasStartupExceptions()) {
                bitcoindProcess.logExceptions(bitcoindProcess.getStartupExceptions(), log);
                throw new IllegalStateException(bitcoindProcess.getStartupExceptions().get(0));
            }
            bitcoinDaemon.verifyBitcoindRunning();
        }
        if (this.config.hasSupportingApp(HavenoAppConfig.seednode.name())) {
            this.startHavenoApp(HavenoAppConfig.seednode, executor, countdownLatch);
        }
        if (this.config.hasSupportingApp(HavenoAppConfig.arbdaemon.name())) {
            this.startHavenoApp(HavenoAppConfig.arbdaemon, executor, countdownLatch);
        } else if (this.config.hasSupportingApp(HavenoAppConfig.arbdesktop.name())) {
            this.startHavenoApp(HavenoAppConfig.arbdesktop, executor, countdownLatch);
        }
        if (this.config.hasSupportingApp(HavenoAppConfig.alicedaemon.name())) {
            this.startHavenoApp(HavenoAppConfig.alicedaemon, executor, countdownLatch);
        } else if (this.config.hasSupportingApp(HavenoAppConfig.alicedesktop.name())) {
            this.startHavenoApp(HavenoAppConfig.alicedesktop, executor, countdownLatch);
        }
        if (this.config.hasSupportingApp(HavenoAppConfig.bobdaemon.name())) {
            this.startHavenoApp(HavenoAppConfig.bobdaemon, executor, countdownLatch);
        } else if (this.config.hasSupportingApp(HavenoAppConfig.bobdesktop.name())) {
            this.startHavenoApp(HavenoAppConfig.bobdesktop, executor, countdownLatch);
        }
    }

    private void startHavenoApp(HavenoAppConfig HavenoAppConfig2, ExecutorService executor, CountDownLatch countdownLatch) throws IOException, InterruptedException {
        HavenoProcess HavenoProcess2 = this.createHavenoProcess(HavenoAppConfig2);
        switch (HavenoAppConfig2) {
            case seednode: {
                this.seedNodeTask = new SetupTask(HavenoProcess2, countdownLatch);
                this.seedNodeTaskFuture = executor.submit(this.seedNodeTask);
                break;
            }
            case arbdaemon: 
            case arbdesktop: {
                this.arbNodeTask = new SetupTask(HavenoProcess2, countdownLatch);
                this.arbNodeTaskFuture = executor.submit(this.arbNodeTask);
                break;
            }
            case alicedaemon: 
            case alicedesktop: {
                this.aliceNodeTask = new SetupTask(HavenoProcess2, countdownLatch);
                this.aliceNodeTaskFuture = executor.submit(this.aliceNodeTask);
                break;
            }
            case bobdaemon: 
            case bobdesktop: {
                this.bobNodeTask = new SetupTask(HavenoProcess2, countdownLatch);
                this.bobNodeTaskFuture = executor.submit(this.bobNodeTask);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown HavenoAppConfig " + HavenoAppConfig2.name());
            }
        }
        log.info("Giving {} ms for {} to initialize ...", (Object)this.config.havenoAppInitTime, (Object)HavenoAppConfig2.appName);
        TimeUnit.MILLISECONDS.sleep(this.config.havenoAppInitTime);
        if (HavenoProcess2.hasStartupExceptions()) {
            HavenoProcess2.logExceptions(HavenoProcess2.getStartupExceptions(), log);
            throw new IllegalStateException((Throwable)HavenoProcess2.getStartupExceptions().get(0));
        }
    }

    private HavenoProcess createHavenoProcess(HavenoAppConfig HavenoAppConfig2) throws IOException, InterruptedException {
        HavenoProcess HavenoProcess2 = new HavenoProcess(HavenoAppConfig2, this.config);
        HavenoProcess2.verifyAppNotRunning();
        HavenoProcess2.verifyAppDataDirInstalled();
        return HavenoProcess2;
    }

    private void verifyStartupCompleted() throws ExecutionException, InterruptedException {
        if (this.bitcoindTaskFuture != null) {
            this.verifyStartupCompleted(this.bitcoindTaskFuture);
        }
        if (this.seedNodeTaskFuture != null) {
            this.verifyStartupCompleted(this.seedNodeTaskFuture);
        }
        if (this.arbNodeTaskFuture != null) {
            this.verifyStartupCompleted(this.arbNodeTaskFuture);
        }
        if (this.aliceNodeTaskFuture != null) {
            this.verifyStartupCompleted(this.aliceNodeTaskFuture);
        }
        if (this.bobNodeTaskFuture != null) {
            this.verifyStartupCompleted(this.bobNodeTaskFuture);
        }
    }

    private void verifyStartupCompleted(Future<SetupTask.Status> futureStatus) throws ExecutionException, InterruptedException {
        for (int i = 0; i < 10; ++i) {
            if (futureStatus.isDone()) {
                log.info("{} completed startup at {} {}", new Object[]{futureStatus.get().getName(), futureStatus.get().getStartTime().toLocalDate(), futureStatus.get().getStartTime().toLocalTime()});
                return;
            }
            TimeUnit.SECONDS.sleep(this.config.supportingApps.size() == 1 ? 2L : 1L);
        }
        throw new IllegalStateException(String.format("%s did not complete startup", futureStatus.get().getName()));
    }

    private void verifyNotWindows() {
        if (Utilities.isWindows()) {
            throw new IllegalStateException("ApiTest not supported on Windows");
        }
    }

    private void maybeRegisterDisputeAgents() {
        if (this.config.hasSupportingApp(HavenoAppConfig.arbdaemon.name()) && this.config.registerDisputeAgents) {
            log.info("Option --registerDisputeAgents=true, registering dispute agents in arbdaemon ...");
            GrpcClient arbClient = new GrpcClient(InetAddress.getLoopbackAddress().getHostAddress(), HavenoAppConfig.arbdaemon.apiPort, this.config.apiPassword);
            arbClient.registerDisputeAgent("mediator", "6ac43ea1df2a290c1c8391736aa42e4339c5cb4f110ff0257a13b63211977b7a");
            arbClient.registerDisputeAgent("refundagent", "6ac43ea1df2a290c1c8391736aa42e4339c5cb4f110ff0257a13b63211977b7a");
        }
    }

    public static enum BitcoinCoreApp {
        bitcoind;

    }
}

