/*
 * Decompiled with CFR 0.152.
 */
package haveno.apitest;

import haveno.apitest.Scaffold;
import haveno.apitest.SmokeTestBitcoind;
import haveno.apitest.config.ApiTestConfig;
import haveno.apitest.config.ApiTestRateMeterInterceptorConfig;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTestMain {
    private static final Logger log = LoggerFactory.getLogger(ApiTestMain.class);

    public static void main(String[] args) {
        if (!ApiTestRateMeterInterceptorConfig.hasCallRateMeteringConfigPathOpt(args)) {
            new ApiTestMain().execute(ApiTestMain.getAppendedArgs(args));
        } else {
            new ApiTestMain().execute(args);
        }
    }

    public void execute(String[] args) {
        try {
            log.info("Configuring test harness with options:\n\t{}", (Object)String.join((CharSequence)"\n\t", args));
            Scaffold scaffold = new Scaffold(args).setUp();
            ApiTestConfig config = scaffold.config;
            if (config.skipTests) {
                log.info("Skipping tests ...");
            } else {
                new SmokeTestBitcoind(config).run();
            }
            if (config.shutdownAfterTests) {
                scaffold.tearDown();
                System.exit(0);
            } else {
                log.info("Not shutting down scaffolding background processes will run until ^C / kill -15 is rcvd ...");
            }
        }
        catch (Throwable ex) {
            System.err.println("Fault: An unexpected error occurred. Please file a report at https://github.com/haveno-dex/haveno/issues");
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static String[] getAppendedArgs(String[] args) {
        File rateMeterInterceptorConfig = ApiTestRateMeterInterceptorConfig.getTestRateMeterInterceptorConfig();
        return ApiTestRateMeterInterceptorConfig.appendCallRateMeteringConfigPathOpt(args, rateMeterInterceptorConfig);
    }
}

