/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import com.runjva.sourceforge.jsocks.protocol.SocksProxyBase;
import com.runjva.sourceforge.jsocks.protocol.SocksSocket;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002\u001a<\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"RETRY_SLEEP", "", "getTorInstance", "Lorg/berndpruenster/netlayer/tor/Tor;", "tor", "setup", "Ljava/net/Socket;", "onionUrl", "", "port", "", "numTries", "proxyHost", "streamID"})
public final class TorSocketsKt {
    private static final long RETRY_SLEEP = 500L;

    /*
     * WARNING - void declaration
     */
    private static final Socket setup(String onionUrl, int port, int numTries, String proxyHost, String streamID, Tor tor) throws IOException {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        long before = calendar.getTimeInMillis();
        Tor mgr = TorSocketsKt.getTorInstance(tor);
        int n = 1;
        int n2 = numTries;
        if (n <= n2) {
            while (true) {
                void i;
                try {
                    KLogger kLogger = TorKt.getLogger();
                    if (kLogger != null) {
                        kLogger.debug((Function0)new Function0<String>(onionUrl, port){
                            final /* synthetic */ String $onionUrl;
                            final /* synthetic */ int $port;

                            @NotNull
                            public final String invoke() {
                                return "trying to connect to " + this.$onionUrl + ':' + this.$port;
                            }
                            {
                                this.$onionUrl = string;
                                this.$port = n;
                                super(0);
                            }
                        });
                    }
                    Socks5Proxy proxy = mgr.getProxy(proxyHost, streamID);
                    KLogger kLogger2 = TorKt.getLogger();
                    if (kLogger2 != null) {
                        kLogger2.debug((Function0)new Function0<String>(proxy){
                            final /* synthetic */ Socks5Proxy $proxy;

                            @NotNull
                            public final String invoke() {
                                return "got proxy " + this.$proxy;
                            }
                            {
                                this.$proxy = socks5Proxy;
                                super(0);
                            }
                        });
                    }
                    SocksSocket ssock = new SocksSocket((SocksProxyBase)proxy, onionUrl, port);
                    KLogger kLogger3 = TorKt.getLogger();
                    if (kLogger3 != null) {
                        StringBuilder stringBuilder = new StringBuilder().append("Took ");
                        Calendar calendar2 = Calendar.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"Calendar.getInstance()");
                        kLogger3.debug(stringBuilder.append(calendar2.getTimeInMillis() - before).append("ms to connect to ").append(onionUrl).append(":").append(port).toString());
                    }
                    ssock.setTcpNoDelay(true);
                    return (Socket)ssock;
                }
                catch (UnknownHostException exx) {
                    KLogger kLogger = TorKt.getLogger();
                    if (kLogger != null) {
                        kLogger.debug("Try " + (int)i + " connecting to " + onionUrl + ':' + port + " failed. retrying...");
                    }
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    throw (Throwable)new IOException("Cannot connect to hidden service");
                }
                if (i == n2) break;
                ++i;
            }
        }
        throw (Throwable)new IOException("Cannot connect to HS");
    }

    private static final Tor getTorInstance(Tor tor) {
        Tor tor2 = tor;
        if (tor2 == null) {
            tor2 = Tor.Companion.getDefault();
        }
        if (tor2 == null) {
            throw (Throwable)new IOException("No default Tor Instance configured");
        }
        return tor2;
    }

    public static final /* synthetic */ Socket access$setup(String onionUrl, int port, int numTries, String proxyHost, String streamID, Tor tor) {
        return TorSocketsKt.setup(onionUrl, port, numTries, proxyHost, streamID, tor);
    }

    public static final /* synthetic */ Tor access$getTorInstance(Tor tor) {
        return TorSocketsKt.getTorInstance(tor);
    }
}

