/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util.filtering;

import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import org.apache.commons.lang3.StringUtils;

public class FilteringUtils {
    public static boolean match(Offer offer, String filterString) {
        if (StringUtils.containsIgnoreCase((CharSequence)offer.getId(), (CharSequence)filterString)) {
            return true;
        }
        return StringUtils.containsIgnoreCase((CharSequence)offer.getPaymentMethod().getDisplayString(), (CharSequence)filterString);
    }

    public static boolean match(Trade trade, String filterString) {
        if (trade == null) {
            return false;
        }
        if (trade.getMaker().getDepositTxHash() != null && StringUtils.containsIgnoreCase((CharSequence)trade.getMaker().getDepositTxHash(), (CharSequence)filterString)) {
            return true;
        }
        if (trade.getTaker().getDepositTxHash() != null && StringUtils.containsIgnoreCase((CharSequence)trade.getTaker().getDepositTxHash(), (CharSequence)filterString)) {
            return true;
        }
        if (trade.getPayoutTxId() != null && StringUtils.containsIgnoreCase((CharSequence)trade.getPayoutTxId(), (CharSequence)filterString)) {
            return true;
        }
        boolean isBuyerOnion = false;
        boolean isSellerOnion = false;
        boolean matchesBuyersPaymentAccountData = false;
        boolean matchesSellersPaymentAccountData = false;
        if (trade.getContract() != null) {
            isBuyerOnion = StringUtils.containsIgnoreCase((CharSequence)trade.getContract().getBuyerNodeAddress().getFullAddress(), (CharSequence)filterString);
            isSellerOnion = StringUtils.containsIgnoreCase((CharSequence)trade.getContract().getSellerNodeAddress().getFullAddress(), (CharSequence)filterString);
            matchesBuyersPaymentAccountData = trade.getBuyer().getPaymentAccountPayload() != null && StringUtils.containsIgnoreCase((CharSequence)trade.getBuyer().getPaymentAccountPayload().getPaymentDetails(), (CharSequence)filterString);
            matchesSellersPaymentAccountData = trade.getSeller().getPaymentAccountPayload() != null && StringUtils.containsIgnoreCase((CharSequence)trade.getSeller().getPaymentAccountPayload().getPaymentDetails(), (CharSequence)filterString);
        }
        return isBuyerOnion || isSellerOnion || matchesBuyersPaymentAccountData || matchesSellersPaymentAccountData;
    }
}

