/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.UserThread;
import haveno.core.user.Preferences;
import haveno.desktop.util.CssTheme;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.Pane;
import javafx.util.Duration;

@Singleton
public class Transitions {
    public static final int DEFAULT_DURATION = 400;
    private final Preferences preferences;
    private Timeline removeEffectTimeLine;

    @Inject
    public Transitions(Preferences preferences) {
        this.preferences = preferences;
    }

    private int getDuration(int duration) {
        return this.preferences.isUseAnimations() ? duration : 1;
    }

    public void fadeIn(Node node) {
        this.fadeIn(node, 400);
    }

    public void fadeIn(Node node, int duration) {
        FadeTransition fade = new FadeTransition(Duration.millis((double)this.getDuration(duration)), node);
        fade.setFromValue(node.getOpacity());
        fade.setToValue(1.0);
        fade.play();
    }

    public FadeTransition fadeOut(Node node) {
        return this.fadeOut(node, 400);
    }

    private FadeTransition fadeOut(Node node, int duration) {
        FadeTransition fade = new FadeTransition(Duration.millis((double)this.getDuration(duration)), node);
        fade.setFromValue(node.getOpacity());
        fade.setToValue(0.0);
        fade.play();
        return fade;
    }

    public void fadeOutAndRemove(Node node) {
        this.fadeOutAndRemove(node, 400);
    }

    public void fadeOutAndRemove(Node node, int duration) {
        this.fadeOutAndRemove(node, duration, null);
    }

    public void fadeOutAndRemove(Node node, int duration, EventHandler<ActionEvent> handler) {
        FadeTransition fade = this.fadeOut(node, this.getDuration(duration));
        fade.setInterpolator(Interpolator.EASE_IN);
        fade.setOnFinished(actionEvent -> {
            ((Pane)node.getParent()).getChildren().remove((Object)node);
            if (handler != null) {
                handler.handle(actionEvent);
            }
        });
    }

    public void blur(Node node) {
        this.blur(node, 400, -0.1, false, 45.0);
    }

    public void blur(Node node, int duration, double brightness, boolean removeNode, double blurRadius) {
        if (this.removeEffectTimeLine != null) {
            this.removeEffectTimeLine.stop();
        }
        node.setMouseTransparent(true);
        GaussianBlur blur = new GaussianBlur(0.0);
        Timeline timeline = new Timeline();
        KeyValue kv1 = new KeyValue((WritableValue)blur.radiusProperty(), (Object)blurRadius);
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)this.getDuration(duration)), new KeyValue[]{kv1});
        ColorAdjust darken = new ColorAdjust();
        darken.setBrightness(0.0);
        blur.setInput((Effect)darken);
        KeyValue kv2 = new KeyValue((WritableValue)darken.brightnessProperty(), (Object)(CssTheme.isDarkTheme() ? brightness * -0.13 : brightness));
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)this.getDuration(duration)), new KeyValue[]{kv2});
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{kf1, kf2});
        node.setEffect((Effect)blur);
        if (removeNode) {
            timeline.setOnFinished(actionEvent -> UserThread.execute(() -> ((Pane)node.getParent()).getChildren().remove((Object)node)));
        }
        timeline.play();
    }

    public void darken(Node node, int duration, boolean removeNode) {
        this.blur(node, duration, -0.2, removeNode, 0.0);
    }

    public void removeEffect(Node node) {
        this.removeEffect(node, 400);
    }

    private void removeEffect(Node node, int duration) {
        if (node != null) {
            node.setMouseTransparent(false);
            this.removeEffectTimeLine = new Timeline();
            GaussianBlur blur = (GaussianBlur)node.getEffect();
            if (blur != null) {
                KeyValue kv1 = new KeyValue((WritableValue)blur.radiusProperty(), (Object)0.0);
                KeyFrame kf1 = new KeyFrame(Duration.millis((double)this.getDuration(duration)), new KeyValue[]{kv1});
                this.removeEffectTimeLine.getKeyFrames().add((Object)kf1);
                ColorAdjust darken = (ColorAdjust)blur.getInput();
                KeyValue kv2 = new KeyValue((WritableValue)darken.brightnessProperty(), (Object)0.0);
                KeyFrame kf2 = new KeyFrame(Duration.millis((double)this.getDuration(duration)), new KeyValue[]{kv2});
                this.removeEffectTimeLine.getKeyFrames().add((Object)kf2);
                this.removeEffectTimeLine.setOnFinished(actionEvent -> {
                    node.setEffect(null);
                    this.removeEffectTimeLine = null;
                });
                this.removeEffectTimeLine.play();
            } else {
                node.setEffect(null);
                this.removeEffectTimeLine = null;
            }
        }
    }
}

