/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MovingAverageUtils {
    public static Stream<Double> simpleMovingAverage(Stream<Number> source, int period) {
        if (period < 1) {
            throw new IllegalArgumentException("Simple moving average period must be a positive number.");
        }
        Stream<Stream<Number>> windows = SlidingWindowSpliterator.windowed(source, period);
        Stream<Double> averages = windows.map(window -> window.mapToDouble(Number::doubleValue).summaryStatistics().getAverage());
        return MovingAverageUtils.prependLagCompensation(averages, period);
    }

    private static Stream<Double> prependLagCompensation(Stream<Double> averages, int period) {
        int lag = period - 1;
        Stream lagCompensation = Collections.nCopies(lag, Double.NaN).stream();
        return Stream.concat(lagCompensation, averages);
    }

    static class SlidingWindowSpliterator<T>
    implements Spliterator<Stream<T>> {
        private final Queue<T> buffer;
        private final Iterator<T> sourceIterator;
        private final int windowSize;

        static <T> Stream<Stream<T>> windowed(Stream<T> source, int windowSize) {
            return StreamSupport.stream(new SlidingWindowSpliterator<T>(source, windowSize), false);
        }

        private SlidingWindowSpliterator(Stream<T> source, int windowSize) {
            this.buffer = new ArrayDeque<T>(windowSize);
            this.sourceIterator = Objects.requireNonNull(source).iterator();
            this.windowSize = windowSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Stream<T>> action) {
            if (this.windowSize < 1) {
                return false;
            }
            while (this.sourceIterator.hasNext()) {
                this.buffer.add(this.sourceIterator.next());
                if (this.buffer.size() != this.windowSize) continue;
                action.accept(Arrays.stream(this.buffer.toArray(new Object[0])));
                this.buffer.poll();
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<Stream<T>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 272;
        }
    }
}

