/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import haveno.common.util.Utilities;
import haveno.core.locale.Country;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Screen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);
    public static final String REMOVE_ICON = "image-remove";

    public static ImageView getImageViewById(String id) {
        ImageView imageView = new ImageView();
        imageView.setId(id);
        return imageView;
    }

    public static Image getApplicationIconImage() {
        String iconPath = Utilities.isOSX() ? (ImageUtil.isRetina() ? "/images/window_icon@2x.png" : "/images/window_icon.png") : (Utilities.isWindows() ? "/images/task_bar_icon_windows.png" : "/images/task_bar_icon_linux.png");
        return ImageUtil.getImageByUrl(iconPath);
    }

    private static Image getImageByUrl(String url) {
        return new Image(ImageUtil.class.getResourceAsStream(url));
    }

    private static ImageView getImageViewByUrl(String url) {
        return new ImageView(ImageUtil.getImageByUrl(url));
    }

    public static ImageView getCountryIconImageView(Country country) {
        try {
            return ImageUtil.getImageViewByUrl("/images/countries/" + country.code.toLowerCase() + ".png");
        }
        catch (Exception e) {
            log.error("Country icon not found URL = /images/countries/" + country.code.toLowerCase() + ".png / country name = " + country.name);
            return null;
        }
    }

    public static Image getImageByPath(String imagePath) {
        return ImageUtil.getImageByUrl("/images/" + imagePath);
    }

    public static boolean isRetina() {
        return Screen.getPrimary().getOutputScaleX() > 1.5;
    }
}

