/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.googlecode.jcsv.CSVStrategy;
import com.googlecode.jcsv.writer.CSVEntryConverter;
import com.googlecode.jcsv.writer.CSVWriter;
import com.googlecode.jcsv.writer.internal.CSVWriterBuilder;
import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIconView;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.file.CorruptedStorageFileHandler;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistenceProtoResolver;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitness;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Region;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountList;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.FormattingUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.Navigation;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.HavenoTextArea;
import haveno.desktop.components.InfoAutoTooltipLabel;
import haveno.desktop.components.indicator.TxConfidenceIndicator;
import haveno.desktop.main.MainView;
import haveno.desktop.main.account.AccountView;
import haveno.desktop.main.account.content.traditionalaccounts.TraditionalAccountsView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.CssTheme;
import haveno.desktop.util.CurrencyListItem;
import haveno.desktop.util.FormBuilder;
import haveno.network.p2p.P2PService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import monero.common.MoneroUtils;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroTxConfig;
import org.apache.commons.lang3.StringUtils;
import org.bitcoinj.core.Coin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIUtil {
    private static final Logger log = LoggerFactory.getLogger(GUIUtil.class);
    public static final String SHOW_ALL_FLAG = "list.currency.showAll";
    public static final String EDIT_FLAG = "list.currency.editList";
    public static final String OPEN_WEB_PAGE_KEY = "warnOpenURLWhenTorEnabled";
    public static final int NUM_DECIMALS_UNIT = 0;
    public static final int NUM_DECIMALS_PRICE_LESS_PRECISE = 3;
    public static final int NUM_DECIMALS_PRECISE = 7;
    public static final int AMOUNT_DECIMALS_WITH_ZEROS = 3;
    public static final int AMOUNT_DECIMALS = 4;
    public static final double NUM_OFFERS_TRANSLATE_X = -13.0;
    public static final boolean disablePaymentUriLabel = true;
    private static Preferences preferences;

    public static void setPreferences(Preferences preferences) {
        GUIUtil.preferences = preferences;
    }

    public static String getUserLanguage() {
        return preferences.getUserLanguage();
    }

    public static double getScrollbarWidth(Node scrollablePane) {
        ScrollBar bar;
        Node node = scrollablePane.lookup(".scroll-bar");
        if (node instanceof ScrollBar && (bar = (ScrollBar)node).getOrientation().equals((Object)Orientation.VERTICAL)) {
            return bar.getWidth();
        }
        return 0.0;
    }

    public static void focusWhenAddedToScene(Node node) {
        node.sceneProperty().addListener((observable, oldValue, newValue) -> {
            if (null != newValue) {
                node.requestFocus();
            }
        });
    }

    public static void exportAccounts(ArrayList<PaymentAccount> accounts, String fileName, Preferences preferences, Stage stage, PersistenceProtoResolver persistenceProtoResolver, CorruptedStorageFileHandler corruptedStorageFileHandler) {
        if (!accounts.isEmpty()) {
            String directory = GUIUtil.getDirectoryFromChooser(preferences, stage);
            if (!directory.isEmpty()) {
                PersistenceManager persistenceManager = new PersistenceManager(new File(directory), persistenceProtoResolver, corruptedStorageFileHandler, null);
                PaymentAccountList paymentAccounts = new PaymentAccountList(accounts);
                persistenceManager.initialize((PersistableEnvelope)paymentAccounts, fileName, PersistenceManager.Source.PRIVATE_LOW_PRIO);
                persistenceManager.persistNow(() -> {
                    persistenceManager.shutdown();
                    ((Popup)new Popup().feedback(Res.get((String)"guiUtil.accountExport.savedToPath", (Object[])new Object[]{Paths.get(directory, fileName).toAbsolutePath()}))).show();
                });
            }
        } else {
            ((Popup)new Popup().warning(Res.get((String)"guiUtil.accountExport.noAccountSetup"))).show();
        }
    }

    public static void importAccounts(User user, String fileName, Preferences preferences, Stage stage, PersistenceProtoResolver persistenceProtoResolver, CorruptedStorageFileHandler corruptedStorageFileHandler) {
        FileChooser fileChooser = new FileChooser();
        File initDir = new File(preferences.getDirectoryChooserPath());
        if (initDir.isDirectory()) {
            fileChooser.setInitialDirectory(initDir);
        }
        fileChooser.setTitle(Res.get((String)"guiUtil.accountExport.selectPath", (Object[])new Object[]{fileName}));
        File file = fileChooser.showOpenDialog(stage.getOwner());
        if (file != null) {
            String path = file.getAbsolutePath();
            if (Paths.get(path, new String[0]).getFileName().toString().equals(fileName)) {
                String directory = Paths.get(path, new String[0]).getParent().toString();
                preferences.setDirectoryChooserPath(directory);
                PersistenceManager persistenceManager = new PersistenceManager(new File(directory), persistenceProtoResolver, corruptedStorageFileHandler, null);
                persistenceManager.readPersisted(fileName, persisted -> {
                    StringBuilder msg = new StringBuilder();
                    HashSet paymentAccounts = new HashSet();
                    List list = persisted.getList();
                    synchronized (list) {
                        persisted.getList().forEach(paymentAccount -> {
                            String id = paymentAccount.getId();
                            if (user.getPaymentAccount(id) == null) {
                                paymentAccounts.add(paymentAccount);
                                msg.append(Res.get((String)"guiUtil.accountExport.tradingAccount", (Object[])new Object[]{id}));
                            } else {
                                msg.append(Res.get((String)"guiUtil.accountImport.noImport", (Object[])new Object[]{id}));
                            }
                        });
                    }
                    user.addImportedPaymentAccounts(paymentAccounts);
                    ((Popup)new Popup().feedback(Res.get((String)"guiUtil.accountImport.imported", (Object[])new Object[]{path, msg}))).show();
                }, () -> ((Popup)new Popup().warning(Res.get((String)"guiUtil.accountImport.noAccountsFound", (Object[])new Object[]{path, fileName}))).show());
            } else {
                log.error("The selected file is not the expected file for import. The expected file name is: " + fileName + ".");
            }
        }
    }

    public static <T> void exportCSV(String fileName, CSVEntryConverter<T> headerConverter, CSVEntryConverter<T> contentConverter, T emptyItem, List<T> list, Stage stage) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialFileName(fileName);
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Charsets.UTF_8);){
                CSVWriter headerWriter = new CSVWriterBuilder((Writer)outputStreamWriter).strategy(CSVStrategy.UK_DEFAULT).entryConverter(headerConverter).build();
                headerWriter.write(emptyItem);
                CSVWriter contentWriter = new CSVWriterBuilder((Writer)outputStreamWriter).strategy(CSVStrategy.UK_DEFAULT).entryConverter(contentConverter).build();
                contentWriter.writeAll(list);
            }
            catch (IOException | RuntimeException e) {
                e.printStackTrace();
                log.error(e.getMessage());
                ((Popup)new Popup().error(Res.get((String)"guiUtil.accountExport.exportFailed", (Object[])new Object[]{e.getMessage()}))).show();
            }
        }
    }

    public static void exportJSON(String fileName, JsonElement data, Stage stage) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialFileName(fileName);
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Charsets.UTF_8);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                outputStreamWriter.write(gson.toJson(data));
            }
            catch (IOException | RuntimeException e) {
                e.printStackTrace();
                log.error(e.getMessage());
                new Popup().error(Res.get((String)"guiUtil.accountExport.exportFailed", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private static String getDirectoryFromChooser(Preferences preferences, Stage stage) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File initDir = new File(preferences.getDirectoryChooserPath());
        if (initDir.isDirectory()) {
            directoryChooser.setInitialDirectory(initDir);
        }
        directoryChooser.setTitle(Res.get((String)"guiUtil.accountExport.selectExportPath"));
        File dir = directoryChooser.showDialog((Window)stage);
        if (dir != null) {
            String directory = dir.getAbsolutePath();
            preferences.setDirectoryChooserPath(directory);
            return directory;
        }
        return "";
    }

    public static Callback<ListView<CurrencyListItem>, ListCell<CurrencyListItem>> getCurrencyListItemCellFactory(final String postFixSingle, final String postFixMulti, final Preferences preferences) {
        return p -> new ListCell<CurrencyListItem>(){

            protected void updateItem(CurrencyListItem item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    String code = item.tradeCurrency.getCode();
                    HBox box = new HBox();
                    box.setSpacing(20.0);
                    box.setAlignment(Pos.CENTER_LEFT);
                    AutoTooltipLabel label1 = new AutoTooltipLabel(GUIUtil.getCurrencyType(code));
                    label1.getStyleClass().add((Object)"currency-label-small");
                    AutoTooltipLabel label2 = new AutoTooltipLabel(CurrencyUtil.isCryptoCurrency((String)code) ? item.tradeCurrency.getNameAndCode() : code);
                    label2.getStyleClass().add((Object)"currency-label");
                    AutoTooltipLabel label3 = new AutoTooltipLabel(CurrencyUtil.isCryptoCurrency((String)code) ? "" : item.tradeCurrency.getName());
                    if (!CurrencyUtil.isCryptoCurrency((String)code)) {
                        label3.getStyleClass().add((Object)"currency-label");
                    }
                    AutoTooltipLabel label4 = new AutoTooltipLabel();
                    box.getChildren().addAll((Object[])new Node[]{label1, label2, label3});
                    if (!CurrencyUtil.isCryptoCurrency((String)code)) {
                        box.getChildren().add((Object)label4);
                    }
                    switch (code) {
                        case "list.currency.showAll": {
                            label1.setText(Res.get((String)"shared.all"));
                            label2.setText(Res.get((String)GUIUtil.SHOW_ALL_FLAG));
                            break;
                        }
                        case "list.currency.editList": {
                            label1.setText(Res.get((String)"shared.edit"));
                            label2.setText(Res.get((String)GUIUtil.EDIT_FLAG));
                            break;
                        }
                        default: {
                            StackPane currencyIcon = GUIUtil.getCurrencyIcon(code);
                            if (currencyIcon != null) {
                                label1.setText("");
                                label1.setGraphic((Node)currencyIcon);
                            }
                            if (!preferences.isSortMarketCurrenciesNumerically() || item.numTrades <= 0) break;
                            boolean isCrypto = CurrencyUtil.isCryptoCurrency((String)code);
                            AutoTooltipLabel offersTarget = isCrypto ? label3 : label4;
                            HBox.setMargin((Node)offersTarget, (Insets)new Insets(0.0, 0.0, 0.0, -13.0));
                            offersTarget.getStyleClass().add((Object)"offer-label");
                            offersTarget.setText(item.numTrades + " " + (item.numTrades == 1 ? postFixSingle : postFixMulti));
                        }
                    }
                    this.setGraphic((Node)box);
                } else {
                    this.setGraphic(null);
                }
            }
        };
    }

    public static ListCell<TradeCurrency> getTradeCurrencyButtonCell(final String postFixSingle, final String postFixMulti, final Map<String, Integer> offerCounts) {
        return new ListCell<TradeCurrency>(){

            protected void updateItem(TradeCurrency item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    String code = item.getCode();
                    AnchorPane pane = new AnchorPane();
                    AutoTooltipLabel currency = new AutoTooltipLabel(item.getName() + " (" + item.getCode() + ")");
                    currency.getStyleClass().add((Object)"currency-label-selected");
                    AnchorPane.setLeftAnchor((Node)currency, (Double)0.0);
                    pane.getChildren().add((Object)currency);
                    Optional<Integer> offerCountOptional = Optional.ofNullable((Integer)offerCounts.get(code));
                    switch (code) {
                        case "list.currency.showAll": {
                            currency.setText(Res.get((String)GUIUtil.SHOW_ALL_FLAG));
                            break;
                        }
                        case "list.currency.editList": {
                            currency.setText(Res.get((String)GUIUtil.EDIT_FLAG));
                            break;
                        }
                        default: {
                            if (!offerCountOptional.isPresent()) break;
                            AutoTooltipLabel numberOfOffers = new AutoTooltipLabel(String.valueOf(offerCountOptional.get()) + " " + (offerCountOptional.get() == 1 ? postFixSingle : postFixMulti));
                            numberOfOffers.getStyleClass().add((Object)"offer-label-small");
                            AnchorPane.setRightAnchor((Node)numberOfOffers, (Double)0.0);
                            AnchorPane.setBottomAnchor((Node)numberOfOffers, (Double)2.0);
                            pane.getChildren().add((Object)numberOfOffers);
                        }
                    }
                    this.setGraphic((Node)pane);
                    this.setText("");
                } else {
                    this.setGraphic(null);
                    this.setText("");
                }
            }
        };
    }

    public static Callback<ListView<TradeCurrency>, ListCell<TradeCurrency>> getTradeCurrencyCellFactory(final String postFixSingle, final String postFixMulti, final Map<String, Integer> offerCounts) {
        return p -> new ListCell<TradeCurrency>(){

            protected void updateItem(TradeCurrency item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    String code = item.getCode();
                    HBox box = new HBox();
                    box.setSpacing(20.0);
                    box.setAlignment(Pos.CENTER_LEFT);
                    AutoTooltipLabel label1 = new AutoTooltipLabel(GUIUtil.getCurrencyType(item.getCode()));
                    label1.getStyleClass().add((Object)"currency-label-small");
                    AutoTooltipLabel label2 = new AutoTooltipLabel(CurrencyUtil.isCryptoCurrency((String)code) ? item.getNameAndCode() : code);
                    label2.getStyleClass().add((Object)"currency-label");
                    AutoTooltipLabel label3 = new AutoTooltipLabel(CurrencyUtil.isCryptoCurrency((String)code) ? "" : item.getName());
                    if (!CurrencyUtil.isCryptoCurrency((String)code)) {
                        label3.getStyleClass().add((Object)"currency-label");
                    }
                    AutoTooltipLabel label4 = new AutoTooltipLabel();
                    Optional<Integer> offerCountOptional = Optional.ofNullable((Integer)offerCounts.get(code));
                    switch (code) {
                        case "list.currency.showAll": {
                            label1.setText(Res.get((String)"shared.all"));
                            label2.setText(Res.get((String)GUIUtil.SHOW_ALL_FLAG));
                            break;
                        }
                        case "list.currency.editList": {
                            label1.setText(Res.get((String)"shared.edit"));
                            label2.setText(Res.get((String)GUIUtil.EDIT_FLAG));
                            break;
                        }
                        default: {
                            boolean isCrypto;
                            StackPane currencyIcon = GUIUtil.getCurrencyIcon(code);
                            if (currencyIcon != null) {
                                label1.setText("");
                                label1.setGraphic((Node)currencyIcon);
                            }
                            AutoTooltipLabel offersTarget = (isCrypto = CurrencyUtil.isCryptoCurrency((String)code)) ? label3 : label4;
                            offerCountOptional.ifPresent(numOffers -> {
                                HBox.setMargin((Node)offersTarget, (Insets)new Insets(0.0, 0.0, 0.0, -13.0));
                                offersTarget.getStyleClass().add((Object)"offer-label");
                                offersTarget.setText(numOffers + " " + (numOffers == 1 ? postFixSingle : postFixMulti));
                            });
                        }
                    }
                    box.getChildren().addAll((Object[])new Node[]{label1, label2, label3});
                    if (!CurrencyUtil.isCryptoCurrency((String)code)) {
                        box.getChildren().add((Object)label4);
                    }
                    this.setGraphic((Node)box);
                } else {
                    this.setGraphic(null);
                }
            }
        };
    }

    public static Callback<ListView<TradeCurrency>, ListCell<TradeCurrency>> getTradeCurrencyCellFactoryNameAndCode() {
        return p -> new ListCell<TradeCurrency>(){

            protected void updateItem(TradeCurrency item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    HBox box = new HBox();
                    box.setSpacing(10.0);
                    AutoTooltipLabel label1 = new AutoTooltipLabel(GUIUtil.getCurrencyType(item.getCode()));
                    label1.getStyleClass().add((Object)"currency-label-small");
                    AutoTooltipLabel label2 = new AutoTooltipLabel(item.getNameAndCode());
                    label2.getStyleClass().add((Object)"currency-label");
                    StackPane currencyIcon = GUIUtil.getCurrencyIcon(item.getCode());
                    if (currencyIcon != null) {
                        label1.setText("");
                        label1.setGraphic((Node)currencyIcon);
                    }
                    box.getChildren().addAll((Object[])new Node[]{label1, label2});
                    this.setGraphic((Node)box);
                } else {
                    this.setGraphic(null);
                }
            }
        };
    }

    private static String getCurrencyType(String code) {
        if (CurrencyUtil.isFiatCurrency((String)code)) {
            return Res.get((String)"shared.fiat");
        }
        if (CurrencyUtil.isTraditionalCurrency((String)code)) {
            return Res.get((String)"shared.traditional");
        }
        if (CurrencyUtil.isCryptoCurrency((String)code)) {
            return Res.get((String)"shared.crypto");
        }
        return "";
    }

    private static String getCurrencyType(PaymentMethod method) {
        return method.isTraditional() ? Res.get((String)"shared.traditional") : Res.get((String)"shared.crypto");
    }

    public static ListCell<PaymentMethod> getPaymentMethodButtonCell() {
        return new ListCell<PaymentMethod>(){

            protected void updateItem(PaymentMethod item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    String id = item.getId();
                    this.getStyleClass().add((Object)"currency-label-selected");
                    if (id.equals(GUIUtil.SHOW_ALL_FLAG)) {
                        this.setText(Res.get((String)GUIUtil.SHOW_ALL_FLAG));
                    } else {
                        this.setText(Res.get((String)id));
                    }
                } else {
                    this.setText("");
                }
            }
        };
    }

    public static Callback<ListView<PaymentMethod>, ListCell<PaymentMethod>> getPaymentMethodCellFactory() {
        return p -> new ListCell<PaymentMethod>(){

            protected void updateItem(PaymentMethod method, boolean empty) {
                super.updateItem((Object)method, empty);
                if (method != null && !empty) {
                    String id = method.getId();
                    HBox box = new HBox();
                    box.setSpacing(20.0);
                    AutoTooltipLabel paymentType = new AutoTooltipLabel(GUIUtil.getCurrencyType(method));
                    paymentType.getStyleClass().add((Object)"currency-label-small");
                    AutoTooltipLabel paymentMethod = new AutoTooltipLabel(Res.get((String)id));
                    paymentMethod.getStyleClass().add((Object)"currency-label");
                    box.getChildren().addAll((Object[])new Node[]{paymentType, paymentMethod});
                    if (id.equals(GUIUtil.SHOW_ALL_FLAG)) {
                        paymentType.setText(Res.get((String)"shared.all"));
                        paymentMethod.setText(Res.get((String)GUIUtil.SHOW_ALL_FLAG));
                    }
                    this.setGraphic((Node)box);
                } else {
                    this.setGraphic(null);
                }
            }
        };
    }

    public static void updateConfidence(MoneroTx tx, Tooltip tooltip, TxConfidenceIndicator txConfidenceIndicator) {
        GUIUtil.updateConfidence(tx, null, tooltip, txConfidenceIndicator);
    }

    public static void updateConfidence(MoneroTx tx, Trade trade, Tooltip tooltip, TxConfidenceIndicator txConfidenceIndicator) {
        if (tx == null || tx.getNumConfirmations() == null || !tx.isRelayed().booleanValue()) {
            if (trade != null && trade.isDepositsUnlocked()) {
                tooltip.setText(Res.get((String)"confidence.confirmed", (Object[])new Object[]{">=10"}));
                txConfidenceIndicator.setProgress(1.0);
            } else {
                tooltip.setText(Res.get((String)"confidence.unknown"));
                txConfidenceIndicator.setProgress(-1.0);
            }
        } else if (tx.isFailed().booleanValue()) {
            tooltip.setText(Res.get((String)"confidence.invalid"));
            txConfidenceIndicator.setProgress(0.0);
        } else if (tx.isConfirmed().booleanValue()) {
            tooltip.setText(Res.get((String)"confidence.confirmed", (Object[])new Object[]{tx.getNumConfirmations()}));
            txConfidenceIndicator.setProgress((double)tx.getNumConfirmations().longValue() / 10.0);
        } else {
            tooltip.setText(Res.get((String)"confidence.confirmed", (Object[])new Object[]{0}));
            txConfidenceIndicator.setProgress(-1.0);
        }
        txConfidenceIndicator.setPrefSize(24.0, 24.0);
    }

    public static void openWebPage(String target) {
        GUIUtil.openWebPage(target, true, null);
    }

    public static void openWebPage(String target, boolean useReferrer) {
        GUIUtil.openWebPage(target, useReferrer, null);
    }

    public static void openWebPageNoPopup(String target) {
        GUIUtil.doOpenWebPage(target);
    }

    public static void openWebPage(String target, boolean useReferrer, Runnable closeHandler) {
        if (useReferrer && target.contains("haveno.network")) {
            target = GUIUtil.appendURI(target, "utm_source=desktop-client&utm_medium=in-app-link&utm_campaign=language_" + preferences.getUserLanguage());
        }
        if (DontShowAgainLookup.showAgain((String)OPEN_WEB_PAGE_KEY)) {
            String finalTarget = target;
            ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"guiUtil.openWebBrowser.warning", (Object[])new Object[]{target}))).actionButtonText(Res.get((String)"guiUtil.openWebBrowser.doOpen"))).onAction(() -> {
                DontShowAgainLookup.dontShowAgain((String)OPEN_WEB_PAGE_KEY, (boolean)true);
                GUIUtil.doOpenWebPage(finalTarget);
            })).closeButtonText(Res.get((String)"guiUtil.openWebBrowser.copyUrl"))).onClose(() -> {
                Utilities.copyToClipboard((String)finalTarget);
                if (closeHandler != null) {
                    closeHandler.run();
                }
            })).show();
        } else {
            if (closeHandler != null) {
                closeHandler.run();
            }
            GUIUtil.doOpenWebPage(target);
        }
    }

    private static String appendURI(String uri, String appendQuery) {
        try {
            URI oldURI = new URI(uri);
            Object newQuery = oldURI.getQuery();
            newQuery = newQuery == null ? appendQuery : (String)newQuery + "&" + appendQuery;
            URI newURI = new URI(oldURI.getScheme(), oldURI.getAuthority(), oldURI.getPath(), (String)newQuery, oldURI.getFragment());
            return newURI.toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return uri;
        }
    }

    private static void doOpenWebPage(String target) {
        try {
            Utilities.openURI((URI)GUIUtil.safeParse(target));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    private static URI safeParse(String url) throws URISyntaxException {
        int hashIndex = url.indexOf(35);
        if (hashIndex >= 0 && hashIndex < url.length() - 1) {
            String base = url.substring(0, hashIndex);
            String fragment = url.substring(hashIndex + 1);
            String encodedFragment = URLEncoder.encode(fragment, StandardCharsets.UTF_8);
            return new URI(base + "#" + encodedFragment);
        }
        return new URI(url);
    }

    public static String getPercentageOfTradeAmount(BigInteger fee, BigInteger tradeAmount) {
        String result = " (" + GUIUtil.getPercentage(fee, tradeAmount) + " " + Res.get((String)"guiUtil.ofTradeAmount") + ")";
        return result;
    }

    public static String getPercentage(BigInteger part, BigInteger total) {
        return FormattingUtils.formatToPercentWithSymbol((double)HavenoUtils.divide((BigInteger)part, (BigInteger)total));
    }

    public static <T> T getParentOfType(Node node, Class<T> t) {
        Parent parent;
        for (parent = node.getParent(); parent != null && !parent.getClass().isAssignableFrom(t); parent = parent.getParent()) {
        }
        return t.cast(parent);
    }

    public static void showZelleWarning() {
        String key = "confirmZelleRequirements";
        String currencyName = Config.baseCurrencyNetwork().getCurrencyName();
        ((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.zelle.info", (Object[])new Object[]{currencyName, currencyName}))).width(900.0)).closeButtonText(Res.get((String)"shared.iConfirm"))).dontShowAgainId(key)).show();
    }

    public static void showFasterPaymentsWarning(Navigation navigation) {
        String key = "recreateFasterPaymentsAccount";
        String currencyName = Config.baseCurrencyNetwork().getCurrencyName();
        ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.fasterPayments.newRequirements.info", (Object[])new Object[]{currencyName}))).width(900.0)).actionButtonTextWithGoTo("mainView.menu.account")).onAction(() -> {
            navigation.setReturnPath(navigation.getCurrentPath());
            navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
        })).dontShowAgainId(key)).show();
    }

    public static String getMoneroURI(String address, BigInteger amount, String label) {
        MoneroTxConfig txConfig = new MoneroTxConfig().setAddress(address);
        if (amount != null) {
            txConfig.setAmount(amount);
        }
        if (label == null || !label.isEmpty()) {
            // empty if block
        }
        return MoneroUtils.getPaymentUri((MoneroTxConfig)txConfig);
    }

    public static boolean isBootstrappedOrShowPopup(P2PService p2PService) {
        if (p2PService.isBootstrapped() && p2PService.getNumConnectedPeers().get() > 0) {
            return true;
        }
        ((Popup)new Popup().information(Res.get((String)"popup.warning.notFullyConnected"))).show();
        return false;
    }

    public static boolean isReadyForTxBroadcastOrShowPopup(XmrWalletService xmrWalletService) {
        XmrConnectionService xmrConnectionService = xmrWalletService.getXmrConnectionService();
        if (!xmrConnectionService.hasSufficientPeersForBroadcast()) {
            ((Popup)new Popup().information(Res.get((String)"popup.warning.notSufficientConnectionsToXmrNetwork", (Object[])new Object[]{xmrConnectionService.getMinBroadcastConnections()}))).show();
            return false;
        }
        if (!xmrConnectionService.isDownloadComplete()) {
            ((Popup)new Popup().information(Res.get((String)"popup.warning.downloadNotComplete"))).show();
            return false;
        }
        if (!GUIUtil.isWalletSyncedWithinToleranceOrShowPopup(xmrWalletService)) {
            return false;
        }
        try {
            xmrConnectionService.verifyConnection();
        }
        catch (Exception e) {
            ((Popup)new Popup().information(e.getMessage())).show();
            return false;
        }
        return true;
    }

    public static boolean isWalletSyncedWithinToleranceOrShowPopup(XmrWalletService xmrWalletService) {
        if (!xmrWalletService.isSyncedWithinTolerance()) {
            ((Popup)new Popup().information(Res.get((String)"popup.warning.walletNotSynced"))).show();
            return false;
        }
        return true;
    }

    public static boolean canCreateOrTakeOfferOrShowPopup(User user, Navigation navigation) {
        if (!user.hasAcceptedArbitrators()) {
            log.warn("There are no arbitrators available");
            ((Popup)new Popup().warning(Res.get((String)"popup.warning.noArbitratorsAvailable"))).show();
            return false;
        }
        if (user.currentPaymentAccountProperty().get() == null) {
            ((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"popup.warning.noTradingAccountSetup.headline"))).instruction(Res.get((String)"popup.warning.noTradingAccountSetup.msg"))).actionButtonTextWithGoTo("mainView.menu.account")).onAction(() -> {
                navigation.setReturnPath(navigation.getCurrentPath());
                navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
            })).show();
            return false;
        }
        return true;
    }

    public static void showWantToBurnBTCPopup(Coin miningFee, Coin amount, CoinFormatter btcFormatter) {
        ((Popup)new Popup().warning(Res.get((String)"popup.warning.burnXMR", (Object[])new Object[]{btcFormatter.formatCoinWithCode(miningFee), btcFormatter.formatCoinWithCode(amount)}))).show();
    }

    public static void requestFocus(Node node) {
        UserThread.execute(() -> ((Node)node).requestFocus());
    }

    public static void rescanOutputs(Preferences preferences) {
        try {
            ((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"settings.net.rescanOutputsSuccess"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> {
                throw new RuntimeException("Rescanning wallet outputs not yet implemented");
            })).closeButtonText(Res.get((String)"shared.cancel"))).show();
        }
        catch (Throwable t) {
            ((Popup)new Popup().error(Res.get((String)"settings.net.rescanOutputsFailed", (Object[])new Object[]{t}))).show();
        }
    }

    public static void showSelectableTextModal(String title, String text) {
        HavenoTextArea textArea = new HavenoTextArea();
        textArea.setText(text);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setPrefSize(800.0, 600.0);
        Scene scene = new Scene((Parent)textArea);
        Stage stage = new Stage();
        if (null != title) {
            stage.setTitle(title);
        }
        stage.setScene(scene);
        stage.initModality(Modality.NONE);
        stage.initStyle(StageStyle.UTILITY);
        stage.show();
    }

    public static StringConverter<PaymentAccount> getPaymentAccountsComboBoxStringConverter() {
        return new StringConverter<PaymentAccount>(){

            public String toString(PaymentAccount paymentAccount) {
                if (paymentAccount.hasMultipleCurrencies()) {
                    return paymentAccount.getAccountName() + " (" + Res.get((String)paymentAccount.getPaymentMethod().getId()) + ")";
                }
                TradeCurrency singleTradeCurrency = paymentAccount.getSingleTradeCurrency();
                String prefix = singleTradeCurrency != null ? singleTradeCurrency.getCode() + ", " : "";
                return paymentAccount.getAccountName() + " (" + prefix + Res.get((String)paymentAccount.getPaymentMethod().getId()) + ")";
            }

            public PaymentAccount fromString(String s) {
                return null;
            }
        };
    }

    public static Callback<ListView<PaymentAccount>, ListCell<PaymentAccount>> getPaymentAccountListCellFactory(final ComboBox<PaymentAccount> paymentAccountsComboBox, final AccountAgeWitnessService accountAgeWitnessService) {
        return p -> new ListCell<PaymentAccount>(){

            protected void updateItem(PaymentAccount item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    boolean needsSigning = PaymentMethod.hasChargebackRisk((PaymentMethod)item.getPaymentMethod(), (List)item.getTradeCurrencies());
                    InfoAutoTooltipLabel label = new InfoAutoTooltipLabel(paymentAccountsComboBox.getConverter().toString((Object)item), ContentDisplay.RIGHT);
                    if (needsSigning) {
                        AccountAgeWitness myWitness = accountAgeWitnessService.getMyWitness(item.paymentAccountPayload);
                        AccountAgeWitnessService.SignState signState = accountAgeWitnessService.getSignState(myWitness);
                        String info = StringUtils.capitalize((String)signState.getDisplayString());
                        MaterialDesignIcon icon = GUIUtil.getIconForSignState(signState);
                        label.setIcon((GlyphIcons)icon, info);
                    }
                    this.setGraphic((Node)label);
                } else {
                    this.setGraphic(null);
                }
            }
        };
    }

    public static void removeChildrenFromGridPaneRows(GridPane gridPane, int start, int end) {
        HashMap childByRowMap = new HashMap();
        gridPane.getChildren().forEach(child -> {
            Integer rowIndex = GridPane.getRowIndex((Node)child);
            childByRowMap.computeIfAbsent(rowIndex, key -> new ArrayList());
            ((List)childByRowMap.get(rowIndex)).add(child);
        });
        for (int i = Math.min(start, childByRowMap.size()); i < Math.min(end + 1, childByRowMap.size()); ++i) {
            List nodes = (List)childByRowMap.get(i);
            if (nodes == null) continue;
            nodes.stream().filter(Objects::nonNull).filter(node -> gridPane.getChildren().contains(node)).forEach(node -> gridPane.getChildren().remove(node));
        }
    }

    public static void setFitToRowsForTableView(TableView<?> tableView, int rowHeight, int headerHeight, int minNumRows, int maxNumRows) {
        int size = tableView.getItems().size();
        int maxHeight = rowHeight * maxNumRows + headerHeight;
        int minHeight = rowHeight * minNumRows + headerHeight;
        Preconditions.checkArgument((maxHeight >= minHeight ? 1 : 0) != 0, (Object)"maxHeight cannot be smaller as minHeight");
        int height = Math.min(maxHeight, Math.max(minHeight, size * rowHeight + headerHeight));
        tableView.setPrefHeight(-1.0);
        tableView.setVisible(false);
        tableView.setPrefHeight((double)height);
        UserThread.execute(() -> {
            tableView.setPrefHeight((double)height);
            tableView.setVisible(true);
        });
    }

    public static Tuple2<ComboBox<TradeCurrency>, Integer> addRegionCountryTradeCurrencyComboBoxes(GridPane gridPane, int gridRow, Consumer<Country> onCountrySelectedHandler, Consumer<TradeCurrency> onTradeCurrencySelectedHandler) {
        gridRow = GUIUtil.addRegionCountry(gridPane, gridRow, onCountrySelectedHandler);
        ComboBox currencyComboBox = FormBuilder.addComboBox(gridPane, ++gridRow, Res.get((String)"shared.currency"));
        currencyComboBox.setPromptText(Res.get((String)"list.currency.select"));
        currencyComboBox.setItems(FXCollections.observableArrayList((Collection)CurrencyUtil.getAllSortedTraditionalCurrencies()));
        currencyComboBox.setConverter((StringConverter)new StringConverter<TradeCurrency>(){

            public String toString(TradeCurrency currency) {
                return currency.getNameAndCode();
            }

            public TradeCurrency fromString(String string) {
                return null;
            }
        });
        currencyComboBox.setDisable(true);
        currencyComboBox.setOnAction(e -> onTradeCurrencySelectedHandler.accept((TradeCurrency)currencyComboBox.getSelectionModel().getSelectedItem()));
        return new Tuple2(currencyComboBox, (Object)gridRow);
    }

    public static int addRegionCountry(GridPane gridPane, int gridRow, Consumer<Country> onCountrySelectedHandler) {
        Tuple3 tuple3 = FormBuilder.addTopLabelComboBoxComboBox(gridPane, ++gridRow, Res.get((String)"payment.country"));
        ComboBox regionComboBox = (ComboBox)tuple3.second;
        regionComboBox.setPromptText(Res.get((String)"payment.select.region"));
        regionComboBox.setConverter((StringConverter)new StringConverter<Region>(){

            public String toString(Region region) {
                return region.name;
            }

            public Region fromString(String s) {
                return null;
            }
        });
        regionComboBox.setItems(FXCollections.observableArrayList((Collection)CountryUtil.getAllRegions()));
        ComboBox countryComboBox = (ComboBox)tuple3.third;
        countryComboBox.setVisibleRowCount(15);
        countryComboBox.setDisable(true);
        countryComboBox.setPromptText(Res.get((String)"payment.select.country"));
        countryComboBox.setConverter((StringConverter)new StringConverter<Country>(){

            public String toString(Country country) {
                return country.name + " (" + country.code + ")";
            }

            public Country fromString(String s) {
                return null;
            }
        });
        regionComboBox.setOnAction(e -> {
            Region selectedItem = (Region)regionComboBox.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                countryComboBox.setDisable(false);
                countryComboBox.setItems(FXCollections.observableArrayList((Collection)CountryUtil.getAllCountriesForRegion((Region)selectedItem)));
            }
        });
        countryComboBox.setOnAction(e -> onCountrySelectedHandler.accept((Country)countryComboBox.getSelectionModel().getSelectedItem()));
        return gridRow;
    }

    @NotNull
    public static <T> ListCell<T> getComboBoxButtonCell(String title, ComboBox<T> comboBox) {
        return GUIUtil.getComboBoxButtonCell(title, comboBox, true);
    }

    @NotNull
    public static <T> ListCell<T> getComboBoxButtonCell(final String title, final ComboBox<T> comboBox, final Boolean hideOriginalPrompt) {
        return new ListCell<T>(){

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (hideOriginalPrompt.booleanValue()) {
                    this.setVisible(item != null || !empty);
                }
                if (empty || item == null) {
                    this.setText(title);
                } else {
                    this.setText(comboBox.getConverter().toString(item));
                }
            }
        };
    }

    public static MaterialDesignIcon getIconForSignState(AccountAgeWitnessService.SignState state) {
        if (state.equals((Object)AccountAgeWitnessService.SignState.PEER_INITIAL)) {
            return MaterialDesignIcon.CLOCK;
        }
        return state.equals((Object)AccountAgeWitnessService.SignState.ARBITRATOR) || state.equals((Object)AccountAgeWitnessService.SignState.PEER_SIGNER) ? MaterialDesignIcon.APPROVAL : MaterialDesignIcon.ALERT_CIRCLE_OUTLINE;
    }

    public static ScrollPane createScrollPane() {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        AnchorPane.setLeftAnchor((Node)scrollPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)scrollPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)scrollPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)scrollPane, (Double)0.0);
        return scrollPane;
    }

    public static void setDefaultTwoColumnConstraintsForGridPane(GridPane gridPane) {
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        columnConstraints1.setHalignment(HPos.RIGHT);
        columnConstraints1.setHgrow(Priority.NEVER);
        columnConstraints1.setMinWidth(200.0);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints1, columnConstraints2});
    }

    public static void applyFilledStyle(TextField textField) {
        textField.textProperty().addListener((observable, oldValue, newValue) -> GUIUtil.updateFilledStyle(textField));
    }

    private static void updateFilledStyle(TextField textField) {
        if (textField.getText() != null && !textField.getText().isEmpty()) {
            if (!textField.getStyleClass().contains((Object)"filled")) {
                textField.getStyleClass().add((Object)"filled");
            }
        } else {
            textField.getStyleClass().remove((Object)"filled");
        }
    }

    public static void applyFilledStyle(ComboBox<?> comboBox) {
        comboBox.valueProperty().addListener((observable, oldValue, newValue) -> GUIUtil.updateFilledStyle(comboBox));
    }

    private static void updateFilledStyle(ComboBox<?> comboBox) {
        if (comboBox.getValue() != null) {
            if (!comboBox.getStyleClass().contains((Object)"filled")) {
                comboBox.getStyleClass().add((Object)"filled");
            }
        } else {
            comboBox.getStyleClass().remove((Object)"filled");
        }
    }

    public static void applyTableStyle(TableView<?> tableView) {
        GUIUtil.applyTableStyle(tableView, true);
    }

    public static void applyTableStyle(TableView<?> tableView, boolean applyRoundedArc) {
        if (applyRoundedArc) {
            GUIUtil.applyRoundedArc(tableView);
        }
        GUIUtil.addSpacerColumns(tableView);
        GUIUtil.applyEdgeColumnStyleClasses(tableView);
    }

    private static void applyRoundedArc(TableView<?> tableView) {
        Rectangle clip = new Rectangle();
        clip.setArcWidth(20.0);
        clip.setArcHeight(20.0);
        tableView.setClip((Node)clip);
        tableView.layoutBoundsProperty().addListener((obs, oldVal, newVal) -> {
            clip.setWidth(newVal.getWidth());
            clip.setHeight(newVal.getHeight());
        });
    }

    private static <T> void addSpacerColumns(TableView<T> tableView) {
        TableColumn leftSpacer = new TableColumn();
        TableColumn rightSpacer = new TableColumn();
        GUIUtil.configureSpacerColumn(leftSpacer);
        GUIUtil.configureSpacerColumn(rightSpacer);
        tableView.getColumns().add(0, (Object)leftSpacer);
        tableView.getColumns().add((Object)rightSpacer);
    }

    private static void configureSpacerColumn(TableColumn<?, ?> column) {
        column.setPrefWidth(15.0);
        column.setMaxWidth(15.0);
        column.setMinWidth(15.0);
        column.setReorderable(false);
        column.setResizable(false);
        column.setSortable(false);
        column.setCellFactory(col -> new TableCell());
    }

    private static <T> void applyEdgeColumnStyleClasses(TableView<T> tableView) {
        ListChangeListener columnListener = change -> UserThread.execute(() -> GUIUtil.updateEdgeColumnStyleClasses(tableView));
        tableView.getColumns().addListener(columnListener);
        tableView.skinProperty().addListener((obs, oldSkin, newSkin) -> {
            if (newSkin != null) {
                UserThread.execute(() -> GUIUtil.updateEdgeColumnStyleClasses(tableView));
            }
        });
        ChangeListener sizeListener = (obs, oldVal, newVal) -> GUIUtil.updateEdgeColumnStyleClasses(tableView);
        tableView.heightProperty().addListener(sizeListener);
        tableView.widthProperty().addListener(sizeListener);
        GUIUtil.updateEdgeColumnStyleClasses(tableView);
    }

    private static <T> void updateEdgeColumnStyleClasses(TableView<T> tableView) {
        ObservableList columns = tableView.getColumns();
        TableColumn firstCol = null;
        TableColumn lastCol = null;
        for (TableColumn col : columns) {
            if (col.getStyleClass().contains((Object)"first-column")) {
                firstCol = col;
                continue;
            }
            if (!col.getStyleClass().contains((Object)"last-column")) continue;
            lastCol = col;
        }
        if (firstCol == null || lastCol == null) {
            if (firstCol != null) {
                throw new IllegalStateException("Missing column with 'last-column'");
            }
            if (lastCol != null) {
                throw new IllegalStateException("Missing column with 'first-column'");
            }
            for (TableColumn col : columns) {
                col.getStyleClass().removeAll((Object[])new String[]{"first-column", "last-column"});
            }
            if (!columns.isEmpty()) {
                TableColumn first = (TableColumn)columns.get(0);
                TableColumn last = (TableColumn)columns.get(columns.size() - 1);
                if (!first.getStyleClass().contains((Object)"first-column")) {
                    first.getStyleClass().add((Object)"first-column");
                }
                if (!last.getStyleClass().contains((Object)"last-column")) {
                    last.getStyleClass().add((Object)"last-column");
                }
            }
        } else {
            if (columns.get(0) == firstCol && columns.get(columns.size() - 1) == lastCol) {
                return;
            }
            if (columns.get(0) != firstCol) {
                columns.remove((Object)firstCol);
                columns.add(0, (Object)firstCol);
            }
            if (columns.get(columns.size() - 1) != lastCol) {
                columns.remove((Object)lastCol);
                columns.add(firstCol == lastCol ? columns.size() - 1 : columns.size(), (Object)lastCol);
            }
        }
    }

    public static <T> ObservableList<TableColumn<T, ?>> getContentColumns(TableView<T> tableView) {
        ObservableList contentColumns = FXCollections.observableArrayList();
        for (TableColumn column : tableView.getColumns()) {
            if (column.getStyleClass().contains((Object)"first-column") || column.getStyleClass().contains((Object)"last-column")) continue;
            contentColumns.add((Object)column);
        }
        return contentColumns;
    }

    private static ImageView getCurrencyImageView(String currencyCode) {
        return GUIUtil.getCurrencyImageView(currencyCode, 24.0);
    }

    private static ImageView getCurrencyImageView(String currencyCode, double size) {
        if (currencyCode == null) {
            return null;
        }
        String imageId = GUIUtil.getImageId(currencyCode);
        if (imageId == null) {
            return null;
        }
        ImageView icon = new ImageView();
        icon.setFitWidth(size);
        icon.setPreserveRatio(true);
        icon.setSmooth(true);
        icon.setCache(true);
        icon.setId(imageId);
        return icon;
    }

    public static StackPane getCurrencyIcon(String currencyCode) {
        ImageView icon = GUIUtil.getCurrencyImageView(currencyCode);
        return icon == null ? null : new StackPane(new Node[]{icon});
    }

    public static StackPane getCurrencyIcon(String currencyCode, double size) {
        ImageView icon = GUIUtil.getCurrencyImageView(currencyCode, size);
        return icon == null ? null : new StackPane(new Node[]{icon});
    }

    public static StackPane getCurrencyIconWithBorder(String currencyCode) {
        return GUIUtil.getCurrencyIconWithBorder(currencyCode, 25.0, 1.0);
    }

    public static StackPane getCurrencyIconWithBorder(String currencyCode, double size, double borderWidth) {
        if (currencyCode == null) {
            return null;
        }
        ImageView icon = GUIUtil.getCurrencyImageView(currencyCode, size);
        icon.setFitWidth(size - 2.0 * borderWidth);
        icon.setFitHeight(size - 2.0 * borderWidth);
        StackPane circleWrapper = new StackPane(new Node[]{icon});
        circleWrapper.setPrefSize(size, size);
        circleWrapper.setMaxSize(size, size);
        circleWrapper.setMinSize(size, size);
        circleWrapper.setStyle("-fx-background-color: white;-fx-background-radius: 50%;-fx-border-radius: 50%;-fx-border-color: white;-fx-border-width: " + borderWidth + "px;");
        StackPane.setAlignment((Node)icon, (Pos)Pos.CENTER);
        return circleWrapper;
    }

    private static String getImageId(String currencyCode) {
        if (currencyCode == null) {
            return null;
        }
        if (CurrencyUtil.isCryptoCurrency((String)currencyCode)) {
            return "image-" + currencyCode.toLowerCase() + "-logo";
        }
        if (CurrencyUtil.isFiatCurrency((String)currencyCode)) {
            return "image-fiat-logo";
        }
        return null;
    }

    public static void adjustHeightAutomatically(TextArea textArea) {
        GUIUtil.adjustHeightAutomatically(textArea, null);
    }

    public static void adjustHeightAutomatically(TextArea textArea, Double maxHeight) {
        textArea.sceneProperty().addListener((o, oldScene, newScene) -> {
            if (newScene != null) {
                CssTheme.loadSceneStyles(newScene, CssTheme.getCurrentTheme(), false);
                textArea.applyCss();
                Node text = textArea.lookup(".text");
                textArea.prefHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                    Insets padding = textArea.getInsets();
                    double topBottomPadding = padding.getTop() + padding.getBottom();
                    double prefHeight = textArea.getFont().getSize() + text.getBoundsInLocal().getHeight() + topBottomPadding;
                    return maxHeight == null ? prefHeight : Math.min(prefHeight, maxHeight);
                }, (Observable[])new Observable[]{text.boundsInLocalProperty()}));
                text.boundsInLocalProperty().addListener((observableBoundsAfter, boundsBefore, boundsAfter) -> Platform.runLater(() -> textArea.requestLayout()));
            }
        });
    }

    public static Label getLockLabel() {
        Label lockLabel = FormBuilder.getIcon(AwesomeIcon.LOCK, "16px");
        lockLabel.setStyle(lockLabel.getStyle() + " -fx-text-fill: white;");
        return lockLabel;
    }

    public static MaterialDesignIconView getCopyIcon() {
        return new MaterialDesignIconView(MaterialDesignIcon.CONTENT_COPY, "1.35em");
    }

    public static Tuple2<StackPane, ImageView> getSmallXmrQrCodePane() {
        return GUIUtil.getXmrQrCodePane(150, 32, 2);
    }

    public static Tuple2<StackPane, ImageView> getBigXmrQrCodePane() {
        return GUIUtil.getXmrQrCodePane(250, 47, 3);
    }

    private static Tuple2<StackPane, ImageView> getXmrQrCodePane(int qrCodeSize, int logoSize, int logoBorderWidth) {
        ImageView qrCodeImageView = new ImageView();
        qrCodeImageView.setFitHeight((double)qrCodeSize);
        qrCodeImageView.setFitWidth((double)qrCodeSize);
        qrCodeImageView.getStyleClass().add((Object)"qr-code");
        StackPane xmrLogo = GUIUtil.getCurrencyIconWithBorder(Res.getBaseCurrencyCode(), logoSize, logoBorderWidth);
        StackPane qrCodePane = new StackPane(new Node[]{qrCodeImageView, xmrLogo});
        qrCodePane.setCursor(Cursor.HAND);
        qrCodePane.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        return new Tuple2((Object)qrCodePane, (Object)qrCodeImageView);
    }
}

