/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import javafx.animation.AnimationTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIProfiler {
    private static final Logger log = LoggerFactory.getLogger(GUIProfiler.class);
    private static final Stopwatch globalStopwatch = Stopwatch.createStarted();
    private static final ThreadLocal<Stopwatch> threadStopwatch = ThreadLocal.withInitial(Stopwatch::createStarted);
    private static final ThreadLocal<Long> last = ThreadLocal.withInitial(() -> 0L);
    private static long lastFPSTime = System.currentTimeMillis();

    public static void printMsgWithTime(String msg) {
        long elapsed = threadStopwatch.get().elapsed(TimeUnit.MILLISECONDS);
        log.trace("\n\nCalled by: {} \nElapsed time: {}ms \nTotal time:   {}ms\n\n", new Object[]{msg, elapsed - last.get(), globalStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        last.set(elapsed);
    }

    public static void init() {
        AnimationTimer fpsTimer = new AnimationTimer(){

            public void handle(long l) {
                long elapsed = System.currentTimeMillis() - lastFPSTime;
                if (elapsed > 50L) {
                    log.trace("Profiler: last frame used {}ms", (Object)elapsed);
                }
                lastFPSTime = System.currentTimeMillis();
            }
        };
        fpsTimer.start();
    }
}

