/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXToggleButton;
import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.common.util.Tuple4;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.desktop.components.AddressTextField;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipCheckBox;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipRadioButton;
import haveno.desktop.components.AutoTooltipSlideToggleButton;
import haveno.desktop.components.AutoTooltipTextField;
import haveno.desktop.components.AutocompleteComboBox;
import haveno.desktop.components.BalanceTextField;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.ExplorerAddressTextField;
import haveno.desktop.components.ExternalHyperlink;
import haveno.desktop.components.FundsTextField;
import haveno.desktop.components.HavenoTextArea;
import haveno.desktop.components.HavenoTextField;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.components.InfoInputTextField;
import haveno.desktop.components.InfoTextField;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.PasswordTextField;
import haveno.desktop.components.SimpleMarkdownLabel;
import haveno.desktop.components.TextFieldWithCopyIcon;
import haveno.desktop.components.TextFieldWithIcon;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.components.TxIdTextField;
import haveno.desktop.util.GUIUtil;
import java.util.concurrent.CopyOnWriteArraySet;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.jetbrains.annotations.NotNull;

public class FormBuilder {
    private static final String MATERIAL_DESIGN_ICONS = "'Material Design Icons'";

    public static TitledGroupBg addTitledGroupBg(GridPane gridPane, int rowIndex, int rowSpan, String title) {
        return FormBuilder.addTitledGroupBg(gridPane, rowIndex, rowSpan, title, 0.0);
    }

    public static TitledGroupBg addTitledGroupBg(GridPane gridPane, int rowIndex, int columnIndex, int rowSpan, String title) {
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg(gridPane, rowIndex, rowSpan, title, 0.0);
        GridPane.setColumnIndex((Node)titledGroupBg, (Integer)columnIndex);
        return titledGroupBg;
    }

    public static TitledGroupBg addTitledGroupBg(GridPane gridPane, int rowIndex, int columnIndex, int rowSpan, String title, double top) {
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg(gridPane, rowIndex, rowSpan, title, top);
        GridPane.setColumnIndex((Node)titledGroupBg, (Integer)columnIndex);
        return titledGroupBg;
    }

    public static TitledGroupBg addTitledGroupBg(GridPane gridPane, int rowIndex, int rowSpan, String title, double top) {
        TitledGroupBg titledGroupBg = new TitledGroupBg();
        titledGroupBg.setText(title);
        titledGroupBg.prefWidthProperty().bind((ObservableValue)gridPane.widthProperty());
        GridPane.setRowIndex((Node)titledGroupBg, (Integer)rowIndex);
        GridPane.setRowSpan((Node)titledGroupBg, (Integer)rowSpan);
        GridPane.setMargin((Node)titledGroupBg, (Insets)new Insets(top + 8.0, -10.0, -12.0, -10.0));
        gridPane.getChildren().add((Object)titledGroupBg);
        return titledGroupBg;
    }

    public static Region addSeparator(GridPane gridPane, int rowIndex) {
        Region separator = new Region();
        separator.getStyleClass().add((Object)"grid-pane-separator");
        separator.setPrefHeight(1.0);
        separator.setMinHeight(1.0);
        separator.setMaxHeight(1.0);
        GridPane.setRowIndex((Node)separator, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)separator, (Integer)0);
        GridPane.setColumnSpan((Node)separator, (Integer)2);
        gridPane.getChildren().add((Object)separator);
        separator.setPrefHeight(1.0);
        GridPane.setMargin((Node)separator, (Insets)new Insets(0.0, 0.0, 3.0, 0.0));
        return separator;
    }

    public static Label addLabel(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addLabel(gridPane, rowIndex, title, 0.0);
    }

    public static Label addLabel(GridPane gridPane, int rowIndex, String title, double top) {
        AutoTooltipLabel label = new AutoTooltipLabel(title);
        GridPane.setRowIndex((Node)label, (Integer)rowIndex);
        GridPane.setMargin((Node)label, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)label);
        return label;
    }

    public static Tuple3<Label, Label, VBox> addLabelWithSubText(GridPane gridPane, int rowIndex, String title, String description) {
        return FormBuilder.addLabelWithSubText(gridPane, rowIndex, title, description, 0.0);
    }

    public static Tuple3<Label, Label, VBox> addLabelWithSubText(GridPane gridPane, int rowIndex, String title, String description, double top) {
        AutoTooltipLabel label = new AutoTooltipLabel(title);
        AutoTooltipLabel subText = new AutoTooltipLabel(description);
        VBox vBox = new VBox();
        vBox.getChildren().setAll((Object[])new Node[]{label, subText});
        GridPane.setRowIndex((Node)vBox, (Integer)rowIndex);
        GridPane.setMargin((Node)vBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)vBox);
        return new Tuple3((Object)label, (Object)subText, (Object)vBox);
    }

    public static SimpleMarkdownLabel addSimpleMarkdownLabel(GridPane gridPane, int rowIndex) {
        return FormBuilder.addSimpleMarkdownLabel(gridPane, rowIndex, null, 0.0);
    }

    public static SimpleMarkdownLabel addSimpleMarkdownLabel(GridPane gridPane, int rowIndex, String markdown, double top) {
        SimpleMarkdownLabel label = new SimpleMarkdownLabel(markdown);
        GridPane.setRowIndex((Node)label, (Integer)rowIndex);
        GridPane.setMargin((Node)label, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)label);
        return label;
    }

    public static Label addMultilineLabel(GridPane gridPane, int rowIndex) {
        return FormBuilder.addMultilineLabel(gridPane, rowIndex, 0.0);
    }

    public static Label addMultilineLabel(GridPane gridPane, int rowIndex, String text) {
        return FormBuilder.addMultilineLabel(gridPane, rowIndex, text, 0.0);
    }

    public static Label addMultilineLabel(GridPane gridPane, int rowIndex, double top) {
        return FormBuilder.addMultilineLabel(gridPane, rowIndex, "", top);
    }

    public static Label addMultilineLabel(GridPane gridPane, int rowIndex, String text, double top) {
        return FormBuilder.addMultilineLabel(gridPane, rowIndex, text, top, 600.0);
    }

    public static Label addMultilineLabel(GridPane gridPane, int rowIndex, String text, double top, double maxWidth) {
        AutoTooltipLabel label = new AutoTooltipLabel(text);
        label.setWrapText(true);
        label.setMaxWidth(maxWidth);
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        GridPane.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        GridPane.setRowIndex((Node)label, (Integer)rowIndex);
        GridPane.setMargin((Node)label, (Insets)new Insets(top + 23.0, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)label);
        return label;
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelReadOnlyTextField(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, "", -15.0);
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelReadOnlyTextField(GridPane gridPane, int rowIndex, int columnIndex, String title) {
        Tuple3<Label, TextField, VBox> tuple = FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, "", -15.0);
        GridPane.setColumnIndex((Node)((Node)tuple.third), (Integer)columnIndex);
        return tuple;
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelReadOnlyTextField(GridPane gridPane, int rowIndex, String title, double top) {
        return FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, "", top - 15.0);
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelReadOnlyTextField(GridPane gridPane, int rowIndex, String title, String value) {
        return FormBuilder.addTopLabelReadOnlyTextField(gridPane, rowIndex, title, value, 0.0);
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelReadOnlyTextField(GridPane gridPane, int rowIndex, int columnIndex, String title, String value, double top) {
        Tuple3<Label, TextField, VBox> tuple = FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, value, top - 15.0);
        GridPane.setColumnIndex((Node)((Node)tuple.third), (Integer)columnIndex);
        return tuple;
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelReadOnlyTextField(GridPane gridPane, int rowIndex, int columnIndex, String title, double top) {
        Tuple3<Label, TextField, VBox> tuple = FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, "", top - 15.0);
        GridPane.setColumnIndex((Node)((Node)tuple.third), (Integer)columnIndex);
        return tuple;
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelReadOnlyTextField(GridPane gridPane, int rowIndex, String title, String value, double top) {
        return FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, value, top - 15.0);
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelTextField(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, "", 0.0);
    }

    public static Tuple3<Label, TextField, VBox> addCompactTopLabelTextField(GridPane gridPane, int rowIndex, String title, String value) {
        return FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, value, -23.0);
    }

    public static Tuple3<Label, TextField, VBox> addCompactTopLabelTextField(GridPane gridPane, int rowIndex, int colIndex, String title, String value) {
        Tuple3<Label, TextField, VBox> labelTextFieldVBoxTuple3 = FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, value, -23.0);
        GridPane.setColumnIndex((Node)((Node)labelTextFieldVBoxTuple3.third), (Integer)colIndex);
        return labelTextFieldVBoxTuple3;
    }

    public static Tuple3<Label, TextField, VBox> addCompactTopLabelTextField(GridPane gridPane, int rowIndex, String title, String value, double top) {
        return FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, value, top - 23.0);
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelTextField(GridPane gridPane, int rowIndex, String title, String value) {
        return FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, value, 0.0);
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelTextField(GridPane gridPane, int rowIndex, String title, double top) {
        return FormBuilder.addTopLabelTextField(gridPane, rowIndex, title, "", top);
    }

    public static Tuple3<Label, TextField, VBox> addTopLabelTextField(GridPane gridPane, int rowIndex, String title, String value, double top) {
        HavenoTextField textField = new HavenoTextField(value);
        textField.setEditable(false);
        textField.setFocusTraversable(false);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)textField, top);
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)textField, (Object)((VBox)topLabelWithVBox.second));
    }

    public static Tuple2<TextField, Button> addTextFieldWithEditButton(GridPane gridPane, int rowIndex, String title) {
        HavenoTextField textField = new HavenoTextField();
        textField.setPromptText(title);
        textField.setEditable(false);
        textField.setFocusTraversable(false);
        textField.setPrefWidth(1200.0);
        AutoTooltipButton button = new AutoTooltipButton("...");
        button.setStyle("-fx-min-width: 32; -fx-padding: 0 0 10 0; -fx-background-color: -fx-background;");
        button.managedProperty().bind((ObservableValue)button.visibleProperty());
        HBox hbox = new HBox(new Node[]{textField, button});
        hbox.setAlignment(Pos.CENTER_LEFT);
        hbox.setSpacing(8.0);
        VBox vbox = FormBuilder.getTopLabelVBox(0);
        vbox.setSpacing(2.0);
        vbox.getChildren().addAll((Object[])new Node[]{FormBuilder.getTopLabel(title), hbox});
        gridPane.getChildren().add((Object)vbox);
        GridPane.setRowIndex((Node)vbox, (Integer)rowIndex);
        GridPane.setMargin((Node)vbox, (Insets)new Insets(23.0, 0.0, 0.0, 0.0));
        return new Tuple2((Object)textField, (Object)button);
    }

    public static Tuple2<Label, Label> addConfirmationLabelLabel(GridPane gridPane, int rowIndex, String title1, String title2, double top) {
        return FormBuilder.addConfirmationLabelLabel(gridPane, false, rowIndex, title1, title2, top);
    }

    public static Tuple2<Label, Label> addConfirmationLabelLabel(GridPane gridPane, int rowIndex, String title1, String title2) {
        return FormBuilder.addConfirmationLabelLabel(gridPane, false, rowIndex, title1, title2, 0.0);
    }

    public static Tuple2<Label, Label> addConfirmationLabelLabel(GridPane gridPane, boolean isWrapped, int rowIndex, String title1, String title2) {
        return FormBuilder.addConfirmationLabelLabel(gridPane, isWrapped, rowIndex, title1, title2, 0.0);
    }

    public static Tuple2<Label, Label> addConfirmationLabelLabel(GridPane gridPane, boolean isWrapped, int rowIndex, String title1, String title2, double top) {
        Label label1 = FormBuilder.addLabel(gridPane, rowIndex, title1);
        label1.getStyleClass().add((Object)"confirmation-label");
        Label label2 = FormBuilder.addLabel(gridPane, rowIndex, title2);
        label2.getStyleClass().add((Object)"confirmation-value");
        label2.setWrapText(isWrapped);
        GridPane.setColumnIndex((Node)label2, (Integer)1);
        GridPane.setMargin((Node)label1, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        GridPane.setHalignment((Node)label1, (HPos)HPos.LEFT);
        GridPane.setValignment((Node)label1, (VPos)VPos.TOP);
        GridPane.setMargin((Node)label2, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        GridPane.setHalignment((Node)label2, (HPos)HPos.LEFT);
        GridPane.setValignment((Node)label2, (VPos)VPos.TOP);
        return new Tuple2((Object)label1, (Object)label2);
    }

    public static Tuple2<Label, TextField> addConfirmationLabelTextField(GridPane gridPane, int rowIndex, String title1, String title2) {
        return FormBuilder.addConfirmationLabelTextField(gridPane, rowIndex, title1, title2, 0.0);
    }

    public static Tuple2<Label, TextField> addConfirmationLabelTextField(GridPane gridPane, int rowIndex, String title1, String title2, double top) {
        Label label1 = FormBuilder.addLabel(gridPane, rowIndex, title1);
        label1.getStyleClass().add((Object)"confirmation-label");
        HavenoTextField label2 = new HavenoTextField(title2);
        gridPane.getChildren().add((Object)label2);
        label2.getStyleClass().add((Object)"confirmation-text-field-as-label");
        label2.setEditable(false);
        label2.setFocusTraversable(false);
        GridPane.setRowIndex((Node)label2, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)label2, (Integer)1);
        GridPane.setMargin((Node)label1, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        GridPane.setHalignment((Node)label1, (HPos)HPos.LEFT);
        GridPane.setMargin((Node)label2, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        return new Tuple2((Object)label1, (Object)label2);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addConfirmationLabelLabelWithCopyIcon(GridPane gridPane, int rowIndex, String title1, String title2) {
        Label label1 = FormBuilder.addLabel(gridPane, rowIndex, title1);
        label1.getStyleClass().add((Object)"confirmation-label");
        TextFieldWithCopyIcon label2 = new TextFieldWithCopyIcon("confirmation-value");
        label2.setText(title2);
        GridPane.setRowIndex((Node)label2, (Integer)rowIndex);
        gridPane.getChildren().add((Object)label2);
        GridPane.setColumnIndex((Node)label2, (Integer)1);
        GridPane.setHalignment((Node)label1, (HPos)HPos.LEFT);
        return new Tuple2((Object)label1, (Object)label2);
    }

    public static Tuple2<Label, TextArea> addConfirmationLabelTextArea(GridPane gridPane, int rowIndex, String title1, String title2, double top) {
        return FormBuilder.addConfirmationLabelTextArea(gridPane, false, rowIndex, title1, title2, top);
    }

    public static Tuple2<Label, TextArea> addConfirmationLabelTextArea(GridPane gridPane, boolean isWrapped, int rowIndex, String title1, String title2, double top) {
        Label label = FormBuilder.addLabel(gridPane, rowIndex, title1);
        label.getStyleClass().add((Object)"confirmation-label");
        TextArea textArea = FormBuilder.addTextArea(gridPane, rowIndex, title2);
        ((JFXTextArea)textArea).setLabelFloat(false);
        textArea.setWrapText(isWrapped);
        GridPane.setColumnIndex((Node)textArea, (Integer)1);
        GridPane.setMargin((Node)label, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        GridPane.setValignment((Node)label, (VPos)VPos.TOP);
        GridPane.setMargin((Node)textArea, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        return new Tuple2((Object)label, (Object)textArea);
    }

    public static Tuple2<Label, TextFieldWithIcon> addTopLabelTextFieldWithIcon(GridPane gridPane, int rowIndex, String title, double top) {
        return FormBuilder.addTopLabelTextFieldWithIcon(gridPane, rowIndex, 0, title, top);
    }

    public static Tuple2<Label, TextFieldWithIcon> addTopLabelTextFieldWithIcon(GridPane gridPane, int rowIndex, int columnIndex, String title, double top) {
        TextFieldWithIcon textFieldWithIcon = new TextFieldWithIcon();
        textFieldWithIcon.setFocusTraversable(false);
        return new Tuple2((Object)((Label)FormBuilder.addTopLabelWithVBox((GridPane)gridPane, (int)rowIndex, (int)columnIndex, (String)title, (Node)textFieldWithIcon, (double)top).first), (Object)textFieldWithIcon);
    }

    public static HyperlinkWithIcon addHyperlinkWithIcon(GridPane gridPane, int rowIndex, String title, String url) {
        return FormBuilder.addHyperlinkWithIcon(gridPane, rowIndex, title, url, 0.0);
    }

    public static HyperlinkWithIcon addHyperlinkWithIcon(GridPane gridPane, int rowIndex, String title, String url, double top) {
        ExternalHyperlink hyperlinkWithIcon = new ExternalHyperlink(title);
        hyperlinkWithIcon.setOnAction(e -> GUIUtil.openWebPage(url));
        GridPane.setRowIndex((Node)hyperlinkWithIcon, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)hyperlinkWithIcon, (Integer)0);
        GridPane.setMargin((Node)hyperlinkWithIcon, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        GridPane.setHalignment((Node)hyperlinkWithIcon, (HPos)HPos.LEFT);
        gridPane.getChildren().add((Object)hyperlinkWithIcon);
        return hyperlinkWithIcon;
    }

    public static Tuple2<Label, HyperlinkWithIcon> addLabelHyperlinkWithIcon(GridPane gridPane, int rowIndex, String labelTitle, String title, String url) {
        return FormBuilder.addLabelHyperlinkWithIcon(gridPane, rowIndex, labelTitle, title, url, 0.0);
    }

    public static Tuple2<Label, HyperlinkWithIcon> addLabelHyperlinkWithIcon(GridPane gridPane, int rowIndex, String labelTitle, String title, String url, double top) {
        Label label = FormBuilder.addLabel(gridPane, rowIndex, labelTitle, top);
        ExternalHyperlink hyperlinkWithIcon = new ExternalHyperlink(title);
        hyperlinkWithIcon.setOnAction(e -> GUIUtil.openWebPage(url));
        GridPane.setRowIndex((Node)hyperlinkWithIcon, (Integer)rowIndex);
        GridPane.setMargin((Node)hyperlinkWithIcon, (Insets)new Insets(top, 0.0, 0.0, -4.0));
        gridPane.getChildren().add((Object)hyperlinkWithIcon);
        return new Tuple2((Object)label, (Object)hyperlinkWithIcon);
    }

    public static Tuple3<Label, HyperlinkWithIcon, VBox> addTopLabelHyperlinkWithIcon(GridPane gridPane, int rowIndex, int columnIndex, String title, String value, String url, double top) {
        Tuple3<Label, HyperlinkWithIcon, VBox> tuple = FormBuilder.addTopLabelHyperlinkWithIcon(gridPane, rowIndex, title, value, url, top);
        GridPane.setColumnIndex((Node)((Node)tuple.third), (Integer)columnIndex);
        return tuple;
    }

    public static Tuple3<Label, HyperlinkWithIcon, VBox> addTopLabelHyperlinkWithIcon(GridPane gridPane, int rowIndex, String title, String value, String url, double top) {
        ExternalHyperlink hyperlinkWithIcon = new ExternalHyperlink(value);
        hyperlinkWithIcon.setOnAction(e -> GUIUtil.openWebPage(url));
        hyperlinkWithIcon.getStyleClass().add((Object)"hyperlink-with-icon");
        GridPane.setRowIndex((Node)hyperlinkWithIcon, (Integer)rowIndex);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)hyperlinkWithIcon, top - 15.0);
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)hyperlinkWithIcon, (Object)((VBox)topLabelWithVBox.second));
    }

    public static TextArea addTextArea(GridPane gridPane, int rowIndex, String prompt) {
        return FormBuilder.addTextArea(gridPane, rowIndex, prompt, 0.0);
    }

    public static TextArea addTextArea(GridPane gridPane, int rowIndex, String prompt, double top) {
        HavenoTextArea textArea = new HavenoTextArea();
        textArea.setPromptText(prompt);
        textArea.setLabelFloat(true);
        textArea.getStyleClass().add((Object)"label-float");
        textArea.setWrapText(true);
        GridPane.setRowIndex((Node)textArea, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)textArea, (Integer)0);
        GridPane.setMargin((Node)textArea, (Insets)new Insets(top + 23.0, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)textArea);
        return textArea;
    }

    public static Tuple2<Label, TextArea> addCompactTopLabelTextArea(GridPane gridPane, int rowIndex, String title, String prompt) {
        return FormBuilder.addTopLabelTextArea(gridPane, rowIndex, title, prompt, -23.0);
    }

    public static Tuple2<Label, TextArea> addCompactTopLabelTextArea(GridPane gridPane, int rowIndex, int colIndex, String title, String prompt) {
        return FormBuilder.addTopLabelTextArea(gridPane, rowIndex, colIndex, title, prompt, -23.0);
    }

    public static Tuple2<Label, TextArea> addTopLabelTextArea(GridPane gridPane, int rowIndex, String title, String prompt) {
        return FormBuilder.addTopLabelTextArea(gridPane, rowIndex, title, prompt, 0.0);
    }

    public static Tuple2<Label, TextArea> addTopLabelTextArea(GridPane gridPane, int rowIndex, int colIndex, String title, String prompt) {
        return FormBuilder.addTopLabelTextArea(gridPane, rowIndex, colIndex, title, prompt, 0.0);
    }

    public static Tuple2<Label, TextArea> addTopLabelTextArea(GridPane gridPane, int rowIndex, String title, String prompt, double top) {
        return FormBuilder.addTopLabelTextArea(gridPane, rowIndex, 0, title, prompt, top);
    }

    public static Tuple2<Label, TextArea> addTopLabelTextArea(GridPane gridPane, int rowIndex, int colIndex, String title, String prompt, double top) {
        HavenoTextArea textArea = new HavenoTextArea();
        textArea.setPromptText(prompt);
        textArea.setWrapText(true);
        textArea.setPrefHeight(100.0);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)textArea, top);
        GridPane.setColumnIndex((Node)((Node)topLabelWithVBox.second), (Integer)colIndex);
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)textArea);
    }

    public static Tuple2<Label, DatePicker> addTopLabelDatePicker(GridPane gridPane, int rowIndex, String title, double top) {
        return FormBuilder.addTopLabelDatePicker(gridPane, rowIndex, 0, title, top);
    }

    public static Tuple2<Label, DatePicker> addTopLabelDatePicker(GridPane gridPane, int rowIndex, int columnIndex, String title, double top) {
        DatePicker datePicker = new DatePicker();
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, columnIndex, title, (Node)datePicker, top);
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)datePicker);
    }

    public static Tuple2<DatePicker, DatePicker> add2TopLabelDatePicker(GridPane gridPane, int rowIndex, int columnIndex, String title1, String title2, double top) {
        DatePicker datePicker1 = new DatePicker();
        Tuple2<Label, VBox> topLabelWithVBox1 = FormBuilder.getTopLabelWithVBox(title1, (Node)datePicker1);
        VBox vBox1 = (VBox)topLabelWithVBox1.second;
        DatePicker datePicker2 = new DatePicker();
        Tuple2<Label, VBox> topLabelWithVBox2 = FormBuilder.getTopLabelWithVBox(title2, (Node)datePicker2);
        VBox vBox2 = (VBox)topLabelWithVBox2.second;
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{spacer, vBox1, vBox2});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)hBox, (Integer)columnIndex);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple2((Object)datePicker1, (Object)datePicker2);
    }

    public static Tuple2<Label, TxIdTextField> addLabelTxIdTextField(GridPane gridPane, int rowIndex, String title, String value) {
        return FormBuilder.addLabelTxIdTextField(gridPane, rowIndex, title, value, 0.0);
    }

    public static Tuple2<Label, TxIdTextField> addLabelTxIdTextField(GridPane gridPane, int rowIndex, String title, String value, double top) {
        Label label = FormBuilder.addLabel(gridPane, rowIndex, title, top);
        label.getStyleClass().add((Object)"confirmation-label");
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        TxIdTextField txTextField = new TxIdTextField();
        txTextField.setup(value);
        GridPane.setRowIndex((Node)txTextField, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)txTextField, (Integer)1);
        gridPane.getChildren().add((Object)txTextField);
        return new Tuple2((Object)label, (Object)txTextField);
    }

    public static void addLabelExplorerAddressTextField(GridPane gridPane, int rowIndex, String title, String address) {
        Label label = FormBuilder.addLabel(gridPane, rowIndex, title, 0.0);
        label.getStyleClass().add((Object)"confirmation-label");
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        ExplorerAddressTextField addressTextField = new ExplorerAddressTextField();
        addressTextField.setup(address);
        GridPane.setRowIndex((Node)addressTextField, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)addressTextField, (Integer)1);
        gridPane.getChildren().add((Object)addressTextField);
    }

    public static InputTextField addInputTextField(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addInputTextField(gridPane, rowIndex, title, 0.0);
    }

    public static InputTextField addInputTextField(GridPane gridPane, int rowIndex, String title, double top) {
        InputTextField inputTextField = new InputTextField();
        inputTextField.setLabelFloat(true);
        inputTextField.getStyleClass().add((Object)"label-float");
        inputTextField.setPromptText(title);
        GridPane.setRowIndex((Node)inputTextField, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)inputTextField, (Integer)0);
        GridPane.setMargin((Node)inputTextField, (Insets)new Insets(top + 23.0, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)inputTextField);
        return inputTextField;
    }

    public static Tuple2<Label, InputTextField> addTopLabelInputTextField(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addTopLabelInputTextField(gridPane, rowIndex, title, 0.0);
    }

    public static Tuple2<Label, InputTextField> addTopLabelInputTextField(GridPane gridPane, int rowIndex, String title, double top) {
        Tuple3<Label, InputTextField, VBox> topLabelWithVBox = FormBuilder.addTopLabelInputTextFieldWithVBox(gridPane, rowIndex, title, top);
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)((InputTextField)((Object)topLabelWithVBox.second)));
    }

    public static Tuple3<Label, InputTextField, VBox> addTopLabelInputTextFieldWithVBox(GridPane gridPane, int rowIndex, String title, double top) {
        InputTextField inputTextField = new InputTextField();
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)inputTextField, top);
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)inputTextField, (Object)((VBox)topLabelWithVBox.second));
    }

    public static Tuple2<Label, InfoInputTextField> addTopLabelInfoInputTextField(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addTopLabelInfoInputTextField(gridPane, rowIndex, title, 0.0);
    }

    public static Tuple2<Label, InfoInputTextField> addTopLabelInfoInputTextField(GridPane gridPane, int rowIndex, String title, double top) {
        InfoInputTextField inputTextField = new InfoInputTextField();
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)inputTextField, top);
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)inputTextField);
    }

    public static PasswordTextField addPasswordTextField(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addPasswordTextField(gridPane, rowIndex, title, 0.0);
    }

    public static PasswordTextField addPasswordTextField(GridPane gridPane, int rowIndex, String title, double top) {
        PasswordTextField passwordField = new PasswordTextField();
        passwordField.getStyleClass().addAll((Object[])new String[]{"label-float"});
        GUIUtil.applyFilledStyle((TextField)passwordField);
        passwordField.setPromptText(title);
        GridPane.setRowIndex((Node)passwordField, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)passwordField, (Integer)0);
        GridPane.setColumnSpan((Node)passwordField, (Integer)2);
        GridPane.setMargin((Node)passwordField, (Insets)new Insets(top + 10.0, 0.0, 20.0, 0.0));
        gridPane.getChildren().add((Object)passwordField);
        return passwordField;
    }

    public static Tuple3<Label, InputTextField, ToggleButton> addTopLabelInputTextFieldSlideToggleButton(GridPane gridPane, int rowIndex, String title, String toggleButtonTitle) {
        InputTextField inputTextField = new InputTextField();
        JFXToggleButton toggleButton = new JFXToggleButton();
        toggleButton.setText(toggleButtonTitle);
        VBox.setMargin((Node)toggleButton, (Insets)new Insets(4.0, 0.0, 0.0, 0.0));
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)inputTextField, 0.0);
        ((VBox)topLabelWithVBox.second).getChildren().add((Object)toggleButton);
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)inputTextField, (Object)toggleButton);
    }

    public static Tuple3<Label, InputTextField, ToggleButton> addTopLabelInputTextFieldSlideToggleButtonRight(GridPane gridPane, int rowIndex, String title, String toggleButtonTitle) {
        InputTextField inputTextField = new InputTextField();
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)inputTextField, 0.0);
        JFXToggleButton toggleButton = new JFXToggleButton();
        toggleButton.setText(toggleButtonTitle);
        HBox hBox = new HBox();
        hBox.getChildren().addAll((Object[])new Node[]{(Node)topLabelWithVBox.second, toggleButton});
        HBox.setMargin((Node)toggleButton, (Insets)new Insets(9.0, 0.0, 0.0, 0.0));
        gridPane.add((Node)hBox, 0, rowIndex);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(23.0, 0.0, 0.0, 0.0));
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)inputTextField, (Object)toggleButton);
    }

    public static Tuple3<Label, InputTextField, Button> addTopLabelInputTextFieldButton(GridPane gridPane, int rowIndex, String title, String buttonTitle) {
        InputTextField inputTextField = new InputTextField();
        AutoTooltipButton button = new AutoTooltipButton(buttonTitle);
        button.setDefaultButton(true);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{inputTextField, button});
        HBox.setHgrow((Node)inputTextField, (Priority)Priority.ALWAYS);
        Tuple2<Label, VBox> labelVBoxTuple2 = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)hBox, 0.0);
        return new Tuple3((Object)((Label)labelVBoxTuple2.first), (Object)inputTextField, (Object)button);
    }

    public static Tuple3<Label, TextField, Button> addTopLabelTextFieldButton(GridPane gridPane, int rowIndex, String title, String buttonTitle) {
        return FormBuilder.addTopLabelTextFieldButton(gridPane, rowIndex, title, buttonTitle, 0.0);
    }

    public static Tuple3<Label, TextField, Button> addTopLabelTextFieldButton(GridPane gridPane, int rowIndex, String title, String buttonTitle, double top) {
        HavenoTextField textField = new HavenoTextField();
        textField.setEditable(false);
        textField.setMouseTransparent(true);
        textField.setFocusTraversable(false);
        AutoTooltipButton button = new AutoTooltipButton(buttonTitle);
        button.setDefaultButton(true);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{textField, button});
        HBox.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
        Tuple2<Label, VBox> labelVBoxTuple2 = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)hBox, top);
        return new Tuple3((Object)((Label)labelVBoxTuple2.first), (Object)textField, (Object)button);
    }

    public static Tuple2<InputTextField, InputTextField> addInputTextFieldInputTextField(GridPane gridPane, int rowIndex, String title1, String title2) {
        InputTextField inputTextField1 = new InputTextField();
        inputTextField1.setPromptText(title1);
        inputTextField1.setLabelFloat(true);
        inputTextField1.getStyleClass().add((Object)"label-float");
        InputTextField inputTextField2 = new InputTextField();
        inputTextField2.setLabelFloat(true);
        inputTextField2.getStyleClass().add((Object)"label-float");
        inputTextField2.setPromptText(title2);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{inputTextField1, inputTextField2});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)hBox, (Integer)0);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(23.0, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple2((Object)inputTextField1, (Object)inputTextField2);
    }

    public static Tuple4<Label, TextField, Label, TextField> addCompactTopLabelTextFieldTopLabelTextField(GridPane gridPane, int rowIndex, String title1, String title2) {
        HavenoTextField textField1 = new HavenoTextField();
        textField1.setEditable(false);
        textField1.setMouseTransparent(true);
        textField1.setFocusTraversable(false);
        Tuple2<Label, VBox> topLabelWithVBox1 = FormBuilder.getTopLabelWithVBox(title1, (Node)textField1);
        HavenoTextField textField2 = new HavenoTextField();
        textField2.setEditable(false);
        textField2.setMouseTransparent(true);
        textField2.setFocusTraversable(false);
        Tuple2<Label, VBox> topLabelWithVBox2 = FormBuilder.getTopLabelWithVBox(title2, (Node)textField2);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{(Node)topLabelWithVBox1.second, (Node)topLabelWithVBox2.second});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        gridPane.getChildren().add((Object)hBox);
        return new Tuple4((Object)((Label)topLabelWithVBox1.first), (Object)textField1, (Object)((Label)topLabelWithVBox2.first), (Object)textField2);
    }

    public static Tuple2<Button, CheckBox> addButtonCheckBox(GridPane gridPane, int rowIndex, String buttonTitle, String checkBoxTitle) {
        return FormBuilder.addButtonCheckBox(gridPane, rowIndex, buttonTitle, checkBoxTitle, 0.0);
    }

    public static Tuple2<Button, CheckBox> addButtonCheckBox(GridPane gridPane, int rowIndex, String buttonTitle, String checkBoxTitle, double top) {
        Tuple3<Button, CheckBox, HBox> tuple = FormBuilder.addButtonCheckBoxWithBox(gridPane, rowIndex, buttonTitle, checkBoxTitle, top);
        return new Tuple2((Object)((Button)tuple.first), (Object)((CheckBox)tuple.second));
    }

    public static Tuple3<Button, CheckBox, HBox> addButtonCheckBoxWithBox(GridPane gridPane, int rowIndex, String buttonTitle, String checkBoxTitle, double top) {
        AutoTooltipButton button = new AutoTooltipButton(buttonTitle);
        AutoTooltipCheckBox checkBox = checkBoxTitle == null ? null : new AutoTooltipCheckBox(checkBoxTitle);
        HBox hBox = new HBox(20.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().add((Object)button);
        if (checkBox != null) {
            hBox.getChildren().add((Object)button);
        }
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        hBox.setPadding(new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple3((Object)button, (Object)checkBox, (Object)hBox);
    }

    public static CheckBox addCheckBox(GridPane gridPane, int rowIndex, String checkBoxTitle) {
        return FormBuilder.addCheckBox(gridPane, rowIndex, checkBoxTitle, 0.0);
    }

    public static CheckBox addCheckBox(GridPane gridPane, int rowIndex, String checkBoxTitle, double top) {
        return FormBuilder.addCheckBox(gridPane, rowIndex, 0, checkBoxTitle, top);
    }

    public static CheckBox addCheckBox(GridPane gridPane, int rowIndex, int colIndex, String checkBoxTitle, double top) {
        AutoTooltipCheckBox checkBox = new AutoTooltipCheckBox(checkBoxTitle);
        GridPane.setMargin((Node)checkBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        GridPane.setRowIndex((Node)checkBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)checkBox, (Integer)colIndex);
        gridPane.getChildren().add((Object)checkBox);
        return checkBox;
    }

    public static RadioButton addRadioButton(GridPane gridPane, int rowIndex, ToggleGroup toggleGroup, String title) {
        AutoTooltipRadioButton radioButton = new AutoTooltipRadioButton(title);
        radioButton.setToggleGroup(toggleGroup);
        GridPane.setRowIndex((Node)radioButton, (Integer)rowIndex);
        gridPane.getChildren().add((Object)radioButton);
        return radioButton;
    }

    public static Tuple3<Label, RadioButton, RadioButton> addTopLabelRadioButtonRadioButton(GridPane gridPane, int rowIndex, ToggleGroup toggleGroup, String title, String radioButtonTitle1, String radioButtonTitle2, double top) {
        AutoTooltipRadioButton radioButton1 = new AutoTooltipRadioButton(radioButtonTitle1);
        radioButton1.setToggleGroup(toggleGroup);
        radioButton1.setPadding(new Insets(6.0, 0.0, 0.0, 0.0));
        AutoTooltipRadioButton radioButton2 = new AutoTooltipRadioButton(radioButtonTitle2);
        radioButton2.setToggleGroup(toggleGroup);
        radioButton2.setPadding(new Insets(6.0, 0.0, 0.0, 0.0));
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{radioButton1, radioButton2});
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)hBox, top);
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)radioButton1, (Object)radioButton2);
    }

    public static Tuple3<Label, TextField, HyperlinkWithIcon> addTopLabelTextFieldHyperLink(GridPane gridPane, int rowIndex, String title, String textFieldTitle, String maxButtonTitle, double top) {
        HavenoTextField textField = new HavenoTextField();
        textField.setPromptText(textFieldTitle);
        ExternalHyperlink maxLink = new ExternalHyperlink(maxButtonTitle);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{textField, maxLink});
        hBox.setAlignment(Pos.CENTER_LEFT);
        Tuple2<Label, VBox> labelVBoxTuple2 = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)hBox, top);
        return new Tuple3((Object)((Label)labelVBoxTuple2.first), (Object)textField, (Object)maxLink);
    }

    public static CheckBox addLabelCheckBox(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addLabelCheckBox(gridPane, rowIndex, title, 0.0);
    }

    public static CheckBox addLabelCheckBox(GridPane gridPane, int rowIndex, String title, double top) {
        AutoTooltipCheckBox checkBox = new AutoTooltipCheckBox(title);
        GridPane.setRowIndex((Node)checkBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)checkBox, (Integer)0);
        GridPane.setMargin((Node)checkBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)checkBox);
        return checkBox;
    }

    public static ToggleButton addSlideToggleButton(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addSlideToggleButton(gridPane, rowIndex, title, 0.0);
    }

    public static ToggleButton addSlideToggleButton(GridPane gridPane, int rowIndex, String title, double top) {
        AutoTooltipSlideToggleButton toggleButton = new AutoTooltipSlideToggleButton();
        toggleButton.setText(title);
        GridPane.setRowIndex((Node)toggleButton, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)toggleButton, (Integer)0);
        GridPane.setMargin((Node)toggleButton, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)toggleButton);
        return toggleButton;
    }

    public static <T> ComboBox<T> addComboBox(GridPane gridPane, int rowIndex, int top) {
        JFXComboBox comboBox = new JFXComboBox();
        GUIUtil.applyFilledStyle(comboBox);
        GridPane.setRowIndex((Node)comboBox, (Integer)rowIndex);
        GridPane.setMargin((Node)comboBox, (Insets)new Insets((double)top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)comboBox);
        return comboBox;
    }

    public static <T> Tuple2<Label, ComboBox<T>> addTopLabelComboBox(GridPane gridPane, int rowIndex, String title, String prompt, int top) {
        Tuple3<VBox, Label, ComboBox<T>> tuple3 = FormBuilder.addTopLabelComboBox(title, prompt, 0);
        VBox vBox = (VBox)tuple3.first;
        GridPane.setRowIndex((Node)vBox, (Integer)rowIndex);
        GridPane.setMargin((Node)vBox, (Insets)new Insets((double)top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)vBox);
        return new Tuple2((Object)((Label)tuple3.second), (Object)((ComboBox)tuple3.third));
    }

    public static <T> Tuple3<VBox, Label, ComboBox<T>> addTopLabelComboBox(String title, String prompt) {
        return FormBuilder.addTopLabelComboBox(title, prompt, 0);
    }

    public static <T> Tuple3<VBox, Label, ComboBox<T>> addTopLabelComboBox(String title, String prompt, int top) {
        Label label = FormBuilder.getTopLabel(title);
        VBox vBox = FormBuilder.getTopLabelVBox(top);
        JFXComboBox comboBox = new JFXComboBox();
        GUIUtil.applyFilledStyle(comboBox);
        comboBox.setPromptText(prompt);
        comboBox.setPadding(new Insets((double)top, 0.0, 0.0, 12.0));
        vBox.getChildren().addAll((Object[])new Node[]{label, comboBox});
        return new Tuple3((Object)vBox, (Object)label, (Object)comboBox);
    }

    public static <T> Tuple3<VBox, Label, AutocompleteComboBox<T>> addTopLabelAutocompleteComboBox(String title) {
        return FormBuilder.addTopLabelAutocompleteComboBox(title, 0);
    }

    public static <T> Tuple3<VBox, Label, AutocompleteComboBox<T>> addTopLabelAutocompleteComboBox(String title, int top) {
        Label label = FormBuilder.getTopLabel(title);
        VBox vBox = FormBuilder.getTopLabelVBox(top);
        AutocompleteComboBox comboBox = new AutocompleteComboBox();
        vBox.getChildren().addAll((Object[])new Node[]{label, comboBox});
        return new Tuple3((Object)vBox, (Object)label, comboBox);
    }

    public static Tuple3<VBox, Label, AutoTooltipTextField> addTopLabelAutoToolTipTextField(String title) {
        return FormBuilder.addTopLabelAutoToolTipTextField(title, 0);
    }

    public static Tuple3<VBox, Label, AutoTooltipTextField> addTopLabelAutoToolTipTextField(String title, int top) {
        Label label = FormBuilder.getTopLabel(title);
        VBox vBox = FormBuilder.getTopLabelVBox(top);
        AutoTooltipTextField textField = new AutoTooltipTextField();
        vBox.getChildren().addAll((Object[])new Node[]{label, textField});
        return new Tuple3((Object)vBox, (Object)label, (Object)textField);
    }

    @NotNull
    private static VBox getTopLabelVBox(int top) {
        VBox vBox = new VBox();
        vBox.setSpacing(0.0);
        vBox.setPadding(new Insets((double)top, 0.0, 0.0, 0.0));
        vBox.setAlignment(Pos.CENTER_LEFT);
        return vBox;
    }

    @NotNull
    private static Label getTopLabel(String title) {
        AutoTooltipLabel label = new AutoTooltipLabel(title);
        label.getStyleClass().add((Object)"small-text");
        return label;
    }

    public static Tuple2<Label, VBox> addTopLabelWithVBox(GridPane gridPane, int rowIndex, String title, Node node, double top) {
        return FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, 0, title, node, top);
    }

    @NotNull
    public static Tuple2<Label, VBox> addTopLabelWithVBox(GridPane gridPane, int rowIndex, int columnIndex, String title, Node node, double top) {
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.getTopLabelWithVBox(title, node);
        VBox vBox = (VBox)topLabelWithVBox.second;
        GridPane.setRowIndex((Node)vBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)vBox, (Integer)columnIndex);
        GridPane.setMargin((Node)vBox, (Insets)new Insets(top + 23.0, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)vBox);
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)vBox);
    }

    @NotNull
    public static Tuple2<Label, VBox> getTopLabelWithVBox(String title, Node node) {
        Label label = FormBuilder.getTopLabel(title);
        VBox vBox = FormBuilder.getTopLabelVBox(0);
        vBox.getChildren().addAll((Object[])new Node[]{label, node});
        return new Tuple2((Object)label, (Object)vBox);
    }

    public static Tuple3<Label, TextField, HBox> addTopLabelTextFieldWithHbox(GridPane gridPane, int rowIndex, String titleTextfield, double top) {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        HavenoTextField textField = new HavenoTextField();
        VBox topLabelVBox = FormBuilder.getTopLabelVBox(5);
        Label topLabel = FormBuilder.getTopLabel(titleTextfield);
        topLabelVBox.getChildren().addAll((Object[])new Node[]{topLabel, textField});
        hBox.getChildren().addAll((Object[])new Node[]{topLabelVBox});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple3((Object)topLabel, (Object)textField, (Object)hBox);
    }

    public static <T> ComboBox<T> addComboBox(GridPane gridPane, int rowIndex) {
        return FormBuilder.addComboBox(gridPane, rowIndex, null, 0.0);
    }

    public static <T> ComboBox<T> addComboBox(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addComboBox(gridPane, rowIndex, title, 0.0);
    }

    public static <T> ComboBox<T> addComboBox(GridPane gridPane, int rowIndex, String title, double top) {
        JFXComboBox comboBox = new JFXComboBox();
        GUIUtil.applyFilledStyle(comboBox);
        comboBox.setLabelFloat(true);
        comboBox.getStyleClass().add((Object)"label-float");
        comboBox.setPromptText(title);
        comboBox.setMaxWidth(Double.MAX_VALUE);
        comboBox.setButtonCell(GUIUtil.getComboBoxButtonCell(title, comboBox));
        GridPane.setRowIndex((Node)comboBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)comboBox, (Integer)0);
        comboBox.setPadding(new Insets(0.0, 0.0, 0.0, 12.0));
        GridPane.setMargin((Node)comboBox, (Insets)new Insets(top + 23.0, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)comboBox);
        return comboBox;
    }

    public static <T> AutocompleteComboBox<T> addAutocompleteComboBox(GridPane gridPane, int rowIndex, String title, double top) {
        AutocompleteComboBox comboBox = new AutocompleteComboBox();
        GUIUtil.applyFilledStyle(comboBox);
        comboBox.setLabelFloat(true);
        comboBox.getStyleClass().add((Object)"label-float");
        comboBox.setPromptText(title);
        comboBox.setMaxWidth(Double.MAX_VALUE);
        comboBox.setButtonCell(GUIUtil.getComboBoxButtonCell(title, comboBox));
        GridPane.setRowIndex(comboBox, (Integer)rowIndex);
        GridPane.setColumnIndex(comboBox, (Integer)0);
        GridPane.setMargin(comboBox, (Insets)new Insets(top + 23.0, 0.0, 0.0, 0.0));
        gridPane.getChildren().add(comboBox);
        return comboBox;
    }

    public static <T> Tuple2<Label, ComboBox<T>> addLabelAutocompleteComboBox(GridPane gridPane, int rowIndex, String title, double top) {
        AutocompleteComboBox comboBox = new AutocompleteComboBox();
        Tuple2<Label, VBox> labelVBoxTuple2 = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, comboBox, top);
        return new Tuple2((Object)((Label)labelVBoxTuple2.first), comboBox);
    }

    public static <T> Tuple4<Label, TextField, Label, ComboBox<T>> addTopLabelTextFieldAutocompleteComboBox(GridPane gridPane, int rowIndex, String titleTextfield, String titleCombobox) {
        return FormBuilder.addTopLabelTextFieldAutocompleteComboBox(gridPane, rowIndex, titleTextfield, titleCombobox, 0.0);
    }

    public static <T> Tuple4<Label, TextField, Label, ComboBox<T>> addTopLabelTextFieldAutocompleteComboBox(GridPane gridPane, int rowIndex, String titleTextfield, String titleCombobox, double top) {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        VBox topLabelVBox1 = FormBuilder.getTopLabelVBox(5);
        Label topLabel1 = FormBuilder.getTopLabel(titleTextfield);
        HavenoTextField textField = new HavenoTextField();
        topLabelVBox1.getChildren().addAll((Object[])new Node[]{topLabel1, textField});
        VBox topLabelVBox2 = FormBuilder.getTopLabelVBox(5);
        Label topLabel2 = FormBuilder.getTopLabel(titleCombobox);
        AutocompleteComboBox comboBox = new AutocompleteComboBox();
        comboBox.setPromptText(titleCombobox);
        comboBox.setLabelFloat(true);
        comboBox.getStyleClass().add((Object)"label-float");
        topLabelVBox2.getChildren().addAll((Object[])new Node[]{topLabel2, comboBox});
        hBox.getChildren().addAll((Object[])new Node[]{topLabelVBox1, topLabelVBox2});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple4((Object)topLabel1, (Object)textField, (Object)topLabel2, comboBox);
    }

    public static <T, R> Tuple3<Label, ComboBox<R>, ComboBox<T>> addTopLabelComboBoxComboBox(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addTopLabelComboBoxComboBox(gridPane, rowIndex, title, 0.0);
    }

    public static <T, R> Tuple3<Label, ComboBox<T>, ComboBox<R>> addTopLabelComboBoxComboBox(GridPane gridPane, int rowIndex, String title, double top) {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        JFXComboBox comboBox1 = new JFXComboBox();
        GUIUtil.applyFilledStyle(comboBox1);
        JFXComboBox comboBox2 = new JFXComboBox();
        GUIUtil.applyFilledStyle(comboBox2);
        hBox.getChildren().addAll((Object[])new Node[]{comboBox1, comboBox2});
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)hBox, top);
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)comboBox1, (Object)comboBox2);
    }

    public static <T> Tuple4<ComboBox<T>, Label, TextField, HBox> addComboBoxTopLabelTextField(GridPane gridPane, int rowIndex, String titleCombobox, String titleTextfield) {
        return FormBuilder.addComboBoxTopLabelTextField(gridPane, rowIndex, titleCombobox, titleTextfield, 0.0);
    }

    public static <T> Tuple4<ComboBox<T>, Label, TextField, HBox> addComboBoxTopLabelTextField(GridPane gridPane, int rowIndex, String titleCombobox, String titleTextfield, double top) {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        JFXComboBox comboBox = new JFXComboBox();
        GUIUtil.applyFilledStyle(comboBox);
        comboBox.setPromptText(titleCombobox);
        comboBox.setLabelFloat(true);
        comboBox.getStyleClass().add((Object)"label-float");
        HavenoTextField textField = new HavenoTextField();
        VBox topLabelVBox = FormBuilder.getTopLabelVBox(5);
        Label topLabel = FormBuilder.getTopLabel(titleTextfield);
        topLabelVBox.getChildren().addAll((Object[])new Node[]{topLabel, textField});
        hBox.getChildren().addAll((Object[])new Node[]{comboBox, topLabelVBox});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple4((Object)comboBox, (Object)topLabel, (Object)textField, (Object)hBox);
    }

    public static <T> Tuple3<Label, ComboBox<T>, Button> addLabelComboBoxButton(GridPane gridPane, int rowIndex, String title, String buttonTitle) {
        return FormBuilder.addLabelComboBoxButton(gridPane, rowIndex, title, buttonTitle, 0.0);
    }

    public static <T> Tuple3<Label, ComboBox<T>, Button> addLabelComboBoxButton(GridPane gridPane, int rowIndex, String title, String buttonTitle, double top) {
        Label label = FormBuilder.addLabel(gridPane, rowIndex, title, top);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        AutoTooltipButton button = new AutoTooltipButton(buttonTitle);
        button.setDefaultButton(true);
        JFXComboBox comboBox = new JFXComboBox();
        GUIUtil.applyFilledStyle(comboBox);
        hBox.getChildren().addAll((Object[])new Node[]{comboBox, button});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)hBox, (Integer)1);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple3((Object)label, (Object)comboBox, (Object)button);
    }

    public static <T> Tuple3<Label, ComboBox<T>, TextField> addLabelComboBoxLabel(GridPane gridPane, int rowIndex, String title, String textFieldText) {
        return FormBuilder.addLabelComboBoxLabel(gridPane, rowIndex, title, textFieldText, 0.0);
    }

    public static <T> Tuple3<Label, ComboBox<T>, TextField> addLabelComboBoxLabel(GridPane gridPane, int rowIndex, String title, String textFieldText, double top) {
        Label label = FormBuilder.addLabel(gridPane, rowIndex, title, top);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        JFXComboBox comboBox = new JFXComboBox();
        GUIUtil.applyFilledStyle(comboBox);
        TextField textField = new TextField(textFieldText);
        textField.setEditable(false);
        textField.setMouseTransparent(true);
        textField.setFocusTraversable(false);
        hBox.getChildren().addAll((Object[])new Node[]{comboBox, textField});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)hBox, (Integer)1);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple3((Object)label, (Object)comboBox, (Object)textField);
    }

    public static Tuple2<Label, TxIdTextField> addLabelTxIdTextField(GridPane gridPane, int rowIndex, int columnIndex, String title) {
        return FormBuilder.addLabelTxIdTextField(gridPane, rowIndex, columnIndex, title, 0.0);
    }

    public static Tuple2<Label, TxIdTextField> addLabelTxIdTextField(GridPane gridPane, int rowIndex, int columnIndex, String title, double top) {
        Label label = FormBuilder.addLabel(gridPane, rowIndex, title, top);
        TxIdTextField txIdTextField = new TxIdTextField();
        GridPane.setRowIndex((Node)txIdTextField, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)txIdTextField, (Integer)columnIndex);
        GridPane.setMargin((Node)txIdTextField, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)txIdTextField);
        return new Tuple2((Object)label, (Object)txIdTextField);
    }

    public static Tuple3<Label, TxIdTextField, VBox> addTopLabelTxIdTextField(GridPane gridPane, int rowIndex, String title, double top) {
        TxIdTextField textField = new TxIdTextField();
        textField.setFocusTraversable(false);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)textField, top);
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)textField, (Object)((VBox)topLabelWithVBox.second));
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addCompactTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, String title, String value) {
        return FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, rowIndex, title, value, -23.0);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addCompactTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, int colIndex, String title, String value, double top) {
        return FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, rowIndex, colIndex, title, value, top - 23.0);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addCompactTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, int colIndex, String title) {
        return FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, rowIndex, colIndex, title, "", -23.0);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addCompactTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, int colIndex, String title, String value) {
        return FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, rowIndex, colIndex, title, value, -23.0);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addCompactTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, int colIndex, String title, String value, boolean onlyCopyTextAfterDelimiter) {
        return FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, rowIndex, colIndex, title, value, -23.0, onlyCopyTextAfterDelimiter);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, String title, String value) {
        return FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, rowIndex, title, value, 0.0);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, String title, String value, double top) {
        return FormBuilder.addTopLabelTextFieldWithCopyIcon(gridPane, rowIndex, title, value, top, null);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, String title, String value, double top, String styleClass) {
        TextFieldWithCopyIcon textFieldWithCopyIcon = new TextFieldWithCopyIcon(styleClass);
        textFieldWithCopyIcon.setText(value);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)textFieldWithCopyIcon, top);
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)textFieldWithCopyIcon);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, int colIndex, String title, String value, double top, boolean onlyCopyTextAfterDelimiter) {
        TextFieldWithCopyIcon textFieldWithCopyIcon = new TextFieldWithCopyIcon();
        textFieldWithCopyIcon.setText(value);
        textFieldWithCopyIcon.setCopyTextAfterDelimiter(true);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)textFieldWithCopyIcon, top);
        ((VBox)topLabelWithVBox.second).setAlignment(Pos.TOP_LEFT);
        GridPane.setColumnIndex((Node)((Node)topLabelWithVBox.second), (Integer)colIndex);
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)textFieldWithCopyIcon);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addTopLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, int colIndex, String title, String value, double top) {
        TextFieldWithCopyIcon textFieldWithCopyIcon = new TextFieldWithCopyIcon();
        textFieldWithCopyIcon.setText(value);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)textFieldWithCopyIcon, top);
        ((VBox)topLabelWithVBox.second).setAlignment(Pos.TOP_LEFT);
        GridPane.setColumnIndex((Node)((Node)topLabelWithVBox.second), (Integer)colIndex);
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)textFieldWithCopyIcon);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addConfirmationLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, String title, String value) {
        return FormBuilder.addConfirmationLabelTextFieldWithCopyIcon(gridPane, rowIndex, title, value, 0.0);
    }

    public static Tuple2<Label, TextFieldWithCopyIcon> addConfirmationLabelTextFieldWithCopyIcon(GridPane gridPane, int rowIndex, String title, String value, double top) {
        Label label = FormBuilder.addLabel(gridPane, rowIndex, title, top);
        label.getStyleClass().add((Object)"confirmation-label");
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        TextFieldWithCopyIcon textFieldWithCopyIcon = new TextFieldWithCopyIcon("confirmation-text-field-as-label");
        textFieldWithCopyIcon.setText(value);
        GridPane.setRowIndex((Node)textFieldWithCopyIcon, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)textFieldWithCopyIcon, (Integer)1);
        GridPane.setMargin((Node)textFieldWithCopyIcon, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)textFieldWithCopyIcon);
        return new Tuple2((Object)label, (Object)textFieldWithCopyIcon);
    }

    public static AddressTextField addAddressTextField(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addAddressTextField(gridPane, rowIndex, title, 0.0);
    }

    public static AddressTextField addAddressTextField(GridPane gridPane, int rowIndex, String title, double top) {
        AddressTextField addressTextField = new AddressTextField(title);
        GridPane.setRowIndex((Node)addressTextField, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)addressTextField, (Integer)0);
        GridPane.setMargin((Node)addressTextField, (Insets)new Insets(top + 20.0, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)addressTextField);
        return addressTextField;
    }

    public static FundsTextField addFundsTextfield(GridPane gridPane, int rowIndex, String text) {
        return FormBuilder.addFundsTextfield(gridPane, rowIndex, text, 0.0);
    }

    public static FundsTextField addFundsTextfield(GridPane gridPane, int rowIndex, String text, double top) {
        FundsTextField fundsTextField = new FundsTextField();
        fundsTextField.getTextField().setPromptText(text);
        GridPane.setRowIndex((Node)fundsTextField, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)fundsTextField, (Integer)0);
        GridPane.setMargin((Node)fundsTextField, (Insets)new Insets(top + 20.0, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)fundsTextField);
        return fundsTextField;
    }

    public static Tuple3<Label, InfoTextField, VBox> addCompactTopLabelInfoTextField(GridPane gridPane, int rowIndex, String labelText, String fieldText) {
        return FormBuilder.addTopLabelInfoTextField(gridPane, rowIndex, labelText, fieldText, -23.0);
    }

    public static Tuple3<Label, InfoTextField, VBox> addTopLabelInfoTextField(GridPane gridPane, int rowIndex, String labelText, String fieldText, double top) {
        InfoTextField infoTextField = new InfoTextField();
        infoTextField.setText(fieldText);
        Tuple2<Label, VBox> labelVBoxTuple2 = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, labelText, (Node)infoTextField, top);
        return new Tuple3((Object)((Label)labelVBoxTuple2.first), (Object)infoTextField, (Object)((VBox)labelVBoxTuple2.second));
    }

    public static BalanceTextField addBalanceTextField(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addBalanceTextField(gridPane, rowIndex, title, 20.0);
    }

    public static BalanceTextField addBalanceTextField(GridPane gridPane, int rowIndex, String title, double top) {
        BalanceTextField balanceTextField = new BalanceTextField(title);
        GridPane.setRowIndex((Node)balanceTextField, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)balanceTextField, (Integer)0);
        GridPane.setMargin((Node)balanceTextField, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)balanceTextField);
        return balanceTextField;
    }

    public static Tuple2<Label, Button> addTopLabelButton(GridPane gridPane, int rowIndex, String labelText, String buttonTitle) {
        return FormBuilder.addTopLabelButton(gridPane, rowIndex, labelText, buttonTitle, 0.0);
    }

    public static Tuple2<Label, Button> addTopLabelButton(GridPane gridPane, int rowIndex, String labelText, String buttonTitle, double top) {
        AutoTooltipButton button = new AutoTooltipButton(buttonTitle);
        button.setDefaultButton(true);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, labelText, (Node)button, top);
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)button);
    }

    public static Tuple2<Label, Button> addConfirmationLabelButton(GridPane gridPane, int rowIndex, String labelText, String buttonTitle, double top) {
        Label label = FormBuilder.addLabel(gridPane, rowIndex, labelText);
        label.getStyleClass().add((Object)"confirmation-label");
        AutoTooltipButton button = new AutoTooltipButton(buttonTitle);
        button.getStyleClass().add((Object)"confirmation-value");
        button.setDefaultButton(true);
        GridPane.setColumnIndex((Node)button, (Integer)1);
        GridPane.setRowIndex((Node)button, (Integer)rowIndex);
        GridPane.setMargin((Node)label, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        GridPane.setMargin((Node)button, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)button);
        return new Tuple2((Object)label, (Object)button);
    }

    public static Tuple3<Label, Button, Button> addTopLabel2Buttons(GridPane gridPane, int rowIndex, String labelText, String title1, String title2, double top) {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        AutoTooltipButton button1 = new AutoTooltipButton(title1);
        button1.setDefaultButton(true);
        button1.getStyleClass().add((Object)"action-button");
        button1.setDefaultButton(true);
        button1.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)button1, (Priority)Priority.ALWAYS);
        AutoTooltipButton button2 = new AutoTooltipButton(title2);
        button2.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)button2, (Priority)Priority.ALWAYS);
        hBox.getChildren().addAll((Object[])new Node[]{button1, button2});
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, labelText, (Node)hBox, top);
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)button1, (Object)button2);
    }

    public static Button addButton(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addButton(gridPane, rowIndex, title, 0.0);
    }

    public static Button addButtonAfterGroup(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addButton(gridPane, rowIndex, title, 15.0);
    }

    public static Button addPrimaryActionButton(GridPane gridPane, int rowIndex, String title, double top) {
        return FormBuilder.addButton(gridPane, rowIndex, title, top, true);
    }

    public static Button addPrimaryActionButtonAFterGroup(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addPrimaryActionButton(gridPane, rowIndex, title, 15.0);
    }

    public static Button addButton(GridPane gridPane, int rowIndex, String title, double top) {
        return FormBuilder.addButton(gridPane, rowIndex, title, top, false);
    }

    public static Button addButton(GridPane gridPane, int rowIndex, String title, double top, boolean isPrimaryAction) {
        AutoTooltipButton button = new AutoTooltipButton(title);
        if (isPrimaryAction) {
            button.setDefaultButton(true);
            button.getStyleClass().add((Object)"action-button");
        }
        GridPane.setRowIndex((Node)button, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)button, (Integer)0);
        gridPane.getChildren().add((Object)button);
        GridPane.setMargin((Node)button, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        return button;
    }

    public static Button addCloseButton(GridPane gridPane, int rowIndex, Runnable closeHandler) {
        Button closeButton = FormBuilder.addButtonAfterGroup(gridPane, rowIndex, Res.get((String)"shared.close"));
        GridPane.setColumnIndex((Node)closeButton, (Integer)1);
        GridPane.setHalignment((Node)closeButton, (HPos)HPos.RIGHT);
        closeButton.setOnAction(e -> closeHandler.run());
        return closeButton;
    }

    public static Tuple2<Button, Button> add2Buttons(GridPane gridPane, int rowIndex, String title1, String title2) {
        return FormBuilder.add2Buttons(gridPane, rowIndex, title1, title2, 0.0);
    }

    public static Tuple2<Button, Button> add2ButtonsAfterGroup(GridPane gridPane, int rowIndex, String title1, String title2) {
        return FormBuilder.add2ButtonsAfterGroup(gridPane, rowIndex, title1, title2, true);
    }

    public static Tuple2<Button, Button> add2ButtonsAfterGroup(GridPane gridPane, int rowIndex, String title1, String title2, boolean hasPrimaryButton) {
        return FormBuilder.add2Buttons(gridPane, rowIndex, title1, title2, 15.0, hasPrimaryButton);
    }

    public static Tuple2<Button, Button> add2Buttons(GridPane gridPane, int rowIndex, String title1, String title2, double top) {
        return FormBuilder.add2Buttons(gridPane, rowIndex, title1, title2, top, true);
    }

    public static Tuple2<Button, Button> add2Buttons(GridPane gridPane, int rowIndex, String title1, String title2, double top, boolean hasPrimaryButton) {
        Tuple3<Button, Button, HBox> buttonButtonHBoxTuple3 = FormBuilder.add2ButtonsWithBox(gridPane, rowIndex, title1, title2, top, hasPrimaryButton);
        return new Tuple2((Object)((Button)buttonButtonHBoxTuple3.first), (Object)((Button)buttonButtonHBoxTuple3.second));
    }

    public static Tuple3<Button, Button, HBox> add2ButtonsWithBox(GridPane gridPane, int rowIndex, String title1, String title2, double top, boolean hasPrimaryButton) {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        AutoTooltipButton button1 = new AutoTooltipButton(title1);
        if (hasPrimaryButton) {
            button1.getStyleClass().add((Object)"action-button");
            button1.setDefaultButton(true);
        }
        button1.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)button1, (Priority)Priority.ALWAYS);
        AutoTooltipButton button2 = new AutoTooltipButton(title2);
        button2.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)button2, (Priority)Priority.ALWAYS);
        hBox.getChildren().addAll((Object[])new Node[]{button1, button2});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)hBox, (Integer)0);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(top, 10.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple3((Object)button1, (Object)button2, (Object)hBox);
    }

    public static Tuple3<Button, Button, Button> add3Buttons(GridPane gridPane, int rowIndex, String title1, String title2, String title3) {
        return FormBuilder.add3Buttons(gridPane, rowIndex, title1, title2, title3, 0.0);
    }

    public static Tuple3<Button, Button, Button> add3ButtonsAfterGroup(GridPane gridPane, int rowIndex, String title1, String title2, String title3) {
        return FormBuilder.add3Buttons(gridPane, rowIndex, title1, title2, title3, 15.0);
    }

    public static Tuple3<Button, Button, Button> add3Buttons(GridPane gridPane, int rowIndex, String title1, String title2, String title3, double top) {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        AutoTooltipButton button1 = new AutoTooltipButton(title1);
        button1.getStyleClass().add((Object)"action-button");
        button1.setDefaultButton(true);
        button1.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)button1, (Priority)Priority.ALWAYS);
        AutoTooltipButton button2 = new AutoTooltipButton(title2);
        button2.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)button2, (Priority)Priority.ALWAYS);
        AutoTooltipButton button3 = new AutoTooltipButton(title3);
        button3.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)button3, (Priority)Priority.ALWAYS);
        hBox.getChildren().addAll((Object[])new Node[]{button1, button2, button3});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)hBox, (Integer)0);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(top, 10.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple3((Object)button1, (Object)button2, (Object)button3);
    }

    public static Tuple4<Button, BusyAnimation, Label, HBox> addButtonBusyAnimationLabelAfterGroup(GridPane gridPane, int rowIndex, int colIndex, String buttonTitle) {
        return FormBuilder.addButtonBusyAnimationLabel(gridPane, rowIndex, colIndex, buttonTitle, 15.0);
    }

    public static Tuple4<Button, BusyAnimation, Label, HBox> addButtonBusyAnimationLabelAfterGroup(GridPane gridPane, int rowIndex, String buttonTitle) {
        return FormBuilder.addButtonBusyAnimationLabelAfterGroup(gridPane, rowIndex, 0, buttonTitle);
    }

    public static Tuple4<Button, BusyAnimation, Label, HBox> addButtonBusyAnimationLabel(GridPane gridPane, int rowIndex, int colIndex, String buttonTitle, double top) {
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        AutoTooltipButton button = new AutoTooltipButton(buttonTitle);
        button.setDefaultButton(true);
        button.getStyleClass().add((Object)"action-button");
        BusyAnimation busyAnimation = new BusyAnimation(false);
        AutoTooltipLabel label = new AutoTooltipLabel();
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Object[])new Node[]{button, busyAnimation, label});
        GridPane.setRowIndex((Node)hBox, (Integer)rowIndex);
        GridPane.setHalignment((Node)hBox, (HPos)HPos.LEFT);
        GridPane.setColumnIndex((Node)hBox, (Integer)colIndex);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(top, 0.0, 0.0, 0.0));
        gridPane.getChildren().add((Object)hBox);
        return new Tuple4((Object)button, (Object)busyAnimation, (Object)label, (Object)hBox);
    }

    public static Tuple3<HBox, InputTextField, Label> getEditableValueBox(String promptText) {
        InputTextField input = new InputTextField(60.0);
        input.setPromptText(promptText);
        AutoTooltipLabel label = new AutoTooltipLabel(Res.getBaseCurrencyCode());
        label.getStyleClass().add((Object)"input-label");
        HBox.setMargin((Node)label, (Insets)new Insets(0.0, 8.0, 0.0, 0.0));
        HBox box = new HBox();
        HBox.setHgrow((Node)input, (Priority)Priority.ALWAYS);
        input.setMaxWidth(Double.MAX_VALUE);
        box.setAlignment(Pos.CENTER_LEFT);
        box.getStyleClass().add((Object)"offer-input");
        box.getChildren().addAll((Object[])new Node[]{input, label});
        return new Tuple3((Object)box, (Object)input, (Object)label);
    }

    public static Tuple3<HBox, InfoInputTextField, Label> getEditableValueBoxWithInfo(String promptText) {
        InfoInputTextField infoInputTextField = new InfoInputTextField(60.0);
        InputTextField input = infoInputTextField.getInputTextField();
        input.setPromptText(Utilities.toTruncatedString((Object)promptText, (int)28));
        AutoTooltipLabel label = new AutoTooltipLabel(Res.getBaseCurrencyCode());
        label.getStyleClass().add((Object)"input-label");
        HBox.setMargin((Node)label, (Insets)new Insets(0.0, 8.0, 0.0, 0.0));
        HBox box = new HBox();
        HBox.setHgrow((Node)infoInputTextField, (Priority)Priority.ALWAYS);
        infoInputTextField.setMaxWidth(Double.MAX_VALUE);
        box.setAlignment(Pos.CENTER_LEFT);
        box.getStyleClass().add((Object)"offer-input");
        box.getChildren().addAll((Object[])new Node[]{infoInputTextField, label});
        return new Tuple3((Object)box, (Object)infoInputTextField, (Object)label);
    }

    public static Tuple3<HBox, TextField, Label> getNonEditableValueBox() {
        Tuple3<HBox, InputTextField, Label> editableValueBox = FormBuilder.getEditableValueBox("");
        TextField textField = (TextField)editableValueBox.second;
        textField.setDisable(true);
        return new Tuple3((Object)((HBox)editableValueBox.first), (Object)((TextField)editableValueBox.second), (Object)((Label)editableValueBox.third));
    }

    public static Tuple3<HBox, InfoInputTextField, Label> getNonEditableValueBoxWithInfo() {
        Tuple3<HBox, InfoInputTextField, Label> editableValueBoxWithInfo = FormBuilder.getEditableValueBoxWithInfo("");
        InputTextField textField = ((InfoInputTextField)((Object)editableValueBoxWithInfo.second)).getInputTextField();
        textField.setDisable(true);
        return editableValueBoxWithInfo;
    }

    public static Tuple2<Label, VBox> getTradeInputBox(Pane amountValueBox, String descriptionText) {
        AutoTooltipLabel descriptionLabel = new AutoTooltipLabel(descriptionText);
        descriptionLabel.setId("input-description-label");
        descriptionLabel.setPrefWidth(190.0);
        VBox box = new VBox();
        box.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        box.setSpacing(2.0);
        box.getChildren().addAll((Object[])new Node[]{descriptionLabel, amountValueBox});
        return new Tuple2((Object)descriptionLabel, (Object)box);
    }

    public static <T> Tuple3<Label, ListView<T>, VBox> addTopLabelListView(GridPane gridPane, int rowIndex, String title) {
        return FormBuilder.addTopLabelListView(gridPane, rowIndex, title, 0.0);
    }

    public static <T> Tuple3<Label, ListView<T>, VBox> addTopLabelListView(GridPane gridPane, int rowIndex, String title, double top) {
        ListView listView = new ListView();
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)listView, top);
        return new Tuple3((Object)((Label)topLabelWithVBox.first), (Object)listView, (Object)((VBox)topLabelWithVBox.second));
    }

    public static Tuple2<Label, FlowPane> addTopLabelFlowPane(GridPane gridPane, int rowIndex, String title, double top) {
        return FormBuilder.addTopLabelFlowPane(gridPane, rowIndex, title, top, 0.0);
    }

    public static Tuple2<Label, FlowPane> addTopLabelFlowPane(GridPane gridPane, int rowIndex, String title, double top, double bottom) {
        FlowPane flowPane = new FlowPane();
        flowPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        flowPane.setVgap(10.0);
        flowPane.setHgap(10.0);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(gridPane, rowIndex, title, (Node)flowPane, top);
        GridPane.setMargin((Node)((Node)topLabelWithVBox.second), (Insets)new Insets(top + 23.0, 0.0, bottom, 0.0));
        return new Tuple2((Object)((Label)topLabelWithVBox.first), (Object)flowPane);
    }

    public static void removeRowFromGridPane(GridPane gridPane, int gridRow) {
        FormBuilder.removeRowsFromGridPane(gridPane, gridRow, gridRow);
    }

    public static void removeRowsFromGridPane(GridPane gridPane, int fromGridRow, int toGridRow) {
        CopyOnWriteArraySet nodes = new CopyOnWriteArraySet(gridPane.getChildren());
        nodes.stream().filter(e -> GridPane.getRowIndex((Node)e) != null && GridPane.getRowIndex((Node)e) >= fromGridRow && GridPane.getRowIndex((Node)e) <= toGridRow).forEach(e -> gridPane.getChildren().remove(e));
    }

    public static Text getIconForLabel(GlyphIcons icon, String iconSize, Label label, String style) {
        if (icon.fontFamily().equals(MATERIAL_DESIGN_ICONS)) {
            Text textIcon = MaterialDesignIconFactory.get().createIcon(icon, iconSize);
            textIcon.setOpacity(0.7);
            if (style != null) {
                textIcon.getStyleClass().add((Object)style);
            }
            label.setContentDisplay(ContentDisplay.LEFT);
            label.setGraphic((Node)textIcon);
            return textIcon;
        }
        throw new IllegalArgumentException("Not supported icon type");
    }

    public static Text getIconForLabel(GlyphIcons icon, String iconSize, Label label) {
        return FormBuilder.getIconForLabel(icon, iconSize, label, null);
    }

    public static Text getSmallIconForLabel(GlyphIcons icon, Label label, String style) {
        return FormBuilder.getIconForLabel(icon, "0.769em", label, style);
    }

    public static Text getSmallIconForLabel(GlyphIcons icon, Label label) {
        return FormBuilder.getIconForLabel(icon, "0.769em", label);
    }

    public static Text getRegularIconForLabel(GlyphIcons icon, Label label) {
        return FormBuilder.getRegularIconForLabel(icon, label, null);
    }

    public static Text getRegularIconForLabel(GlyphIcons icon, Label label, String styleClass) {
        return FormBuilder.getIconForLabel(icon, "1.231em", label, styleClass);
    }

    public static Text getIcon(GlyphIcons icon) {
        return FormBuilder.getIcon(icon, "1.231em");
    }

    public static Text getBigIcon(GlyphIcons icon) {
        return FormBuilder.getIcon(icon, "2em");
    }

    public static Text getMediumSizeIcon(GlyphIcons icon) {
        return FormBuilder.getIcon(icon, "1.5em");
    }

    public static Text getIcon(GlyphIcons icon, String iconSize) {
        if (!icon.fontFamily().equals(MATERIAL_DESIGN_ICONS)) {
            throw new IllegalArgumentException("Not supported icon type");
        }
        Text textIcon = MaterialDesignIconFactory.get().createIcon(icon, iconSize);
        return textIcon;
    }

    public static Label getIcon(AwesomeIcon icon) {
        Label label = new Label();
        AwesomeDude.setIcon((Label)label, (AwesomeIcon)icon);
        return label;
    }

    public static Label getIcon(AwesomeIcon icon, String fontSize) {
        return FormBuilder.getIconForLabel(icon, new Label(), fontSize);
    }

    public static Label getSmallIcon(AwesomeIcon icon) {
        return FormBuilder.getIcon(icon, "1em");
    }

    public static Label getIconForLabel(AwesomeIcon icon, Label label, String fontSize) {
        AwesomeDude.setIcon((Label)label, (AwesomeIcon)icon, (String)fontSize);
        return label;
    }

    public static Button getIconButton(GlyphIcons icon) {
        return FormBuilder.getIconButton(icon, "highlight");
    }

    public static Button getIconButton(GlyphIcons icon, String styleClass) {
        return FormBuilder.getIconButton(icon, styleClass, "2em");
    }

    public static Button getRegularIconButton(GlyphIcons icon) {
        return FormBuilder.getIconButton(icon, "highlight", "1.6em");
    }

    public static Button getRegularIconButton(GlyphIcons icon, String styleClass) {
        return FormBuilder.getIconButton(icon, styleClass, "1.6em");
    }

    public static Button getIconButton(GlyphIcons icon, String styleClass, String iconSize) {
        if (icon.fontFamily().equals(MATERIAL_DESIGN_ICONS)) {
            Button iconButton = MaterialDesignIconFactory.get().createIconButton(icon, "", iconSize, null, ContentDisplay.CENTER);
            iconButton.setId("icon-button");
            iconButton.getGraphic().getStyleClass().add((Object)styleClass);
            iconButton.setPrefWidth(20.0);
            iconButton.setPrefHeight(20.0);
            iconButton.setPadding(new Insets(0.0));
            return iconButton;
        }
        throw new IllegalArgumentException("Not supported icon type");
    }

    public static <T> TableView<T> addTableViewWithHeader(GridPane gridPane, int rowIndex, String headerText) {
        return FormBuilder.addTableViewWithHeader(gridPane, rowIndex, headerText, 0, null);
    }

    public static <T> TableView<T> addTableViewWithHeader(GridPane gridPane, int rowIndex, String headerText, String groupStyle) {
        return FormBuilder.addTableViewWithHeader(gridPane, rowIndex, headerText, 0, groupStyle);
    }

    public static <T> TableView<T> addTableViewWithHeader(GridPane gridPane, int rowIndex, String headerText, int top) {
        return FormBuilder.addTableViewWithHeader(gridPane, rowIndex, headerText, top, null);
    }

    public static <T> TableView<T> addTableViewWithHeader(GridPane gridPane, int rowIndex, String headerText, int top, String groupStyle) {
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg(gridPane, rowIndex, 1, headerText, top);
        if (groupStyle != null) {
            titledGroupBg.getStyleClass().add((Object)groupStyle);
        }
        TableView tableView = new TableView();
        GUIUtil.applyTableStyle(tableView);
        GridPane.setRowIndex((Node)tableView, (Integer)rowIndex);
        GridPane.setMargin((Node)tableView, (Insets)new Insets((double)(top + 30), -10.0, 5.0, -10.0));
        gridPane.getChildren().add((Object)tableView);
        tableView.setPlaceholder((Node)new AutoTooltipLabel(Res.get((String)"table.placeholder.noData")));
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        return tableView;
    }
}

