/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import haveno.common.crypto.PubKeyRing;
import haveno.core.account.witness.AccountAgeWitness;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.FormattingUtils;
import haveno.core.util.ParsingUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.bitcoinj.core.Coin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayUtils {
    private static final Logger log = LoggerFactory.getLogger(DisplayUtils.class);
    private static final int SCALE = 3;
    private static final String LOCKED = ".locked";

    public static String formatDateTime(Date date) {
        return FormattingUtils.formatDateTime((Date)date, (boolean)true);
    }

    public static String formatDateTimeSpan(Date dateFrom, Date dateTo) {
        if (dateFrom != null && dateTo != null) {
            DateFormat dateFormatter = DateFormat.getDateInstance(2, GlobalSettings.getLocale());
            DateFormat timeFormatter = DateFormat.getTimeInstance(2, GlobalSettings.getLocale());
            return dateFormatter.format(dateFrom) + " " + timeFormatter.format(dateFrom) + " - " + timeFormatter.format(dateTo);
        }
        return "";
    }

    public static String formatTime(Date date) {
        if (date != null) {
            DateFormat timeFormatter = DateFormat.getTimeInstance(2, GlobalSettings.getLocale());
            return timeFormatter.format(date);
        }
        return "";
    }

    public static String formatDate(Date date) {
        if (date != null) {
            DateFormat dateFormatter = DateFormat.getDateInstance(2, GlobalSettings.getLocale());
            return dateFormatter.format(date);
        }
        return "";
    }

    public static String formatDateAxis(Date date, String format) {
        if (date != null) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(format, GlobalSettings.getLocale());
            return dateFormatter.format(date);
        }
        return "";
    }

    public static String getAccountWitnessDescription(AccountAgeWitnessService accountAgeWitnessService, PaymentMethod paymentMethod, PaymentAccountPayload paymentAccountPayload, PubKeyRing pubKeyRing) {
        Object description = Res.get((String)"peerInfoIcon.tooltip.unknownAge");
        Optional aaw = accountAgeWitnessService.findWitness(paymentAccountPayload, pubKeyRing);
        if (aaw.isPresent()) {
            long accountAge = accountAgeWitnessService.getAccountAge((AccountAgeWitness)aaw.get(), new Date());
            long signAge = -1L;
            if (PaymentMethod.hasChargebackRisk((PaymentMethod)paymentMethod)) {
                signAge = accountAgeWitnessService.getWitnessSignAge((AccountAgeWitness)aaw.get(), new Date());
            }
            if (signAge > -1L) {
                description = Res.get((String)"peerInfo.age.chargeBackRisk") + ": " + DisplayUtils.formatAccountAge(signAge);
            } else if (accountAge > -1L) {
                description = Res.get((String)"peerInfoIcon.tooltip.age", (Object[])new Object[]{DisplayUtils.formatAccountAge(accountAge)});
                if (PaymentMethod.hasChargebackRisk((PaymentMethod)paymentMethod)) {
                    description = (String)description + ", " + Res.get((String)"offerbook.timeSinceSigning.notSigned");
                }
            }
        }
        return description;
    }

    public static String formatAccountAge(long durationMillis) {
        durationMillis = Math.max(0L, durationMillis);
        String day = Res.get((String)"time.day").toLowerCase();
        String days = Res.get((String)"time.days");
        String format = " d' " + days + "'";
        return StringUtils.strip((String)StringUtils.replaceOnce((String)DurationFormatUtils.formatDuration((long)durationMillis, (String)format), (String)(" 1 " + days), (String)(" 1 " + day)));
    }

    public static String booleanToYesNo(boolean value) {
        return value ? Res.get((String)"shared.yes") : Res.get((String)"shared.no");
    }

    public static String getDirectionWithCode(OfferDirection direction, String currencyCode, boolean isPrivate) {
        return direction == OfferDirection.BUY ? Res.get((String)("shared.buyCurrency" + (isPrivate ? LOCKED : "")), (Object[])new Object[]{Res.getBaseCurrencyCode()}) : Res.get((String)("shared.sellCurrency" + (isPrivate ? LOCKED : "")), (Object[])new Object[]{Res.getBaseCurrencyCode()});
    }

    public static String getDirectionBothSides(OfferDirection direction, boolean isPrivate) {
        String currencyCode = Res.getBaseCurrencyCode();
        return direction == OfferDirection.BUY ? Res.get((String)("formatter.makerTaker" + (isPrivate ? LOCKED : "")), (Object[])new Object[]{currencyCode, Res.get((String)"shared.buyer"), currencyCode, Res.get((String)"shared.seller")}) : Res.get((String)("formatter.makerTaker" + (isPrivate ? LOCKED : "")), (Object[])new Object[]{currencyCode, Res.get((String)"shared.seller"), currencyCode, Res.get((String)"shared.buyer")});
    }

    public static String getDirectionForBuyer(boolean isMyOffer, String currencyCode) {
        String code = Res.getBaseCurrencyCode();
        return isMyOffer ? Res.get((String)"formatter.youAreAsMaker", (Object[])new Object[]{Res.get((String)"shared.buyer"), code, Res.get((String)"shared.seller"), code}) : Res.get((String)"formatter.youAreAsTaker", (Object[])new Object[]{Res.get((String)"shared.buyer"), code, Res.get((String)"shared.seller"), code});
    }

    public static String getDirectionForSeller(boolean isMyOffer, String currencyCode) {
        String code = Res.getBaseCurrencyCode();
        return isMyOffer ? Res.get((String)"formatter.youAreAsMaker", (Object[])new Object[]{Res.get((String)"shared.seller"), code, Res.get((String)"shared.buyer"), code}) : Res.get((String)"formatter.youAreAsTaker", (Object[])new Object[]{Res.get((String)"shared.seller"), code, Res.get((String)"shared.buyer"), code});
    }

    public static String getDirectionForTakeOffer(OfferDirection direction, String currencyCode) {
        String baseCurrencyCode = Res.getBaseCurrencyCode();
        return direction == OfferDirection.BUY ? Res.get((String)"formatter.youAre", (Object[])new Object[]{Res.get((String)"shared.selling"), baseCurrencyCode, Res.get((String)"shared.buying"), currencyCode}) : Res.get((String)"formatter.youAre", (Object[])new Object[]{Res.get((String)"shared.buying"), baseCurrencyCode, Res.get((String)"shared.selling"), currencyCode});
    }

    public static String getOfferDirectionForCreateOffer(OfferDirection direction, String currencyCode, boolean isPrivate) {
        String baseCurrencyCode = Res.getBaseCurrencyCode();
        return direction == OfferDirection.BUY ? Res.get((String)("formatter.youAreCreatingAnOffer.traditional" + (isPrivate ? LOCKED : "")), (Object[])new Object[]{Res.get((String)"shared.buy"), baseCurrencyCode}) : Res.get((String)("formatter.youAreCreatingAnOffer.traditional" + (isPrivate ? LOCKED : "")), (Object[])new Object[]{Res.get((String)"shared.sell"), baseCurrencyCode});
    }

    public static String formatAmount(Offer offer, CoinFormatter coinFormatter) {
        return offer.isRange() ? HavenoUtils.formatXmr((BigInteger)offer.getMinAmount()) + " - " + HavenoUtils.formatXmr((BigInteger)offer.getAmount()) : HavenoUtils.formatXmr((BigInteger)offer.getAmount());
    }

    public static String formatAmount(Offer offer, int decimalPlaces, boolean decimalAligned, int maxPlaces, CoinFormatter coinFormatter) {
        String formattedAmount;
        String string = formattedAmount = offer.isRange() ? HavenoUtils.formatXmr((BigInteger)offer.getMinAmount(), (int)decimalPlaces) + " - " + HavenoUtils.formatXmr((BigInteger)offer.getAmount(), (int)decimalPlaces) : HavenoUtils.formatXmr((BigInteger)offer.getAmount(), (int)decimalPlaces);
        if (decimalAligned) {
            formattedAmount = FormattingUtils.fillUpPlacesWithEmptyStrings((String)formattedAmount, (int)maxPlaces);
        }
        return formattedAmount;
    }

    public static String formatPrice(Price price, Boolean decimalAligned, int maxPlaces) {
        String formattedPrice = FormattingUtils.formatPrice((Price)price);
        if (decimalAligned.booleanValue()) {
            formattedPrice = FormattingUtils.fillUpPlacesWithEmptyStrings((String)formattedPrice, (int)maxPlaces);
        }
        return formattedPrice;
    }

    public static String getFeeWithFiatAmount(BigInteger makerFee, Optional<Volume> optionalFeeInFiat, CoinFormatter formatter) {
        String feeInXmr;
        String string = feeInXmr = makerFee != null ? HavenoUtils.formatXmr((BigInteger)makerFee, (boolean)true) : Res.get((String)"shared.na");
        if (optionalFeeInFiat != null && optionalFeeInFiat.isPresent()) {
            String feeInFiat = VolumeUtil.formatAverageVolumeWithCode((Volume)optionalFeeInFiat.get());
            return Res.get((String)"feeOptionWindow.fee", (Object[])new Object[]{feeInXmr, feeInFiat});
        }
        return feeInXmr;
    }

    public static Coin parseToCoinWith4Decimals(String input, CoinFormatter coinFormatter) {
        try {
            return Coin.valueOf((long)new BigDecimal(ParsingUtils.parseToCoin((String)ParsingUtils.cleanDoubleInput((String)input), (CoinFormatter)coinFormatter).value).setScale(-4, RoundingMode.HALF_UP).setScale(4, RoundingMode.HALF_UP).toBigInteger().longValue());
        }
        catch (Throwable t) {
            if (input != null && input.length() > 0) {
                log.warn("Exception at parseToCoinWith4Decimals: " + t.toString());
            }
            return Coin.ZERO;
        }
    }

    public static boolean hasBtcValidDecimals(String input, CoinFormatter coinFormatter) {
        return ParsingUtils.parseToCoin((String)input, (CoinFormatter)coinFormatter).equals((Object)DisplayUtils.parseToCoinWith4Decimals(input, coinFormatter));
    }

    public static Coin reduceTo4Decimals(Coin coin, CoinFormatter coinFormatter) {
        return ParsingUtils.parseToCoin((String)coinFormatter.formatCoin(coin), (CoinFormatter)coinFormatter);
    }

    public static String createAccountName(String paymentMethodId, String name) {
        name = name.trim();
        name = StringUtils.abbreviate((String)name, (int)9);
        String method = Res.get((String)paymentMethodId);
        return method.concat(": ").concat(name);
    }

    public static String createAssetsAccountName(PaymentAccount paymentAccount, String address) {
        String currency = paymentAccount.getSingleTradeCurrency() != null ? paymentAccount.getSingleTradeCurrency().getCode() : "";
        return DisplayUtils.createAssetsAccountName(currency, address);
    }

    public static String createAssetsAccountName(String currency, String address) {
        address = StringUtils.abbreviate((String)address, (int)9);
        return currency.concat(": ").concat(address);
    }
}

