/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;

public class CurrencyListItem {
    public final TradeCurrency tradeCurrency;
    public final int numTrades;

    public CurrencyListItem(TradeCurrency tradeCurrency, int numTrades) {
        this.tradeCurrency = tradeCurrency;
        this.numTrades = numTrades;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrencyListItem that = (CurrencyListItem)o;
        if (this.numTrades != that.numTrades) {
            return false;
        }
        return !(this.tradeCurrency == null ? that.tradeCurrency != null : !this.tradeCurrency.equals((Object)that.tradeCurrency));
    }

    public int hashCode() {
        int result = this.tradeCurrency != null ? this.tradeCurrency.hashCode() : 0;
        result = 31 * result + this.numTrades;
        return result;
    }

    public String toString() {
        return "CurrencyListItem{tradeCurrency=" + String.valueOf(this.tradeCurrency) + ", numTrades=" + this.numTrades + "}";
    }

    public String codeDashNameString() {
        if (this.isSpecialShowAllItem()) {
            return Res.get((String)"list.currency.showAll");
        }
        return this.tradeCurrency.getName() + " (" + this.tradeCurrency.getCode() + ")";
    }

    private boolean isSpecialShowAllItem() {
        return this.tradeCurrency.getCode().equals("list.currency.showAll");
    }
}

