/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import com.google.common.collect.Lists;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.user.Preferences;
import haveno.desktop.util.CurrencyListItem;
import haveno.desktop.util.CurrencyPredicates;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;

public class CurrencyList {
    private final CurrencyPredicates predicates;
    private final Preferences preferences;
    private final List<CurrencyListItem> delegate;

    public CurrencyList(Preferences preferences) {
        this(new ArrayList<CurrencyListItem>(), preferences, new CurrencyPredicates());
    }

    public CurrencyList(List<CurrencyListItem> delegate, Preferences preferences, CurrencyPredicates predicates) {
        this.delegate = delegate;
        this.predicates = predicates;
        this.preferences = preferences;
    }

    public ObservableList<CurrencyListItem> getObservableList() {
        return FXCollections.observableList(this.delegate);
    }

    public void updateWithCurrencies(List<TradeCurrency> currencies, @Nullable CurrencyListItem first) {
        LinkedList result = Lists.newLinkedList();
        Optional.ofNullable(first).ifPresent(result::add);
        result.addAll(this.getPartitionedSortedItems(currencies));
        this.delegate.clear();
        this.delegate.addAll(result);
    }

    private List<CurrencyListItem> getPartitionedSortedItems(List<TradeCurrency> currencies) {
        Map<TradeCurrency, Integer> tradesPerCurrency = this.countTrades(currencies);
        ArrayList<CurrencyListItem> fiatCurrencies = new ArrayList<CurrencyListItem>();
        ArrayList<CurrencyListItem> traditionalCurrencies = new ArrayList<CurrencyListItem>();
        ArrayList<CurrencyListItem> cryptoCurrencies = new ArrayList<CurrencyListItem>();
        for (Map.Entry<TradeCurrency, Integer> entry : tradesPerCurrency.entrySet()) {
            TradeCurrency currency = entry.getKey();
            Integer count = entry.getValue();
            CurrencyListItem item = new CurrencyListItem(currency, count);
            if (this.predicates.isFiatCurrency(currency)) {
                fiatCurrencies.add(item);
            } else if (this.predicates.isTraditionalCurrency(currency)) {
                traditionalCurrencies.add(item);
            }
            if (!this.predicates.isCryptoCurrency(currency)) continue;
            cryptoCurrencies.add(item);
        }
        Comparator<CurrencyListItem> comparator = this.getComparator();
        fiatCurrencies.sort(comparator);
        traditionalCurrencies.sort(comparator);
        cryptoCurrencies.sort(comparator);
        ArrayList<CurrencyListItem> result = new ArrayList<CurrencyListItem>();
        result.addAll(fiatCurrencies);
        result.addAll(traditionalCurrencies);
        result.addAll(cryptoCurrencies);
        return result;
    }

    private Comparator<CurrencyListItem> getComparator() {
        if (this.preferences.isSortMarketCurrenciesNumerically()) {
            return Comparator.comparingInt(item -> item.numTrades).reversed().thenComparing(item -> CurrencyUtil.isCryptoCurrency((String)item.tradeCurrency.getCode()) ? item.tradeCurrency.getName() : item.tradeCurrency.getCode());
        }
        return Comparator.comparing(item -> CurrencyUtil.isCryptoCurrency((String)item.tradeCurrency.getCode()) ? item.tradeCurrency.getName() : item.tradeCurrency.getCode());
    }

    private Map<TradeCurrency, Integer> countTrades(List<TradeCurrency> currencies) {
        HashMap<TradeCurrency, Integer> result = new HashMap<TradeCurrency, Integer>();
        BiFunction<TradeCurrency, Integer, Integer> incrementCurrentOrOne = (key, value) -> value == null ? 1 : value + 1;
        currencies.forEach(currency -> result.compute((TradeCurrency)currency, incrementCurrentOrOne));
        HashSet preferred = new HashSet();
        preferred.addAll(this.preferences.getTraditionalCurrencies());
        preferred.addAll(this.preferences.getCryptoCurrencies());
        preferred.forEach(currency -> result.putIfAbsent((TradeCurrency)currency, 0));
        return result;
    }
}

