/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.util;

import haveno.common.util.Tuple2;
import haveno.core.util.InlierUtil;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;

public class AxisInlierUtils {
    public static ListChangeListener<XYChart.Data<Number, Number>> getListenerThatZoomsToInliers(NumberAxis axis, int maxNumberOfTicks, double percentToTrim, double howManyStdDevsConstituteOutlier) {
        return change -> {
            boolean axisHasBeenInitialized;
            boolean bl = axisHasBeenInitialized = axis != null;
            if (axisHasBeenInitialized) {
                AxisInlierUtils.zoomToInliers(axis, (ObservableList<? extends XYChart.Data<Number, Number>>)change.getList(), maxNumberOfTicks, percentToTrim, howManyStdDevsConstituteOutlier);
            }
        };
    }

    public static void zoomToInliers(NumberAxis yAxis, ObservableList<? extends XYChart.Data<Number, Number>> xyValues, int maxNumberOfTicks, double percentToTrim, double howManyStdDevsConstituteOutlier) {
        List<Double> yValues = AxisInlierUtils.extractYValues(xyValues);
        if (yValues.size() < 3) {
            return;
        }
        Tuple2 inlierRange = InlierUtil.findInlierRange(yValues, (double)percentToTrim, (double)howManyStdDevsConstituteOutlier);
        AxisInlierUtils.applyRange(yAxis, maxNumberOfTicks, (Tuple2<Double, Double>)inlierRange);
    }

    private static List<Double> extractYValues(ObservableList<? extends XYChart.Data<Number, Number>> xyValues) {
        return xyValues.stream().map(xyData -> (double)((Double)((Number)xyData.getYValue()))).collect(Collectors.toList());
    }

    private static void applyRange(NumberAxis axis, int maxNumberOfTicks, Tuple2<Double, Double> bounds) {
        double boundsWidth = AxisInlierUtils.getBoundsWidth(bounds);
        if (boundsWidth < 0.0) {
            throw new IllegalArgumentException("The lower bound must be a smaller number than the upper bound");
        }
        if (boundsWidth == 0.0 || Double.isNaN(boundsWidth)) {
            return;
        }
        axis.setAutoRanging(false);
        Double lowerBound = (Double)bounds.first;
        Double upperBound = (Double)bounds.second;
        if (lowerBound > 0.0) {
            lowerBound = 0.0;
        } else if (upperBound < 0.0) {
            upperBound = 0.0;
        }
        axis.setLowerBound(lowerBound.doubleValue());
        axis.setUpperBound(upperBound.doubleValue());
        double referenceTickUnit = AxisInlierUtils.computeReferenceTickUnit(maxNumberOfTicks, bounds);
        double tickUnit = AxisInlierUtils.computeTickUnit(referenceTickUnit);
        axis.setTickUnit(tickUnit);
    }

    private static double computeReferenceTickUnit(int maxNumberOfTicks, Tuple2<Double, Double> bounds) {
        if (maxNumberOfTicks <= 0) {
            throw new IllegalArgumentException("maxNumberOfTicks must be a positive number");
        }
        double width = AxisInlierUtils.getBoundsWidth(bounds);
        return width / (double)maxNumberOfTicks;
    }

    private static double computeTickUnit(double referenceTickUnit) {
        if (referenceTickUnit <= 0.0) {
            throw new IllegalArgumentException("The reference tick unit must be a positive number");
        }
        double[] multipliers = new double[]{1.0, 2.5, 5.0};
        int BASE = 10;
        int exp = (int)Math.floor(Math.log10(referenceTickUnit));
        double factor = referenceTickUnit / Math.pow(BASE, exp);
        double multiplier = 0.0;
        int lastIndex = multipliers.length - 1;
        if (factor > multipliers[lastIndex]) {
            ++exp;
            multiplier = multipliers[0];
        } else {
            for (int i = lastIndex; i >= 0 && factor <= multipliers[i]; --i) {
                multiplier = multipliers[i];
            }
        }
        return multiplier * Math.pow(BASE, exp);
    }

    private static double getBoundsWidth(Tuple2<Double, Double> bounds) {
        Double lowerBound = (Double)bounds.first;
        Double upperBound = (Double)bounds.second;
        return Math.abs(upperBound - lowerBound);
    }
}

