/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.support.dispute.client.mediation;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.crypto.KeyRing;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.Res;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeSession;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.dispute.mediation.MediationSession;
import haveno.core.trade.Contract;
import haveno.core.trade.TradeManager;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.ContractWindow;
import haveno.desktop.main.overlays.windows.DisputeSummaryWindow;
import haveno.desktop.main.overlays.windows.TradeDetailsWindow;
import haveno.desktop.main.support.dispute.client.DisputeClientView;
import haveno.network.p2p.NodeAddress;

@FxmlView
public class MediationClientView
extends DisputeClientView {
    @Inject
    public MediationClientView(MediationManager mediationManager, KeyRing keyRing, TradeManager tradeManager, @Named(value="BTC") CoinFormatter formatter, Preferences preferences, DisputeSummaryWindow disputeSummaryWindow, PrivateNotificationManager privateNotificationManager, ContractWindow contractWindow, TradeDetailsWindow tradeDetailsWindow, AccountAgeWitnessService accountAgeWitnessService, ArbitratorManager arbitratorManager, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        super((DisputeManager<? extends DisputeList<Dispute>>)mediationManager, keyRing, tradeManager, formatter, preferences, disputeSummaryWindow, privateNotificationManager, contractWindow, tradeDetailsWindow, accountAgeWitnessService, arbitratorManager, useDevPrivilegeKeys);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.reOpenButton.setVisible(true);
        this.reOpenButton.setManaged(true);
        this.closeButton.setVisible(true);
        this.closeButton.setManaged(true);
        this.setupReOpenDisputeListener();
    }

    @Override
    protected void activate() {
        super.activate();
        this.activateReOpenDisputeListener();
    }

    @Override
    protected void deactivate() {
        super.deactivate();
        this.deactivateReOpenDisputeListener();
    }

    @Override
    protected SupportType getType() {
        return SupportType.MEDIATION;
    }

    @Override
    protected DisputeSession getConcreteDisputeChatSession(Dispute dispute) {
        return new MediationSession(dispute, this.disputeManager.isTrader(dispute));
    }

    @Override
    protected void reOpenDisputeFromButton() {
        ((Popup)((Popup)((Popup)new Popup().attention(Res.get((String)"support.reOpenByTrader.prompt"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> this.reOpenDispute())).show();
    }

    @Override
    protected NodeAddress getAgentNodeAddress(Contract contract) {
        throw new RuntimeException("MediationClientView.getAgentNodeAddress() not implementd for XMR");
    }

    @Override
    protected void maybeAddAgentColumn() {
        this.tableView.getColumns().add(this.getAgentColumn());
    }
}

